/*
 * Decompiled with CFR 0.152.
 */
package com.spygstudios.chestshop;

import com.spygstudios.chestshop.ChestShop;
import com.spygstudios.chestshop.config.GuiConfig;
import com.spygstudios.chestshop.config.Message;
import com.spygstudios.spyglib.color.TranslateColor;
import com.spygstudios.spyglib.components.ComponentUtils;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class PageUtil {
    public static Component getPages(int page, int allPages, int elementPerPage, String command) {
        int pages = (int)Math.ceil((double)allPages / (double)elementPerPage);
        if (pages < page || page < 1) {
            return ComponentUtils.replaceComponent((Component)Message.SHOP_INVALID_PAGE.get(), Map.of("%page%", "" + page));
        }
        Component back = Message.SHOP_LIST_BACK.get().clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)(command + " " + (page - 1))));
        Component next = Message.SHOP_LIST_NEXT.get().clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)(command + " " + (page + 1))));
        TextComponent.Builder pagesComponent = Component.text();
        int i = 0;
        while (i < pages) {
            if (i + 1 == page) {
                pagesComponent.append(ComponentUtils.replaceComponent((Component)Message.SHOP_LIST_CURRENT_PAGE.get(), (String)"%page%", (String)String.valueOf(i + 1)));
            } else {
                ((TextComponent.Builder)pagesComponent.append(ComponentUtils.replaceComponent((Component)Message.SHOP_LIST_PAGE.get(), (String)"%page%", (String)String.valueOf(i + 1)))).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)(command + " " + (i + 1))));
            }
            ++i;
        }
        if (pages == 1) {
            return pagesComponent.build();
        }
        if (page < pages && page == 1) {
            return ((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)pagesComponent.build())).append(next)).build();
        }
        if (page < pages) {
            return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(back)).append((Component)pagesComponent.build())).append(next)).build();
        }
        return ((TextComponent.Builder)((TextComponent.Builder)Component.text().append(back)).append((Component)pagesComponent.build())).build();
    }

    public static void setFillItems(Inventory inventory, String configPath) {
        GuiConfig config = ChestShop.getInstance().getGuiConfig();
        config.getConfigurationSection(configPath + ".fill-items").getKeys(false).forEach(key -> {
            String itemPath = configPath + ".fill-items." + key;
            Material material = Material.getMaterial((String)config.getString(itemPath + ".material"));
            if (material == null) {
                ChestShop.getInstance().getLogger().warning("Invalid material in " + configPath + " fill-items: " + config.getString(itemPath + ".material"));
                return;
            }
            List slots = config.getStringList(itemPath + ".slots");
            ItemStack fillerItem = new ItemStack(material);
            for (String s : slots) {
                int slot = Integer.parseInt(s);
                if (slot < 0 || slot >= inventory.getSize()) {
                    ChestShop.getInstance().getLogger().warning("Invalid slot in " + configPath + " fill-items: " + s);
                    continue;
                }
                if (inventory.getItem(slot) != null) {
                    ChestShop.getInstance().getLogger().warning("Slot " + slot + " is already occupied in " + configPath + " fill-items.");
                    continue;
                }
                ItemMeta glassMeta = fillerItem.getItemMeta();
                glassMeta.displayName(TranslateColor.translate((String)"&7"));
                fillerItem.setItemMeta(glassMeta);
                inventory.setItem(slot, fillerItem);
            }
        });
    }

    @Generated
    private PageUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

