/*
 * Decompiled with CFR 0.152.
 */
package com.spygstudios.chestshop.commands;

import com.spygstudios.chestshop.PageUtil;
import com.spygstudios.chestshop.config.Message;
import com.spygstudios.chestshop.shop.Shop;
import com.spygstudios.chestshop.shop.ShopFile;
import com.spygstudios.spyglib.components.ComponentUtils;
import dev.rollczi.litecommands.annotations.command.Command;
import dev.rollczi.litecommands.annotations.context.Context;
import dev.rollczi.litecommands.annotations.execute.Execute;
import dev.rollczi.litecommands.annotations.optional.OptionalArg;
import dev.rollczi.litecommands.annotations.permission.Permission;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.entity.Player;

@Command(name="spygchestshop list", aliases={"spcs list", "chestshop list", "scs list"})
public class ShopList {
    @Execute
    @Permission(value={"spygchestshop.use"})
    public void onList(@Context Player player, @OptionalArg Integer page) {
        ShopFile file;
        if (page == null) {
            page = 1;
        }
        if ((file = ShopFile.getShopFile(player)) == null || file.getPlayerShops().isEmpty()) {
            Message.SHOP_NO_SHOPS.send(player);
            return;
        }
        Message.SHOP_LIST_HEAD.send(player);
        List shops = Shop.getShops(player).stream().sorted((s1, s2) -> s1.getName().compareTo(s2.getName())).skip((long)(page - 1) * 10L).limit(10L).toList();
        for (Shop shop : shops) {
            Component hoverMessage = ComponentUtils.replaceComponent((Component)Message.SHOP_LIST_SHOPS_HOVER.get(), Map.of("%shop-name%", shop.getName(), "%material%", shop.getMaterialString(), "%sell-price%", String.format("%.2f", shop.getCustomerPurchasePrice()), "%buy-price%", String.format("%.2f", shop.getCustomerSalePrice()), "%items-left%", "" + shop.getItemsLeft(), "%location%", shop.getChestLocationString(), "%created%", shop.getCreatedAt()));
            player.sendMessage(ComponentUtils.replaceComponent((Component)Message.SHOP_LIST_SHOPS.get(), (String)"%shop-name%", (String)shop.getName()).hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverMessage)));
        }
        player.sendMessage(PageUtil.getPages(page, file.getPlayerShops().size(), 10, "/spygchestshop list"));
    }
}

