/*
 * Decompiled with CFR 0.152.
 */
package com.spygstudios.chestshop.commands.admin;

import com.spygstudios.chestshop.ChestShop;
import com.spygstudios.chestshop.config.Config;
import com.spygstudios.chestshop.config.GuiConfig;
import com.spygstudios.chestshop.config.Message;
import com.spygstudios.chestshop.config.MessageConfig;
import com.spygstudios.chestshop.gui.DashboardGui;
import com.spygstudios.chestshop.gui.PlayersGui;
import com.spygstudios.chestshop.gui.ShopGui;
import com.spygstudios.chestshop.shop.Shop;
import dev.rollczi.litecommands.annotations.command.Command;
import dev.rollczi.litecommands.annotations.context.Context;
import dev.rollczi.litecommands.annotations.execute.Execute;
import dev.rollczi.litecommands.annotations.permission.Permission;
import dev.rollczi.litecommands.annotations.permission.Permissions;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(name="spygchestshop reload", aliases={"spcs reload", "chestshop reload", "scs reload"})
public class Reload {
    Config config;
    GuiConfig guiConfig;
    ChestShop plugin;
    MessageConfig messageConfig;

    public Reload(ChestShop plugin) {
        this.config = plugin.getConf();
        this.guiConfig = plugin.getGuiConfig();
        this.messageConfig = plugin.getMessageConfig();
        this.plugin = plugin;
    }

    @Execute
    @Permissions(value={@Permission(value={"spygchestshop.admin.reload"}), @Permission(value={"spygchestshop.admin.*"})})
    public void onReload(@Context CommandSender sender) {
        this.config.reloadConfig();
        this.guiConfig.reloadConfig();
        this.plugin.getMessageConfig().reloadConfig();
        for (Shop shop : Shop.getShops()) {
            shop.getHologram().updateHologramRows();
        }
        if (!this.config.getString("locale").equals(this.plugin.getMessageConfig().getLocale())) {
            this.plugin.setMessageConfig(new MessageConfig(this.plugin, this.config.getString("locale")));
            Message.init(this.plugin.getMessageConfig());
        }
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            if (player.getOpenInventory() == null || player.getOpenInventory().getTopInventory() == null || !(player.getOpenInventory().getTopInventory().getHolder() instanceof DashboardGui.DashboardHolder) && !(player.getOpenInventory().getTopInventory().getHolder() instanceof ShopGui.ShopHolder) && !(player.getOpenInventory().getTopInventory().getHolder() instanceof PlayersGui.PlayersHolder)) continue;
            player.closeInventory();
        }
        Message.CONFIG_RELOADED.send(sender);
    }
}

