/*
 * Decompiled with CFR 0.152.
 */
package com.spygstudios.chestshop.commands.admin;

import com.spygstudios.chestshop.PageUtil;
import com.spygstudios.chestshop.config.Message;
import com.spygstudios.chestshop.shop.Shop;
import com.spygstudios.chestshop.shop.ShopFile;
import com.spygstudios.spyglib.components.ComponentUtils;
import dev.rollczi.litecommands.annotations.argument.Arg;
import dev.rollczi.litecommands.annotations.async.Async;
import dev.rollczi.litecommands.annotations.command.Command;
import dev.rollczi.litecommands.annotations.context.Context;
import dev.rollczi.litecommands.annotations.execute.Execute;
import dev.rollczi.litecommands.annotations.optional.OptionalArg;
import dev.rollczi.litecommands.annotations.permission.Permission;
import dev.rollczi.litecommands.annotations.permission.Permissions;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@Command(name="spygchestshop admin list", aliases={"spcs admin list", "chestshop admin list", "scs admin list"})
public class ShopListAdmin {
    @Execute
    @Permissions(value={@Permission(value={"spygchestshop.admin.list"}), @Permission(value={"spygchestshop.admin.*"})})
    public void onList(@Context Player player, @Async @Arg OfflinePlayer target, @OptionalArg Integer page) {
        ShopFile file;
        if (page == null) {
            page = 1;
        }
        if ((file = ShopFile.getShopFile(target.getUniqueId())) == null || file.getPlayerShops().isEmpty()) {
            Message.ADMIN_NO_SHOPS.send(player, Map.of("%player-name%", target.getName()));
            return;
        }
        Message.ADMIN_SHOP_LIST_HEAD.send(player, Map.of("%player-name%", target.getName()));
        List shops = Shop.getShops(target.getUniqueId()).stream().sorted((s1, s2) -> s1.getName().compareTo(s2.getName())).skip((long)(page - 1) * 10L).limit(10L).toList();
        for (Shop shop : shops) {
            Component hoverMessage = ComponentUtils.replaceComponent((Component)Message.ADMIN_SHOP_LIST_SHOPS_HOVER.get(), Map.of("%shop-name%", shop.getName(), "%material%", shop.getMaterialString(), "%sell-price%", String.format("%.2f", shop.getCustomerPurchasePrice()), "%buy-price%", String.format("%.2f", shop.getCustomerSalePrice()), "%items-left%", "" + shop.getItemsLeft(), "%location%", shop.getChestLocationString(), "%created%", shop.getCreatedAt()));
            player.sendMessage(ComponentUtils.replaceComponent((Component)Message.ADMIN_SHOP_LIST_SHOPS.get(), (String)"%shop-name%", (String)shop.getName()).hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverMessage)));
        }
        player.sendMessage(PageUtil.getPages(page, file.getPlayerShops().size(), 10, "/spygchestshop list"));
    }
}

