/*
 * Decompiled with CFR 0.152.
 */
package com.spygstudios.chestshop.commands.handlers;

import com.spygstudios.chestshop.ChestShop;
import com.spygstudios.chestshop.config.Config;
import com.spygstudios.chestshop.config.Message;
import com.spygstudios.spyglib.color.TranslateColor;
import dev.rollczi.litecommands.handler.result.ResultHandlerChain;
import dev.rollczi.litecommands.invalidusage.InvalidUsage;
import dev.rollczi.litecommands.invalidusage.InvalidUsageHandler;
import dev.rollczi.litecommands.invocation.Invocation;
import dev.rollczi.litecommands.schematic.Schematic;
import org.bukkit.command.CommandSender;

public class InvalUsageHandler
implements InvalidUsageHandler<CommandSender> {
    Config config;

    public InvalUsageHandler(ChestShop plugin) {
        this.config = plugin.getConf();
    }

    public void handle(Invocation<CommandSender> invocation, InvalidUsage<CommandSender> result, ResultHandlerChain<CommandSender> chain) {
        Schematic schematic = result.getSchematic();
        CommandSender sender = (CommandSender)invocation.sender();
        if (schematic.isOnlyFirst()) {
            sender.sendMessage(TranslateColor.translate((String)Message.USAGE.getRaw().replace("%prefix%", Message.getPrefix()).replace("%usage%", this.getCommand(schematic.first(), invocation.label()))));
            return;
        }
        Message.COMMANDS.send(sender);
        for (String scheme : schematic.all()) {
            sender.sendMessage(TranslateColor.translate((String)(this.config.getString("colors.command.list") + this.getCommand(scheme, invocation.label()))));
        }
    }

    private String getCommand(String scheme, String label) {
        String[] args = scheme.split(" ");
        args[0] = this.config.getString("colors.command.label") + "/" + label;
        StringBuilder result = new StringBuilder(args[0]);
        int i = 1;
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith("<") && arg.endsWith(">")) {
                result.append(this.config.getString("colors.command.required-arg")).append(arg);
            } else if (arg.startsWith("[") && arg.endsWith("]")) {
                result.append(this.config.getString("colors.command.optional-arg")).append(arg);
            } else {
                result.append(this.config.getString("colors.command.args")).append(" " + arg);
            }
            ++i;
        }
        return result.toString();
    }
}

