/*
 * Decompiled with CFR 0.152.
 */
package com.spygstudios.chestshop.gui;

import com.spygstudios.chestshop.ChestShop;
import com.spygstudios.chestshop.PageUtil;
import com.spygstudios.chestshop.config.Config;
import com.spygstudios.chestshop.config.GuiConfig;
import com.spygstudios.chestshop.enums.GuiAction;
import com.spygstudios.chestshop.shop.Shop;
import com.spygstudios.spyglib.color.TranslateColor;
import com.spygstudios.spyglib.item.ItemUtils;
import com.spygstudios.spyglib.item.PlayerHeads;
import com.spygstudios.spyglib.persistentdata.PersistentData;
import com.spygstudios.spyglib.placeholder.ParseListPlaceholder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

public final class DashboardGui {
    private static GuiConfig guiConfig;

    public static void open(ChestShop plugin, Player player, Shop shop) {
        guiConfig = plugin.getGuiConfig();
        Inventory inventory = player.getServer().createInventory((InventoryHolder)new DashboardHolder(player, shop), 27, TranslateColor.translate((String)guiConfig.getString("chestshop.title").replace("%shop-name%", shop.getName()).replace("%player-name%", Bukkit.getOfflinePlayer((UUID)shop.getOwnerId()).getName())));
        DashboardGui.setShopItems(plugin, shop, inventory);
        PageUtil.setFillItems(inventory, "chestshop");
        player.openInventory(inventory);
    }

    private static void setShopItems(ChestShop plugin, Shop shop, Inventory inventory) {
        Config config = plugin.getConf();
        ConfigurationSection guiMaterialSection = guiConfig.getConfigurationSection("chestshop.material");
        ItemStack shopMaterial = shop.getMaterial() != null ? new ItemStack(shop.getMaterial()) : ItemUtils.create((Material)Material.getMaterial((String)guiMaterialSection.getString("not-set-material", "BARRIER")), (String)guiMaterialSection.getString("title"), (List)guiMaterialSection.getStringList("lore"), (List)guiMaterialSection.getFloatList("model-data.floats"), (List)guiMaterialSection.getStringList("model-data.strings"));
        inventory.setItem(guiMaterialSection.getInt("slot"), shopMaterial);
        PersistentData materialData = new PersistentData((JavaPlugin)plugin, shopMaterial);
        materialData.set("action", GuiAction.SET_MATERIAL.name());
        String buyPrice = config.getString("shops.price-format.buy").replace("%price%", String.valueOf(shop.getCustomerPurchasePrice()));
        String sellPrice = config.getString("shops.price-format.sell").replace("%price%", String.valueOf(shop.getCustomerSalePrice()));
        Material infoMaterial = Material.getMaterial((String)config.getString("chestshop.info.material", "WRITABLE_BOOK"));
        String priceDisplay = "";
        priceDisplay = shop.acceptsCustomerPurchases() && shop.acceptsCustomerSales() ? config.getString("shops.price-format.combined").replace("%sell-price%", sellPrice).replace("%buy-price%", buyPrice) : (shop.acceptsCustomerPurchases() ? buyPrice : (shop.acceptsCustomerSales() ? sellPrice : config.getString("shops.unknown.mode")));
        ConfigurationSection infoSection = guiConfig.getConfigurationSection("chestshop.info");
        ItemStack infoItem = ItemUtils.create((Material)infoMaterial, (String)infoSection.getString("title"), (List)ParseListPlaceholder.parse((List)infoSection.getStringList("lore"), Map.of("%player-name%", Bukkit.getOfflinePlayer((UUID)shop.getOwnerId()).getName(), "%material%", shop.getMaterial() == null ? "AIR" : shop.getMaterial().name(), "%price%", priceDisplay, "%created%", shop.getCreatedAt(), "%location%", shop.getChestLocationString(), "%sold-items%", String.valueOf(shop.getSoldItems()), "%money-earned%", String.valueOf(shop.getMoneyEarned()), "%bought-items%", String.valueOf(shop.getBoughtItems()), "%money-spent%", String.valueOf(shop.getMoneySpent()))), (List)infoSection.getFloatList("model-data.floats"), (List)infoSection.getStringList("model-data.strings"));
        inventory.setItem(infoSection.getInt("slot"), infoItem);
        ConfigurationSection notifySection = guiConfig.getConfigurationSection("chestshop.notify");
        Material notifyMaterial = Material.getMaterial((String)notifySection.getString("material", "BELL"));
        ItemStack notifyItem = ItemUtils.create((Material)notifyMaterial, (String)notifySection.getString("title"), Arrays.asList(shop.isNotify() ? notifySection.getString("on") : notifySection.getString("off")), (List)notifySection.getFloatList("model-data.floats"), (List)notifySection.getStringList("model-data.strings"));
        PersistentData notifyData = new PersistentData((JavaPlugin)plugin, notifyItem);
        notifyData.set("action", GuiAction.TOGGLE_NOTIFY.name());
        inventory.setItem(notifySection.getInt("slot"), notifyItem);
        ConfigurationSection moneySection = guiConfig.getConfigurationSection("chestshop.money");
        Material moneyMaterial = Material.getMaterial((String)moneySection.getString("material", "GOLD_INGOT"));
        ArrayList<String> moneyLore = new ArrayList<String>();
        for (String string : moneySection.getStringList("lore")) {
            moneyLore.add(string.replace("%sell-price%", String.valueOf(shop.getCustomerPurchasePrice())).replace("%buy-price%", String.valueOf(shop.getCustomerSalePrice())));
        }
        ItemStack moneyItem = ItemUtils.create((Material)moneyMaterial, (String)moneySection.getString("title"), moneyLore, (List)moneySection.getFloatList("model-data.floats"), (List)moneySection.getStringList("model-data.strings"));
        PersistentData moneyData = new PersistentData((JavaPlugin)plugin, moneyItem);
        moneyData.set("action", GuiAction.SET_SHOP_BUY_PRICE.name());
        inventory.setItem(moneySection.getInt("slot"), moneyItem);
        ConfigurationSection inventorySection = guiConfig.getConfigurationSection("chestshop.inventory");
        Material inventoryMaterial = Material.getMaterial((String)inventorySection.getString("material", "CHEST"));
        ItemStack inventoryItem = ItemUtils.create((Material)inventoryMaterial, (String)inventorySection.getString("title"), (List)inventorySection.getStringList("lore"), (List)inventorySection.getFloatList("model-data.floats"), (List)inventorySection.getStringList("model-data.strings"));
        PersistentData inventoryData = new PersistentData((JavaPlugin)plugin, inventoryItem);
        inventoryData.set("action", GuiAction.OPEN_SHOP_INVENTORY.name());
        inventory.setItem(inventorySection.getInt("slot"), inventoryItem);
        ConfigurationSection buySellSection = guiConfig.getConfigurationSection("chestshop.buysell");
        Material buySellMaterial = Material.getMaterial((String)buySellSection.getString("material", "COMPARATOR"));
        ArrayList<String> buySellLore = new ArrayList<String>();
        String sellStatus = shop.acceptsCustomerPurchases() ? buySellSection.getString("sell.enabled", "&aEnabled") : buySellSection.getString("sell.disabled", "&cDisabled");
        String buyStatus = shop.acceptsCustomerSales() ? buySellSection.getString("buy.enabled", "&aEnabled") : buySellSection.getString("buy.disabled", "&cDisabled");
        buySellLore.add(buySellSection.getString("sell.line", "&7Selling: %status%").replace("%status%", sellStatus));
        buySellLore.add(buySellSection.getString("buy.line", "&7Buying: %status%").replace("%status%", buyStatus));
        buySellLore.addAll(buySellSection.getStringList("lore"));
        ItemStack buySellItem = ItemUtils.create((Material)buySellMaterial, (String)buySellSection.getString("title"), buySellLore, (List)buySellSection.getFloatList("model-data.floats"), (List)buySellSection.getStringList("model-data.strings"));
        PersistentData buySellData = new PersistentData((JavaPlugin)plugin, buySellItem);
        buySellData.set("action", GuiAction.TOGGLE_SELLING.name());
        inventory.setItem(buySellSection.getInt("slot"), buySellItem);
        ConfigurationSection playerSection = guiConfig.getConfigurationSection("chestshop.player");
        OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)shop.getOwnerId());
        ItemStack playrItem = owner.isOnline() ? PlayerHeads.getOnlinePlayerHead((UUID)owner.getUniqueId()) : PlayerHeads.getOfflinePlayerHead((UUID)owner.getUniqueId());
        ItemMeta playrMeta = playrItem.getItemMeta();
        playrMeta.displayName(TranslateColor.translate((String)playerSection.getString("title").replace("%player-name%", Bukkit.getOfflinePlayer((UUID)shop.getOwnerId()).getName())));
        playrMeta.lore(TranslateColor.translate((List)playerSection.getStringList("lore")));
        playrItem.setItemMeta(playrMeta);
        PersistentData playerData = new PersistentData((JavaPlugin)plugin, playrItem);
        playerData.set("action", GuiAction.OPEN_PLAYERS.name());
        inventory.setItem(playerSection.getInt("slot"), playrItem);
    }

    @Generated
    private DashboardGui() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class DashboardHolder
    implements InventoryHolder {
        private final Player player;
        private final Material material;
        private final Shop shop;

        public DashboardHolder(Player player, Shop shop) {
            this.player = player;
            this.material = shop.getMaterial() == null ? Material.AIR : shop.getMaterial();
            this.shop = shop;
        }

        public Inventory getInventory() {
            return null;
        }

        @Generated
        public Player getPlayer() {
            return this.player;
        }

        @Generated
        public Material getMaterial() {
            return this.material;
        }

        @Generated
        public Shop getShop() {
            return this.shop;
        }
    }
}

