/*
 * Decompiled with CFR 0.152.
 */
package com.spygstudios.chestshop.gui;

import com.spygstudios.chestshop.ChestShop;
import com.spygstudios.chestshop.PageUtil;
import com.spygstudios.chestshop.config.GuiConfig;
import com.spygstudios.chestshop.enums.GuiAction;
import com.spygstudios.chestshop.shop.Shop;
import com.spygstudios.spyglib.color.TranslateColor;
import com.spygstudios.spyglib.item.PlayerHeads;
import com.spygstudios.spyglib.persistentdata.PersistentData;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PlayersGui {
    private static GuiConfig config;

    public static void open(ChestShop plugin, Player player, Shop shop) {
        config = plugin.getGuiConfig();
        PlayersHolder holder = new PlayersHolder(player, shop);
        Inventory inventory = player.getServer().createInventory((InventoryHolder)holder, 27, TranslateColor.translate((String)config.getString("players.title").replace("%shop-name%", shop.getName())));
        PageUtil.setFillItems(inventory, "players");
        PlayersGui.loadPlayerHeads(plugin, shop, inventory, holder.getPage());
        player.openInventory(inventory);
    }

    /*
     * WARNING - void declaration
     */
    public static void reloadGui(ChestShop plugin, Inventory inventory) {
        void holder;
        InventoryHolder inventoryHolder = inventory.getHolder();
        if (!(inventoryHolder instanceof PlayersHolder)) {
            return;
        }
        PlayersHolder playersHolder = (PlayersHolder)inventoryHolder;
        PageUtil.setFillItems(inventory, "players");
        PlayersGui.loadPlayerHeads(plugin, holder.getShop(), inventory, holder.getPage());
    }

    private static void loadPlayerHeads(ChestShop plugin, Shop shop, Inventory inventory, int page) {
        int headPerPage = 18;
        int maxPage = (int)Math.ceil((double)shop.getAddedPlayers().size() / (double)headPerPage);
        List addedPlayers = shop.getAddedPlayers().stream().skip((long)(page - 1) * (long)headPerPage).limit(headPerPage).toList();
        int i = 0;
        while (i < addedPlayers.size()) {
            UUID uuid = (UUID)addedPlayers.get(i);
            if (Bukkit.getOfflinePlayer((UUID)uuid).getName() != null) {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
                ItemStack skull = offlinePlayer.isOnline() ? PlayerHeads.getOnlinePlayerHead((UUID)uuid) : new ItemStack(Material.PLAYER_HEAD);
                skull.setItemMeta((ItemMeta)PlayersGui.getPlayerHeadMeta(skull, offlinePlayer));
                PersistentData skullData = new PersistentData((JavaPlugin)plugin, skull);
                skullData.set("action", GuiAction.REMOVE_PLAYER.name());
                skullData.set("uuid", offlinePlayer.getUniqueId().toString());
                inventory.setItem(i, skull);
                if (!offlinePlayer.isOnline()) {
                    int index = i;
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                        ItemStack head = PlayerHeads.getOfflinePlayerHead((UUID)uuid);
                        Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
                            inventory.remove(skull);
                            head.setItemMeta((ItemMeta)PlayersGui.getPlayerHeadMeta(head, offlinePlayer));
                            PersistentData headData = new PersistentData((JavaPlugin)plugin, head);
                            headData.set("action", GuiAction.REMOVE_PLAYER.name());
                            headData.set("uuid", offlinePlayer.getUniqueId().toString());
                            inventory.setItem(index, head);
                        });
                    });
                }
            }
            ++i;
        }
        if (page > 1) {
            inventory.setItem(18, PlayersGui.getArrowItem(plugin, config.getString("players.back.title"), GuiAction.BACK));
        }
        if (shop.getAddedPlayers().size() > 18 && page < maxPage) {
            inventory.setItem(26, PlayersGui.getArrowItem(plugin, config.getString("players.next.title"), GuiAction.NEXT));
        }
    }

    private static ItemStack getArrowItem(ChestShop plugin, String displayName, GuiAction action) {
        ItemStack arrow = new ItemStack(Material.getMaterial((String)config.getString("players." + (action.equals((Object)GuiAction.NEXT) ? "next" : "back") + ".material", "ARROW")));
        ItemMeta arrowMeta = arrow.getItemMeta();
        arrowMeta.displayName(TranslateColor.translate((String)displayName));
        arrow.setItemMeta(arrowMeta);
        PersistentData nextData = new PersistentData((JavaPlugin)plugin, arrow);
        nextData.set("action", action.name());
        return arrow;
    }

    private static SkullMeta getPlayerHeadMeta(ItemStack skull, OfflinePlayer offlinePlayer) {
        SkullMeta skullMeta = (SkullMeta)skull.getItemMeta();
        skullMeta.displayName(TranslateColor.translate((String)config.getString("players.player.title").replace("%player-name%", offlinePlayer.getName())));
        skullMeta.lore(TranslateColor.translate((List)config.getStringList("players.player.lore")));
        return skullMeta;
    }

    @Generated
    private PlayersGui() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class PlayersHolder
    implements InventoryHolder {
        private final Player player;
        private final Shop shop;
        private int page;

        public PlayersHolder(Player player, Shop shop) {
            this.player = player;
            this.shop = shop;
            this.page = 1;
        }

        public Inventory getInventory() {
            return null;
        }

        @Generated
        public Player getPlayer() {
            return this.player;
        }

        @Generated
        public Shop getShop() {
            return this.shop;
        }

        @Generated
        public int getPage() {
            return this.page;
        }

        @Generated
        public void setPage(int page) {
            this.page = page;
        }
    }
}

