/*
 * Decompiled with CFR 0.152.
 */
package com.spygstudios.chestshop.gui;

import com.spygstudios.chestshop.ChestShop;
import com.spygstudios.chestshop.PageUtil;
import com.spygstudios.chestshop.config.GuiConfig;
import com.spygstudios.chestshop.enums.GuiAction;
import com.spygstudios.chestshop.enums.ShopMode;
import com.spygstudios.chestshop.shop.Shop;
import com.spygstudios.spyglib.color.TranslateColor;
import com.spygstudios.spyglib.item.ItemUtils;
import com.spygstudios.spyglib.persistentdata.PersistentData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

public final class ShopGui {
    private static final Map<UUID, ShopMode> PLAYER_MODES = new HashMap<UUID, ShopMode>();

    public static void open(ChestShop plugin, Player player, Shop shop) {
        ShopMode mode = ShopGui.getPlayerMode(player, shop);
        ShopGui.open(plugin, player, shop, mode);
    }

    public static void open(ChestShop plugin, Player player, Shop shop, ShopMode mode) {
        GuiConfig config = plugin.getGuiConfig();
        Inventory inventory = player.getServer().createInventory((InventoryHolder)new ShopHolder(player, shop), 27, TranslateColor.translate((String)config.getString("shop.title").replace("%shop-name%", shop.getName())));
        if (shop.acceptsCustomerPurchases() && shop.acceptsCustomerSales() && shop.getItemsLeft() > 0) {
            Material modeMaterial = mode == ShopMode.CUSTOMER_PURCHASING ? Material.getMaterial((String)config.getString("shop.mode.buying.material", "GREEN_WOOL")) : Material.getMaterial((String)config.getString("shop.mode.selling.material", "RED_WOOL"));
            String modeTitle = mode == ShopMode.CUSTOMER_PURCHASING ? config.getString("shop.mode.buying.title", "&eBuying Mode") : config.getString("shop.mode.selling.title", "&eSelling Mode");
            List modeLore = mode == ShopMode.CUSTOMER_PURCHASING ? config.getStringList("shop.mode.buying.lore") : config.getStringList("shop.mode.selling.lore");
            ItemStack modeItem = ItemUtils.create((Material)modeMaterial, (String)modeTitle, (List)modeLore);
            PersistentData modeData = new PersistentData((JavaPlugin)plugin, modeItem);
            modeData.set("action", GuiAction.TOGGLE_MODE.name());
            inventory.setItem(4, modeItem);
        }
        ItemStack shopItem = new ItemStack(shop.getMaterial());
        ItemMeta shopMeta = shopItem.getItemMeta();
        String titleKey = mode == ShopMode.CUSTOMER_PURCHASING ? "shop.item-to-buy.title" : "shop.item-to-sell.title";
        String loreKey = mode == ShopMode.CUSTOMER_PURCHASING ? "shop.item-to-buy.lore" : "shop.item-to-sell.lore";
        shopMeta.displayName(TranslateColor.translate((String)config.getString(titleKey, "&e%material%").replace("%material%", shop.getMaterial().name())));
        double priceForMode = mode == ShopMode.CUSTOMER_PURCHASING ? shop.getCustomerPurchasePrice() : shop.getCustomerSalePrice();
        List<Component> translatedLore = plugin.getGuiConfig().getStringList(loreKey).stream().map(line -> TranslateColor.translate((String)line.replace("%price%", String.valueOf(priceForMode)))).toList();
        shopMeta.lore(translatedLore);
        shopItem.setItemMeta(shopMeta);
        PersistentData data = new PersistentData((JavaPlugin)plugin, shopItem);
        data.set("action", mode == ShopMode.CUSTOMER_PURCHASING ? GuiAction.BUY.name() : GuiAction.SELL.name());
        data.set("mode", mode.name());
        inventory.setItem(13, shopItem);
        if (shop.getAddedPlayers().contains(player.getUniqueId())) {
            Material inventoryMaterial = Material.getMaterial((String)config.getString("chestshop.inventory.material", "CHEST"));
            ItemStack inventoryItem = ItemUtils.create((Material)inventoryMaterial, (String)config.getString("chestshop.inventory.title"), (List)config.getStringList("chestshop.inventory.lore"));
            PersistentData inventoryData = new PersistentData((JavaPlugin)plugin, inventoryItem);
            inventoryData.set("action", GuiAction.OPEN_SHOP_INVENTORY.name());
            inventory.setItem(18, inventoryItem);
        }
        ConfigurationSection amountSection = config.getConfigurationSection("shop.amount.items");
        amountSection.getKeys(false).forEach(key -> {
            int slot = amountSection.getInt(key + ".slot");
            int amount = amountSection.getInt(key + ".amount");
            String title = amountSection.getString(key + ".title").replace("%amount%", String.valueOf(amount).replace("-", ""));
            List lore = amountSection.getStringList(key + ".lore");
            Material material = Material.getMaterial((String)amountSection.getString(key + ".material", "GRAY_STAINED_GLASS_PANE"));
            List modelFloats = amountSection.getFloatList(key + ".model-data.floats");
            List modelStrings = amountSection.getStringList(key + ".model-data.strings");
            ShopGui.addItemToInventory(plugin, inventory, slot, material, title, lore, modelFloats, modelStrings, amount);
        });
        PageUtil.setFillItems(inventory, "shop");
        player.openInventory(inventory);
    }

    private static void addItemToInventory(ChestShop plugin, Inventory inventory, int slot, Material material, String title, List<String> lore, List<Float> modelFloats, List<String> modelStrings, int amount) {
        ItemStack item = ItemUtils.create((Material)material, (String)title, lore, modelFloats, modelStrings, (int)Math.abs(amount));
        PersistentData data = new PersistentData((JavaPlugin)plugin, item);
        data.set("action", GuiAction.SET_ITEM_AMOUNT.name());
        data.set("amount", amount);
        inventory.setItem(slot, item);
    }

    private static ShopMode getPlayerMode(Player player, Shop shop) {
        ShopMode mode = PLAYER_MODES.get(player.getUniqueId());
        if (mode == null) {
            if (shop.acceptsCustomerPurchases()) {
                mode = ShopMode.CUSTOMER_PURCHASING;
            } else if (shop.acceptsCustomerSales()) {
                mode = ShopMode.CUSTOMER_SELLING;
            }
        }
        if (shop.getItemsLeft() == 0 && shop.acceptsCustomerSales()) {
            return ShopMode.CUSTOMER_SELLING;
        }
        if (mode == ShopMode.CUSTOMER_SELLING && !shop.acceptsCustomerSales() || mode == ShopMode.CUSTOMER_PURCHASING && !shop.acceptsCustomerPurchases()) {
            mode = shop.acceptsCustomerSales() ? ShopMode.CUSTOMER_SELLING : ShopMode.CUSTOMER_PURCHASING;
        }
        return mode;
    }

    public static void setPlayerMode(Player player, ShopMode mode) {
        PLAYER_MODES.put(player.getUniqueId(), mode);
    }

    public static ShopMode getPlayerMode(Player player) {
        return PLAYER_MODES.getOrDefault(player.getUniqueId(), ShopMode.CUSTOMER_PURCHASING);
    }

    public static void clearPlayerMode(Player player) {
        PLAYER_MODES.remove(player.getUniqueId());
    }

    @Generated
    private ShopGui() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class ShopHolder
    implements InventoryHolder {
        private final Player player;
        private final Shop shop;

        public ShopHolder(Player player, Shop shop) {
            this.player = player;
            this.shop = shop;
        }

        public Inventory getInventory() {
            return null;
        }

        @Generated
        public Player getPlayer() {
            return this.player;
        }

        @Generated
        public Shop getShop() {
            return this.shop;
        }
    }
}

