/*
 * Decompiled with CFR 0.152.
 */
package com.spygstudios.chestshop.listeners;

import com.spygstudios.chestshop.ChestShop;
import com.spygstudios.chestshop.config.Config;
import com.spygstudios.chestshop.config.Message;
import com.spygstudios.chestshop.enums.ShopRemoveCause;
import com.spygstudios.chestshop.shop.Shop;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.plugin.Plugin;

public class ExplosionListener
implements Listener {
    Config config;

    public ExplosionListener(ChestShop plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.config = plugin.getConf();
    }

    @EventHandler
    public void onEntityExplosion(EntityExplodeEvent event) {
        if (this.config.getBoolean("shops.anti-explosion")) {
            event.blockList().removeIf(block -> Shop.getShop(block.getLocation()) != null);
            return;
        }
        event.blockList().stream().filter(block -> Shop.getShop(block.getLocation()) != null).forEach(block -> {
            Shop shop = Shop.getShop(block.getLocation());
            if (Bukkit.getPlayer((UUID)shop.getOwnerId()) != null) {
                Message.SHOP_EXPLODED.send(Bukkit.getPlayer((UUID)shop.getOwnerId()), Map.of("%shop-name%", shop.getName(), "%shop-location%", shop.getChestLocationString()));
            }
            shop.remove(null, ShopRemoveCause.EXPLOSION);
        });
    }

    @EventHandler
    public void onBlockExplosion(BlockExplodeEvent event) {
        if (this.config.getBoolean("shops.anti-explosion")) {
            event.blockList().removeIf(block -> Shop.getShop(block.getLocation()) != null);
            return;
        }
        event.blockList().stream().filter(block -> Shop.getShop(block.getLocation()) != null).forEach(block -> {
            Shop shop = Shop.getShop(block.getLocation());
            if (Bukkit.getPlayer((UUID)shop.getOwnerId()) != null) {
                Message.SHOP_EXPLODED.send(Bukkit.getPlayer((UUID)shop.getOwnerId()), Map.of("%shop-name%", shop.getName(), "%shop-location%", shop.getChestLocationString()));
            }
            shop.remove(null, ShopRemoveCause.EXPLOSION);
        });
    }
}

