/*
 * Decompiled with CFR 0.152.
 */
package com.spygstudios.chestshop.listeners;

import com.spygstudios.chestshop.ChestShop;
import com.spygstudios.chestshop.commands.admin.CustomerMode;
import com.spygstudios.chestshop.config.Message;
import com.spygstudios.chestshop.gui.DashboardGui;
import com.spygstudios.chestshop.gui.ShopGui;
import com.spygstudios.chestshop.shop.Shop;
import com.spygstudios.chestshop.shop.ShopUtils;
import com.spygstudios.spyglib.item.ItemUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class InteractListener
implements Listener {
    private final ChestShop plugin;

    public InteractListener(ChestShop plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInteractWithShop(PlayerInteractEvent event) {
        boolean isAdmin;
        if (event.getClickedBlock() == null) {
            return;
        }
        if (event.getAction().isLeftClick()) {
            return;
        }
        Player player = event.getPlayer();
        if (ShopUtils.isDisabledWorld(player.getWorld().getName())) {
            return;
        }
        Location location = event.getClickedBlock().getLocation();
        Shop shop = Shop.getShop(location);
        if (shop == null) {
            return;
        }
        if (player.isSneaking() && ItemUtils.hasItemInHand((Player)player, (Material)Material.HOPPER)) {
            return;
        }
        event.setCancelled(true);
        boolean bl = isAdmin = (player.hasPermission("spygchestshop.admin") || player.hasPermission("spygchestshop.admin.edit")) && player.isSneaking();
        if ((shop.getOwnerId().equals(player.getUniqueId()) || isAdmin) && !CustomerMode.getCustomerMode().contains(player.getUniqueId())) {
            DashboardGui.open(this.plugin, player, shop);
            return;
        }
        if (shop.getMaterial() == null) {
            Message.SHOP_SETUP_NEEDED.send(player);
            return;
        }
        if (!shop.acceptsCustomerSales() && !shop.acceptsCustomerPurchases()) {
            Message.SHOP_SETUP_NEEDED.send(player);
            return;
        }
        if (shop.getItemsLeft() == 0 && !shop.acceptsCustomerSales() && !shop.getAddedPlayers().contains(player.getUniqueId())) {
            Message.SHOP_EMPTY.send(player);
            return;
        }
        ShopGui.open(this.plugin, player, shop);
    }
}

