/*
 * Decompiled with CFR 0.152.
 */
package com.spygstudios.chestshop.listeners;

import com.spygstudios.chestshop.ChestShop;
import com.spygstudios.chestshop.config.Message;
import com.spygstudios.spyglib.components.ComponentUtils;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class PlayerJoinListener
implements Listener {
    private final ChestShop plugin;
    private final String currentVersion;
    private final boolean isLatestVersion;

    public PlayerJoinListener(ChestShop plugin, String currentVersion, Boolean isLatestVersion) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.currentVersion = currentVersion;
        this.isLatestVersion = isLatestVersion;
        this.plugin = plugin;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (!this.plugin.getConf().getBoolean("check-for-updates")) {
            return;
        }
        if (!this.isLatestVersion && event.getPlayer().hasPermission("spygchestshop.admin.updates")) {
            Component message = ComponentUtils.replaceComponent((Component)Message.NEW_VERSION.get().clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.OPEN_URL, (String)"https://modrinth.com/plugin/spyg-chestshop")), Map.of("%old-version%", this.plugin.getPluginMeta().getVersion(), "%new-version%", this.currentVersion));
            event.getPlayer().sendMessage(message);
        }
    }
}

