/*
 * Decompiled with CFR 0.152.
 */
package com.spygstudios.chestshop.listeners.gui;

import com.spygstudios.chestshop.ChestShop;
import com.spygstudios.chestshop.config.GuiConfig;
import com.spygstudios.chestshop.enums.GuiAction;
import com.spygstudios.chestshop.gui.DashboardGui;
import com.spygstudios.chestshop.gui.PlayersGui;
import com.spygstudios.chestshop.shop.AmountHandler;
import com.spygstudios.chestshop.shop.Shop;
import com.spygstudios.spyglib.color.TranslateColor;
import com.spygstudios.spyglib.persistentdata.PersistentData;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DashboardGuiHandler
implements Listener {
    private final ChestShop plugin;

    public DashboardGuiHandler(ChestShop plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.plugin = plugin;
    }

    @EventHandler
    public void onShopGuiClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder() instanceof DashboardGui.DashboardHolder)) {
            return;
        }
        if (event.getClickedInventory() == null || event.getClickedInventory().getType().equals((Object)InventoryType.PLAYER)) {
            if (event.getClick().isShiftClick()) {
                event.setCancelled(true);
            }
            return;
        }
        event.setCancelled(true);
        if (event.getSlot() == 13) {
            this.changeShopMaterial(event);
            return;
        }
        if (event.getSlot() == 11) {
            this.handlePriceSetting(event);
            return;
        }
        if (event.getSlot() == 15) {
            this.handleBuySellToggle(event);
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        this.chestShopGui(event);
    }

    private void chestShopGui(InventoryClickEvent event) {
        ItemStack clickedItem = event.getCurrentItem();
        PersistentData data = new PersistentData((JavaPlugin)this.plugin, clickedItem);
        String action = data.getString("action");
        if (action == null) {
            return;
        }
        DashboardGui.DashboardHolder holder = (DashboardGui.DashboardHolder)event.getInventory().getHolder();
        Player player = holder.getPlayer();
        Shop shop = holder.getShop();
        GuiAction guiAction = GuiAction.valueOf(action);
        switch (guiAction) {
            case SET_MATERIAL: {
                this.changeShopMaterial(event);
                break;
            }
            case TOGGLE_NOTIFY: {
                shop.setNotify(!shop.isNotify());
                ItemStack notifyItem = clickedItem;
                ItemMeta notifyMeta = notifyItem.getItemMeta();
                notifyMeta.lore(Arrays.asList(TranslateColor.translate((String)(shop.isNotify() ? this.plugin.getGuiConfig().getString("chestshop.notify.on") : this.plugin.getGuiConfig().getString("chestshop.notify.off")))));
                notifyItem.setItemMeta(notifyMeta);
                player.updateInventory();
                break;
            }
            case SET_SHOP_SELL_PRICE: 
            case SET_SHOP_BUY_PRICE: {
                if (AmountHandler.getPendingAmount(player) != null) {
                    AmountHandler.getPendingAmount(player).cancel();
                }
                new AmountHandler(player, shop, guiAction);
                event.getInventory().close();
                break;
            }
            case OPEN_PLAYERS: {
                PlayersGui.open(this.plugin, player, shop);
                break;
            }
            case OPEN_SHOP_INVENTORY: {
                shop.openShopInventory(player);
                break;
            }
            case CLOSE: {
                player.closeInventory();
                break;
            }
        }
    }

    private void changeShopMaterial(InventoryClickEvent event) {
        if (event.getCursor() == null || event.getCursor().getType().isAir()) {
            return;
        }
        event.getInventory().setItem(13, new ItemStack(event.getCursor().getType()));
        PersistentData newData = new PersistentData((JavaPlugin)this.plugin, event.getInventory().getItem(13));
        newData.set("action", GuiAction.SET_MATERIAL.name());
    }

    private void handlePriceSetting(InventoryClickEvent event) {
        if (!event.getClick().isLeftClick() && !event.getClick().isRightClick()) {
            return;
        }
        DashboardGui.DashboardHolder holder = (DashboardGui.DashboardHolder)event.getInventory().getHolder();
        Shop shop = holder.getShop();
        Player player = holder.getPlayer();
        GuiAction action = GuiAction.SET_SHOP_SELL_PRICE;
        if (event.getClick().isRightClick()) {
            action = GuiAction.SET_SHOP_BUY_PRICE;
        }
        if (AmountHandler.getPendingAmount(player) != null) {
            AmountHandler.getPendingAmount(player).cancel();
        }
        new AmountHandler(player, shop, action);
        event.getInventory().close();
    }

    private void handleBuySellToggle(InventoryClickEvent event) {
        DashboardGui.DashboardHolder holder = (DashboardGui.DashboardHolder)event.getInventory().getHolder();
        Shop shop = holder.getShop();
        Player player = holder.getPlayer();
        GuiConfig guiConfig = this.plugin.getGuiConfig();
        if (!shop.acceptsCustomerPurchases() && !shop.acceptsCustomerSales()) {
            shop.setCanSellToPlayers(true);
            shop.setCanBuyFromPlayers(true);
        } else if (!shop.acceptsCustomerPurchases() && shop.acceptsCustomerSales()) {
            shop.setCanSellToPlayers(false);
            shop.setCanBuyFromPlayers(false);
        } else if (shop.acceptsCustomerPurchases() && shop.acceptsCustomerSales()) {
            shop.setCanSellToPlayers(true);
            shop.setCanBuyFromPlayers(false);
        } else {
            shop.setCanSellToPlayers(false);
            shop.setCanBuyFromPlayers(true);
        }
        ArrayList<String> buySellLore = new ArrayList<String>();
        String sellStatus = shop.acceptsCustomerPurchases() ? guiConfig.getString("chestshop.buysell.sell.enabled", "&aEnabled") : guiConfig.getString("chestshop.buysell.sell.disabled", "&cDisabled");
        String buyStatus = shop.acceptsCustomerSales() ? guiConfig.getString("chestshop.buysell.buy.enabled", "&aEnabled") : guiConfig.getString("chestshop.buysell.buy.disabled", "&cDisabled");
        buySellLore.add(guiConfig.getString("chestshop.buysell.sell.line", "&7Selling: %status%").replace("%status%", sellStatus));
        buySellLore.add(guiConfig.getString("chestshop.buysell.buy.line", "&7Buying: %status%").replace("%status%", buyStatus));
        buySellLore.addAll(guiConfig.getStringList("chestshop.buysell.lore"));
        ItemStack item = event.getClickedInventory().getItem(event.getSlot());
        ItemMeta meta = item.getItemMeta();
        meta.lore(TranslateColor.translate(buySellLore));
        item.setItemMeta(meta);
        player.updateInventory();
    }
}

