/*
 * Decompiled with CFR 0.152.
 */
package com.spygstudios.chestshop.listeners.gui;

import com.spygstudios.chestshop.ChestShop;
import com.spygstudios.chestshop.gui.DashboardGui;
import com.spygstudios.chestshop.gui.PlayersGui;
import com.spygstudios.chestshop.gui.ShopGui;
import com.spygstudios.chestshop.shop.Shop;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class InventoryCloseListener
implements Listener {
    ChestShop plugin;

    public InventoryCloseListener(ChestShop plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        InventoryHolder inventoryHolder;
        Inventory inventory = event.getInventory();
        InventoryHolder invHolder = inventory.getHolder();
        if (!(invHolder instanceof DashboardGui.DashboardHolder || invHolder instanceof ShopGui.ShopHolder || invHolder instanceof PlayersGui.PlayersHolder || inventory.getLocation() == null)) {
            Location invLocation = inventory.getLocation();
            Shop shop = Shop.getShop(invLocation);
            if (this.plugin.getConf().getBoolean("shops.barrier-when-empty")) {
                if (shop == null || !invLocation.getWorld().getChunkAt(invLocation).isLoaded()) {
                    return;
                }
                shop.getHologram().updateHologramRows();
            }
        }
        if (event.getPlayer().getOpenInventory() != null && (inventoryHolder = event.getPlayer().getOpenInventory().getTopInventory().getHolder()) instanceof PlayersGui.PlayersHolder) {
            PlayersGui.PlayersHolder holder = (PlayersGui.PlayersHolder)inventoryHolder;
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> DashboardGui.open(this.plugin, (Player)event.getPlayer(), holder.getShop()), 1L);
            return;
        }
        if (invHolder instanceof DashboardGui.DashboardHolder) {
            DashboardGui.DashboardHolder holder = (DashboardGui.DashboardHolder)invHolder;
            this.itemAdding(event, holder);
        }
    }

    private void itemAdding(InventoryCloseEvent event, DashboardGui.DashboardHolder holdder) {
        ItemStack item = event.getInventory().getItem(13);
        Shop shop = holdder.getShop();
        if (item == null || item.getType().equals((Object)shop.getMaterial())) {
            return;
        }
        if (item.getItemMeta().displayName() != null) {
            return;
        }
        shop.setMaterial(item.getType());
    }
}

