/*
 * Decompiled with CFR 0.152.
 */
package com.spygstudios.chestshop.listeners.gui;

import com.spygstudios.chestshop.ChestShop;
import com.spygstudios.chestshop.config.Message;
import com.spygstudios.chestshop.enums.GuiAction;
import com.spygstudios.chestshop.enums.ShopMode;
import com.spygstudios.chestshop.gui.ShopGui;
import com.spygstudios.chestshop.shop.ShopUtils;
import com.spygstudios.spyglib.color.TranslateColor;
import com.spygstudios.spyglib.persistentdata.PersistentData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ShopGuiHandler
implements Listener {
    private final ChestShop plugin;
    private final Map<UUID, Long> lastAmountClick;

    public ShopGuiHandler(ChestShop plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.lastAmountClick = new HashMap<UUID, Long>();
        this.plugin = plugin;
    }

    @EventHandler
    public void onShopClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder() instanceof ShopGui.ShopHolder)) {
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        event.setCancelled(true);
        PersistentData data = new PersistentData((JavaPlugin)this.plugin, clickedItem);
        String action = data.getString("action");
        if (action == null) {
            return;
        }
        GuiAction guiAction = GuiAction.valueOf(action);
        ShopGui.ShopHolder holder = (ShopGui.ShopHolder)event.getInventory().getHolder();
        Player player = holder.getPlayer();
        ShopMode currentMode = ShopGui.getPlayerMode(player);
        switch (guiAction) {
            case SET_ITEM_AMOUNT: {
                int max;
                if (System.currentTimeMillis() - this.getLastClick(event.getWhoClicked()) < 100L) {
                    return;
                }
                ItemStack item = event.getInventory().getItem(13);
                this.lastAmountClick.put(event.getWhoClicked().getUniqueId(), System.currentTimeMillis());
                if (currentMode == ShopMode.CUSTOMER_PURCHASING) {
                    int itemsLeft = holder.getShop().getItemsLeft();
                    max = Math.min(item.getMaxStackSize(), itemsLeft);
                } else {
                    int playerItems = ShopUtils.countDurableItemsInInventory((Inventory)player.getInventory(), holder.getShop().getMaterial());
                    max = Math.min(item.getMaxStackSize(), playerItems);
                }
                int min = 1;
                int modifier = data.getInt("amount");
                int currentAmount = item.getAmount();
                currentAmount = currentAmount + modifier >= max ? max : (currentAmount + modifier <= min ? min : (currentAmount += modifier));
                item.setAmount(currentAmount);
                ItemMeta shopMeta = item.getItemMeta();
                int finalCurrentAmount = currentAmount;
                String loreKey = currentMode == ShopMode.CUSTOMER_PURCHASING ? "shop.item-to-buy.lore" : "shop.item-to-sell.lore";
                double pricePerItem = currentMode == ShopMode.CUSTOMER_PURCHASING ? holder.getShop().getCustomerPurchasePrice() : holder.getShop().getCustomerSalePrice();
                List<Component> translatedLore = this.plugin.getGuiConfig().getStringList(loreKey).stream().map(line -> TranslateColor.translate((String)line.replace("%price%", String.valueOf(pricePerItem * (double)finalCurrentAmount)))).toList();
                shopMeta.lore(translatedLore);
                item.setItemMeta(shopMeta);
                break;
            }
            case BUY: {
                ItemStack shopItem = event.getInventory().getItem(13);
                int amount = shopItem.getAmount();
                holder.getShop().getShopTransactions().sell(player, amount);
                if (holder.getShop().getItemsLeft() != 0) break;
                holder.getShop().getHologram().updateHologramRows();
                player.closeInventory();
                Message.SHOP_EMPTY.send(player);
                break;
            }
            case SELL: {
                ItemStack sellItem = event.getInventory().getItem(13);
                int sellAmount = sellItem.getAmount();
                holder.getShop().getShopTransactions().buy(player, sellAmount);
                break;
            }
            case TOGGLE_MODE: {
                ShopMode newMode;
                ShopMode shopMode = newMode = currentMode == ShopMode.CUSTOMER_PURCHASING ? ShopMode.CUSTOMER_SELLING : ShopMode.CUSTOMER_PURCHASING;
                if (newMode == ShopMode.CUSTOMER_PURCHASING && !holder.getShop().acceptsCustomerPurchases() || newMode == ShopMode.CUSTOMER_SELLING && !holder.getShop().acceptsCustomerSales()) {
                    return;
                }
                ShopGui.setPlayerMode(player, newMode);
                ShopGui.open(this.plugin, player, holder.getShop(), newMode);
                break;
            }
            case OPEN_SHOP_INVENTORY: {
                holder.getShop().openShopInventory(player);
                break;
            }
        }
    }

    private Long getLastClick(HumanEntity player) {
        return this.lastAmountClick.getOrDefault(player.getUniqueId(), 0L);
    }
}

