/*
 * Decompiled with CFR 0.152.
 */
package com.spygstudios.chestshop.shop;

import com.spygstudios.chestshop.ChestShop;
import com.spygstudios.chestshop.config.Message;
import com.spygstudios.chestshop.enums.GuiAction;
import com.spygstudios.chestshop.shop.Shop;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.entity.Player;

public class AmountHandler {
    private static List<AmountHandler> pendingAmount = new ArrayList<AmountHandler>();
    private Player player;
    private double amount;
    private GuiAction type;
    private Shop shop;

    public AmountHandler(Player player, Shop shop, GuiAction type) {
        this.player = player;
        this.type = type;
        this.shop = shop;
        String cancelWord = ChestShop.getInstance().getConf().getString("cancel");
        switch (type) {
            case SET_SHOP_SELL_PRICE: {
                Message.ENTER_SELL_PRICE.send(player, Map.of("%cancel%", cancelWord));
                break;
            }
            case SET_SHOP_BUY_PRICE: {
                Message.ENTER_BUY_PRICE.send(player, Map.of("%cancel%", cancelWord));
                break;
            }
            default: {
                Message.ENTER_AMOUNT.send(player, Map.of("%cancel%", cancelWord));
            }
        }
        pendingAmount.add(this);
    }

    public void create(double amount) {
        if (this.type.equals((Object)GuiAction.SET_SHOP_SELL_PRICE)) {
            this.shop.setSellPrice(amount);
            Message.ENTER_SELL_PRICE_SUCCESS.send(this.player);
        } else if (this.type.equals((Object)GuiAction.SET_SHOP_BUY_PRICE)) {
            this.shop.setBuyPrice(amount);
            Message.ENTER_BUY_PRICE_SUCCESS.send(this.player);
        } else {
            Message.ENTER_AMOUNT_SUCCESS.send(this.player);
        }
        this.amount = amount;
        this.cancel();
    }

    public void cancel() {
        pendingAmount.remove(this);
    }

    public static AmountHandler getPendingAmount(Player player) {
        for (AmountHandler pendingNeed : pendingAmount) {
            if (!pendingNeed.getPlayer().equals(player)) continue;
            return pendingNeed;
        }
        return null;
    }

    @Generated
    public static List<AmountHandler> getPendingAmount() {
        return pendingAmount;
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public double getAmount() {
        return this.amount;
    }

    @Generated
    public GuiAction getType() {
        return this.type;
    }

    @Generated
    public Shop getShop() {
        return this.shop;
    }
}

