/*
 * Decompiled with CFR 0.152.
 */
package com.spygstudios.chestshop.shop;

import com.spygstudios.chestshop.ChestShop;
import com.spygstudios.chestshop.config.Message;
import com.spygstudios.chestshop.enums.ShopRemoveCause;
import com.spygstudios.chestshop.events.ShopRemoveEvent;
import com.spygstudios.chestshop.shop.ShopFile;
import com.spygstudios.chestshop.shop.ShopHologram;
import com.spygstudios.chestshop.shop.ShopTransactions;
import com.spygstudios.chestshop.shop.ShopUtils;
import com.spygstudios.spyglib.hologram.HologramItemRow;
import com.spygstudios.spyglib.hologram.HologramRow;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class Shop {
    private UUID ownerId;
    private double sellPrice;
    private double buyPrice;
    private Material material;
    private Location chestLocation;
    private String createdAt;
    private String name;
    private boolean isNotify;
    private boolean canSellToPlayers;
    private boolean canBuyFromPlayers;
    private List<UUID> addedPlayers;
    private ShopTransactions shopTransactions;
    private ShopHologram hologram;
    private ShopFile shopFile;
    private static final List<Shop> SHOPS = new ArrayList<Shop>();
    private static ChestShop plugin = ChestShop.getInstance();

    public Shop(Player owner, String shopName, Location chestLocation, ShopFile shopFile) {
        this(owner.getUniqueId(), shopName, 0.0, 0.0, null, chestLocation, ShopFile.getDateString(), false, true, false, new ArrayList<UUID>(), shopFile);
        shopFile.addShop(this);
    }

    public Shop(UUID ownerId, String shopName, double sellPrice, double buyPrice, Material material, Location chestLocation, String createdAt, boolean isNotify, boolean canSell, boolean canBuy, List<UUID> addedPlayers, ShopFile shopFile) {
        this.ownerId = ownerId;
        this.name = shopName;
        this.sellPrice = ShopUtils.parsePrice(sellPrice);
        this.buyPrice = ShopUtils.parsePrice(buyPrice);
        this.material = material;
        this.chestLocation = chestLocation;
        this.createdAt = createdAt;
        this.isNotify = isNotify;
        this.canSellToPlayers = canSell;
        this.canBuyFromPlayers = canBuy;
        this.addedPlayers = addedPlayers;
        this.shopFile = shopFile;
        this.shopTransactions = new ShopTransactions(this, shopFile);
        this.hologram = new ShopHologram(this, plugin);
        SHOPS.add(this);
    }

    public String getMaterialString() {
        if (this.material == null) {
            return plugin.getConf().getString("shops.unknown.material");
        }
        String materialString = this.getMaterial().toString();
        return materialString.length() > 14 ? materialString.substring(0, 14) : materialString;
    }

    public int getSoldItems() {
        return this.shopFile.getInt("shops." + this.name + ".sold-items");
    }

    public int getMoneyEarned() {
        return this.shopFile.getInt("shops." + this.name + ".money-earned");
    }

    public int getBoughtItems() {
        return this.shopFile.getInt("shops." + this.name + ".bought-items");
    }

    public int getMoneySpent() {
        return this.shopFile.getInt("shops." + this.name + ".money-spent");
    }

    public String getChestLocationString() {
        return this.chestLocation.getWorld().getName() + ", x: " + this.chestLocation.getBlockX() + " y: " + this.chestLocation.getBlockY() + " z: " + this.chestLocation.getBlockZ();
    }

    public void setMaterial(Material material) {
        this.material = material;
        ShopFile.getShopFile(this.ownerId).setMaterial(this.name, material);
        HologramRow hologramRow = (HologramRow)this.hologram.getHologram().getRows().get(plugin.getConf().getStringList("shops.lines").size());
        if (hologramRow instanceof HologramItemRow) {
            HologramItemRow row = (HologramItemRow)hologramRow;
            row.setItem(new ItemStack(material));
        }
    }

    public void setName(String newName) {
        ShopFile.getShopFile(this.ownerId).setName(this.name, newName);
        this.name = newName;
        this.hologram.updateHologramRows();
    }

    public double getSellPrice() {
        return ShopUtils.parsePrice(this.sellPrice);
    }

    public double getBuyPrice() {
        return ShopUtils.parsePrice(this.buyPrice);
    }

    public boolean acceptsCustomerPurchases() {
        return this.isCanSellToPlayers();
    }

    public boolean acceptsCustomerSales() {
        return this.isCanBuyFromPlayers();
    }

    public double getCustomerPurchasePrice() {
        return this.getSellPrice();
    }

    public double getCustomerSalePrice() {
        return this.getBuyPrice();
    }

    public void setSellPrice(double sellPrice) {
        this.sellPrice = ShopUtils.parsePrice(sellPrice);
        ShopFile.getShopFile(this.ownerId).setSellPrice(this.name, this.sellPrice);
        this.hologram.updateHologramRows();
    }

    public void setBuyPrice(double buyPrice) {
        this.buyPrice = ShopUtils.parsePrice(buyPrice);
        ShopFile.getShopFile(this.ownerId).setBuyPrice(this.name, this.buyPrice);
        this.hologram.updateHologramRows();
    }

    public void setNotify(boolean notify) {
        this.isNotify = notify;
        this.shopFile.overwriteSet("shops." + this.name + ".do-notify", notify);
    }

    public void setCanSellToPlayers(boolean canSellToPlayers) {
        this.canSellToPlayers = canSellToPlayers;
        this.shopFile.overwriteSet("shops." + this.name + ".can-sell", canSellToPlayers);
        this.hologram.updateHologramRows();
    }

    public void setCanBuyFromPlayers(boolean canBuyFromPlayers) {
        this.canBuyFromPlayers = canBuyFromPlayers;
        this.shopFile.overwriteSet("shops." + this.name + ".can-buy", canBuyFromPlayers);
        this.hologram.updateHologramRows();
    }

    public void addPlayer(UUID uuid) {
        if (this.addedPlayers.contains(uuid)) {
            Message.PLAYER_ALREADY_ADDED.send(Bukkit.getPlayer((UUID)this.ownerId), Map.of("%player-name%", Bukkit.getOfflinePlayer((UUID)uuid).getName()));
            return;
        }
        this.addedPlayers.add(uuid);
        this.shopFile.addPlayer(uuid, this.name);
        Message.PLAYER_ADDED.send(Bukkit.getPlayer((UUID)this.ownerId), Map.of("%player-name%", Bukkit.getOfflinePlayer((UUID)uuid).getName()));
    }

    public void removePlayer(OfflinePlayer player) {
        this.removePlayer(player.getUniqueId());
    }

    public void removePlayer(UUID uuid) {
        if (!this.addedPlayers.contains(uuid)) {
            Message.PLAYER_NOT_ADDED.send(Bukkit.getPlayer((UUID)this.ownerId), Map.of("%player-name%", Bukkit.getOfflinePlayer((UUID)uuid).getName()));
            return;
        }
        this.addedPlayers.remove(uuid);
        this.shopFile.removePlayer(uuid, this.name);
        Message.PLAYER_REMOVED.send(Bukkit.getPlayer((UUID)this.ownerId), Map.of("%player-name%", Bukkit.getOfflinePlayer((UUID)uuid).getName()));
    }

    public void remove(Player remover, ShopRemoveCause cause) {
        ShopRemoveEvent shopRemoveEvent = new ShopRemoveEvent(this, cause, remover);
        Bukkit.getPluginManager().callEvent((Event)shopRemoveEvent);
        Shop.removeShop(this);
    }

    public int getItemsLeft() {
        Chest chest = (Chest)this.chestLocation.getBlock().getState();
        return ShopUtils.countDurableItemsInInventory(chest.getInventory(), this.material);
    }

    /*
     * WARNING - void declaration
     */
    public void openShopInventory(Player player) {
        void chest;
        BlockState blockState = this.chestLocation.getBlock().getState();
        if (!(blockState instanceof Chest)) {
            return;
        }
        Chest chest2 = (Chest)blockState;
        player.openInventory(chest.getInventory());
    }

    public static List<Shop> getShops(Player owner) {
        return Shop.getShops(owner.getUniqueId());
    }

    public static List<Shop> getShops(UUID ownerId) {
        ArrayList<Shop> shops = new ArrayList<Shop>();
        for (Shop shop : SHOPS) {
            if (!shop.getOwnerId().equals(ownerId)) continue;
            shops.add(shop);
        }
        return shops;
    }

    public static List<Shop> getShops() {
        return new ArrayList<Shop>(SHOPS);
    }

    public static Shop getShop(UUID ownerId, String name) {
        for (Shop shop : SHOPS) {
            if (!shop.getOwnerId().equals(ownerId) || !shop.getName().equalsIgnoreCase(name)) continue;
            return shop;
        }
        return null;
    }

    public static Shop getShop(Location location) {
        for (Shop shop : SHOPS) {
            Block adj;
            Location shopLoc = shop.getChestLocation();
            if (!shopLoc.getWorld().isChunkLoaded(shopLoc.getBlockX() >> 4, shopLoc.getBlockZ() >> 4)) continue;
            Block shopBlock = shopLoc.getBlock();
            if (shopLoc.equals((Object)location)) {
                return shop;
            }
            if (!ShopUtils.isDoubleChest(shopBlock) || (adj = ShopUtils.getAdjacentChest(shopBlock)) == null || !adj.getLocation().equals((Object)location)) continue;
            return shop;
        }
        return null;
    }

    public static void removeShop(Shop shop) {
        ShopFile.getShopFile(shop.getOwnerId()).removeShop(shop.getName());
        shop.hologram.removeHologram();
        SHOPS.remove(shop);
    }

    @Generated
    public UUID getOwnerId() {
        return this.ownerId;
    }

    @Generated
    public Material getMaterial() {
        return this.material;
    }

    @Generated
    public Location getChestLocation() {
        return this.chestLocation;
    }

    @Generated
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean isNotify() {
        return this.isNotify;
    }

    @Generated
    public boolean isCanSellToPlayers() {
        return this.canSellToPlayers;
    }

    @Generated
    public boolean isCanBuyFromPlayers() {
        return this.canBuyFromPlayers;
    }

    @Generated
    public List<UUID> getAddedPlayers() {
        return this.addedPlayers;
    }

    @Generated
    public ShopTransactions getShopTransactions() {
        return this.shopTransactions;
    }

    @Generated
    public ShopHologram getHologram() {
        return this.hologram;
    }
}

