/*
 * Decompiled with CFR 0.152.
 */
package com.spygstudios.chestshop.shop;

import com.spygstudios.chestshop.ChestShop;
import com.spygstudios.chestshop.shop.Shop;
import com.spygstudios.chestshop.shop.ShopUtils;
import com.spygstudios.spyglib.location.LocationUtils;
import com.spygstudios.spyglib.yamlmanager.YamlManager;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ShopFile
extends YamlManager {
    private UUID ownerId;
    private boolean isSaved;
    private static final Map<UUID, ShopFile> SHOPS_FILES = new HashMap<UUID, ShopFile>();

    public ShopFile(ChestShop plugin, Player owner) {
        this(plugin, owner.getUniqueId());
    }

    public ShopFile(ChestShop plugin, UUID ownerId) {
        super("shops/" + String.valueOf(ownerId) + ".yml", (JavaPlugin)plugin);
        if (SHOPS_FILES.containsKey(ownerId)) {
            return;
        }
        this.set("shops", null);
        ShopFile.setDefaultValues(this);
        this.isSaved = true;
        this.ownerId = ownerId;
        SHOPS_FILES.put(ownerId, this);
    }

    public void setPlayers(List<UUID> players, String shopName) {
        this.overwriteSet("shops." + shopName + ".added-players", players.stream().map(UUID::toString).toList());
        this.isSaved = false;
    }

    public void addPlayer(UUID player, String shopName) {
        List<UUID> players = this.getAddedUuids(shopName);
        players.add(player);
        this.setPlayers(players, shopName);
    }

    public void removePlayer(UUID player, String shopName) {
        List<UUID> players = this.getAddedUuids(shopName);
        players.remove(player);
        this.setPlayers(players, shopName);
    }

    public List<UUID> getAddedUuids(String shopName) {
        return new ArrayList<UUID>(this.getStringList("shops." + shopName + ".added-players").stream().map(UUID::fromString).toList());
    }

    public Set<String> getPlayerShops() {
        if (this.getConfigurationSection("shops") == null) {
            return new HashSet<String>();
        }
        return this.getConfigurationSection("shops").getKeys(false);
    }

    public void removeShop(String shopName) {
        for (String shop : this.getPlayerShops()) {
            if (!shop.equalsIgnoreCase(shopName)) continue;
            this.overwriteSet("shops." + shop, null);
            this.isSaved = false;
            return;
        }
    }

    private static void setDefaultValues(ShopFile shopFile) {
        for (String shopName : shopFile.getPlayerShops()) {
            String shopPath = "shops." + shopName;
            shopFile.set(shopPath + ".price", 0);
            shopFile.set(shopPath + ".sell-price", 0);
            shopFile.set(shopPath + ".buy-price", 0);
            shopFile.set(shopPath + ".do-notify", false);
            shopFile.set(shopPath + ".can-sell", true);
            shopFile.set(shopPath + ".can-buy", false);
            shopFile.set(shopPath + ".sold-items", 0);
            shopFile.set(shopPath + ".money-earned", 0);
            shopFile.set(shopPath + ".created", ShopFile.getDateString());
            shopFile.isSaved = false;
        }
    }

    public void addShop(Shop shop) {
        String name = shop.getName();
        this.set("shops." + name + ".price", 0);
        this.set("shops." + name + ".sell-price", 0);
        this.set("shops." + name + ".buy-price", 0);
        this.set("shops." + name + ".material", null);
        this.set("shops." + name + ".location", LocationUtils.fromLocation((Location)shop.getChestLocation(), (boolean)true));
        this.set("shops." + name + ".do-notify", false);
        this.set("shops." + name + ".can-sell", true);
        this.set("shops." + name + ".can-buy", false);
        this.set("shops." + name + ".created", ShopFile.getDateString());
        this.set("shops." + name + ".added-players", new ArrayList());
        this.isSaved = false;
    }

    public void setName(String shopName, String name) {
        this.set("shops." + name + ".price", this.getDouble("shops." + shopName + ".price", 0.0));
        this.set("shops." + name + ".sell-price", this.getDouble("shops." + shopName + ".sell-price", 0.0));
        this.set("shops." + name + ".buy-price", this.getDouble("shops." + shopName + ".buy-price", 0.0));
        this.set("shops." + name + ".material", this.getString("shops." + shopName + ".material", null));
        this.set("shops." + name + ".location", this.getString("shops." + shopName + ".location"));
        this.set("shops." + name + ".do-notify", this.getBoolean("shops." + shopName + ".do-notify", false));
        this.set("shops." + name + ".can-sell", this.getBoolean("shops." + shopName + ".can-sell", true));
        this.set("shops." + name + ".can-buy", this.getBoolean("shops." + shopName + ".can-buy", false));
        this.set("shops." + name + ".created", this.getString("shops." + shopName + ".created", ShopFile.getDateString()));
        this.set("shops." + name + ".added-players", this.getStringList("shops." + shopName + ".added-players"));
        this.overwriteSet("shops." + shopName, null);
        this.isSaved = false;
    }

    public void setMaterial(String shopName, Material material) {
        this.overwriteSet("shops." + shopName + ".material", material == null ? null : material.name());
        this.isSaved = false;
    }

    public void setPrice(String shopName, double price) {
        this.overwriteSet("shops." + shopName + ".price", price);
        this.isSaved = false;
    }

    public void setSellPrice(String shopName, double sellPrice) {
        this.overwriteSet("shops." + shopName + ".sell-price", sellPrice);
        this.isSaved = false;
    }

    public void setBuyPrice(String shopName, double buyPrice) {
        this.overwriteSet("shops." + shopName + ".buy-price", buyPrice);
        this.isSaved = false;
    }

    public void save() {
        this.isSaved = false;
    }

    public static String getDateString() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        return LocalDateTime.now().format(formatter);
    }

    public static void loadShopFiles(ChestShop plugin) {
        plugin.getLogger().info("Loading shops...");
        File shopsFolder = new File(plugin.getDataFolder(), "shops");
        if (!shopsFolder.exists()) {
            shopsFolder.mkdirs();
            plugin.getLogger().info("Shops loaded!");
            return;
        }
        File[] fileArray = shopsFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            ShopFile.processShopFile(plugin, file);
            ++n2;
        }
        plugin.getLogger().info("Shops loaded!");
    }

    private static void processShopFile(ChestShop plugin, File file) {
        UUID ownerId;
        if (!file.isFile() || !file.getName().endsWith(".yml")) {
            return;
        }
        try {
            ownerId = UUID.fromString(file.getName().replace(".yml", ""));
        }
        catch (IllegalArgumentException e) {
            plugin.getLogger().warning("Invalid shop file: " + file.getName() + " (invalid UUID)");
            return;
        }
        ShopFile shopFile = new ShopFile(plugin, ownerId);
        for (String shopName : shopFile.getPlayerShops()) {
            ShopFile.processShop(plugin, file, shopFile, shopName);
        }
    }

    private static void processShop(ChestShop plugin, File file, ShopFile shopFile, String shopName) {
        String shopPath = "shops." + shopName;
        String locationString = shopFile.getString(shopPath + ".location");
        if (locationString == null) {
            plugin.getLogger().warning("Invalid shop file: " + file.getName() + " (location is null) removing shop...");
            shopFile.removeShop(shopName);
            return;
        }
        Location location = LocationUtils.toLocation((String)locationString);
        if (location.getWorld() == null || ShopUtils.isDisabledWorld(location.getWorld().getName())) {
            return;
        }
        if (!location.getBlock().getType().equals((Object)Material.CHEST)) {
            plugin.getLogger().warning("Invalid shop in: " + file.getName() + " (chest is not a chest) removing shop...");
            shopFile.removeShop(shopName);
            return;
        }
        double sellPrice = shopFile.getDouble("shops." + shopName + ".sell-price", shopFile.getDouble("shops." + shopName + ".price", 0.0));
        double buyPrice = shopFile.getDouble("shops." + shopName + ".buy-price", 0.0);
        Material material = Material.getMaterial((String)shopFile.getString("shops." + shopName + ".material"));
        String createdAt = shopFile.getString("shops." + shopName + ".created");
        boolean isNotify = shopFile.getBoolean("shops." + shopName + ".do-notify");
        boolean canSell = shopFile.getBoolean("shops." + shopName + ".can-sell", true);
        boolean canBuy = shopFile.getBoolean("shops." + shopName + ".can-buy", false);
        new Shop(shopFile.getOwnerId(), shopName, sellPrice, buyPrice, material, location, createdAt, isNotify, canSell, canBuy, shopFile.getAddedUuids(shopName), shopFile);
    }

    public static ShopFile getShopFile(UUID ownerId) {
        return SHOPS_FILES.get(ownerId);
    }

    public static ShopFile getShopFile(Player owner) {
        return ShopFile.getShopFile(owner.getUniqueId());
    }

    public static void removeShopFile(UUID ownerId) {
        SHOPS_FILES.remove(ownerId);
    }

    public static void removeShopFile(Player owner) {
        ShopFile.removeShopFile(owner.getUniqueId());
    }

    public static Map<UUID, ShopFile> getShopsFiles() {
        return new HashMap<UUID, ShopFile>(SHOPS_FILES);
    }

    public static void startSaveScheduler(ChestShop plugin) {
        plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)plugin, ShopFile::saveShops, 0L, 20L * (long)plugin.getConf().getInt("shops.save-interval", 60));
    }

    public static void saveShops() {
        for (ShopFile shopFile : SHOPS_FILES.values()) {
            if (shopFile.isSaved) continue;
            shopFile.saveConfig();
            shopFile.isSaved = true;
        }
    }

    @Generated
    public UUID getOwnerId() {
        return this.ownerId;
    }
}

