/*
 * Decompiled with CFR 0.152.
 */
package com.spygstudios.chestshop.shop;

import com.spygstudios.chestshop.ChestShop;
import com.spygstudios.chestshop.config.Config;
import com.spygstudios.chestshop.shop.Shop;
import com.spygstudios.spyglib.color.TranslateColor;
import com.spygstudios.spyglib.hologram.Hologram;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ShopHologram {
    private final Hologram hologram;
    private final Shop shop;
    private final Config config;

    public ShopHologram(Shop shop, ChestShop plugin) {
        this.shop = shop;
        this.config = plugin.getConf();
        int hologramRange = this.config.getInt("shops.holograms.range");
        boolean seeTroughWalls = this.config.getBoolean("shops.holograms.see-through-walls");
        this.hologram = plugin.getHologramManager().createHologram(shop.getChestLocation().clone().add(0.5, 0.7, 0.5), seeTroughWalls, hologramRange);
        this.updateHologramRows();
    }

    public void updateHologramRows() {
        while (!this.hologram.getRows().isEmpty()) {
            this.hologram.removeRow(0);
        }
        this.hologram.setViewDistance(this.config.getInt("shops.holograms.range"));
        this.hologram.setSeeTrough(this.config.getBoolean("shops.holograms.see-through-walls"));
        String owner = Bukkit.getOfflinePlayer((UUID)this.shop.getOwnerId()).getName();
        this.config.getStringList("shops.lines").forEach(line -> {
            String buyPrice = this.config.getString("shops.price-format.buy").replace("%price%", String.valueOf(this.shop.getCustomerPurchasePrice()));
            String sellPrice = this.config.getString("shops.price-format.sell").replace("%price%", String.valueOf(this.shop.getCustomerSalePrice()));
            String priceDisplay = "";
            priceDisplay = this.shop.acceptsCustomerPurchases() && this.shop.acceptsCustomerSales() ? this.config.getString("shops.price-format.combined").replace("%sell-price%", sellPrice).replace("%buy-price%", buyPrice) : (this.shop.acceptsCustomerPurchases() ? buyPrice : (this.shop.acceptsCustomerSales() ? sellPrice : this.config.getString("shops.unknown.mode")));
            this.hologram.addRow(TranslateColor.translate((String)line.replace("%owner%", owner == null ? this.config.getString("shops.unknown.owner") : owner).replace("%shop-name%", this.shop.getName()).replace("%price%", priceDisplay).replace("%sell-price%", sellPrice).replace("%buy-price%", buyPrice).replace("%material%", this.shop.getMaterialString())));
        });
        this.hologram.addRow(new ItemStack(this.shop.getMaterial() == null || this.shop.getItemsLeft() == 0 && ChestShop.getInstance().getConf().getBoolean("shops.barrier-when-empty") ? Material.BARRIER : this.shop.getMaterial()));
    }

    public void removeHologram() {
        if (this.hologram != null) {
            this.hologram.remove();
        }
    }

    @Generated
    public Hologram getHologram() {
        return this.hologram;
    }
}

