/*
 * Decompiled with CFR 0.152.
 */
package com.spygstudios.chestshop.shop;

import com.spygstudios.chestshop.ChestShop;
import com.spygstudios.chestshop.config.Message;
import com.spygstudios.chestshop.shop.Shop;
import com.spygstudios.chestshop.shop.ShopFile;
import com.spygstudios.chestshop.shop.ShopUtils;
import com.spygstudios.spyglib.inventory.InventoryUtils;
import java.util.Map;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ShopTransactions {
    private final Shop shop;
    private final ChestShop plugin;
    private final ShopFile shopFile;

    public ShopTransactions(Shop shop, ShopFile shopFile) {
        this.shopFile = shopFile;
        this.shop = shop;
        this.plugin = ChestShop.getInstance();
    }

    public void sell(Player buyer, int amount) {
        int itemCount;
        if (!this.shop.acceptsCustomerPurchases()) {
            return;
        }
        int itemsLeft = this.shop.getItemsLeft();
        int n = itemCount = itemsLeft < amount ? itemsLeft : amount;
        if (!InventoryUtils.hasFreeSlot((Player)buyer)) {
            Message.SHOP_INVENTORY_FULL.send(buyer);
            return;
        }
        double itemsPrice = (double)itemCount * this.shop.getCustomerPurchasePrice();
        Economy economy = this.plugin.getEconomy();
        EconomyResponse response = economy.withdrawPlayer((OfflinePlayer)buyer, itemsPrice);
        if (!response.transactionSuccess()) {
            Message.NOT_ENOUGH_MONEY.send(buyer, Map.of("%price%", String.valueOf(itemsPrice)));
            return;
        }
        economy.depositPlayer(Bukkit.getOfflinePlayer((UUID)this.shop.getOwnerId()), itemsPrice);
        Inventory chestInventory = ((Chest)this.shop.getChestLocation().getBlock().getState()).getInventory();
        int soldItems = ShopUtils.extractItems(chestInventory, (Inventory)buyer.getInventory(), this.shop.getMaterial(), itemCount);
        Message.SHOP_BOUGHT.send(buyer, Map.of("%price%", String.valueOf(itemsPrice), "%material%", this.shop.getMaterial().name(), "%items-left%", String.valueOf(itemsLeft -= itemCount), "%items-bought%", String.valueOf(soldItems)));
        this.shopFile.overwriteSet("shops." + this.shop.getName() + ".sold-items", this.shopFile.getInt("shops." + this.shop.getName() + ".sold-items") + soldItems);
        this.shopFile.overwriteSet("shops." + this.shop.getName() + ".money-earned", this.shopFile.getDouble("shops." + this.shop.getName() + ".money-earned") + itemsPrice);
        this.shopFile.save();
        Player owner = Bukkit.getPlayer((UUID)this.shop.getOwnerId());
        if (this.shop.isNotify() && owner != null) {
            Message.SHOP_SOLD.send(owner, Map.of("%price%", String.valueOf(itemsPrice), "%material%", this.shop.getMaterial().name(), "%player-name%", buyer.getName(), "%items-left%", String.valueOf(itemsLeft), "%items-bought%", String.valueOf(itemCount)));
        }
    }

    public void buy(Player seller, int amount) {
        if (!this.shop.acceptsCustomerSales()) {
            return;
        }
        Material material = this.shop.getMaterial();
        int playerItemCount = ShopUtils.countDurableItemsInInventory((Inventory)seller.getInventory(), material);
        if (playerItemCount < amount) {
            Message.NOT_ENOUGH_ITEMS.send(seller, Map.of("%material%", material.name(), "%amount%", String.valueOf(amount)));
            seller.closeInventory();
            return;
        }
        Chest chest = (Chest)this.shop.getChestLocation().getBlock().getState();
        if (!this.hasChestSpace(chest, material, amount)) {
            Message.SHOP_CHEST_FULL.send(seller);
            if (!this.shop.isNotify()) {
                return;
            }
            Player owner = Bukkit.getPlayer((UUID)this.shop.getOwnerId());
            if (owner != null) {
                Message.SHOP_CHEST_FULL_OWNER.send(owner, Map.of("%player-name%", seller.getName(), "%material%", material.name(), "%amount%", String.valueOf(amount), "%shop-name%", this.shop.getName()));
            }
        }
        double itemsPrice = (double)amount * this.shop.getCustomerSalePrice();
        Economy economy = this.plugin.getEconomy();
        if (economy.getBalance(Bukkit.getOfflinePlayer((UUID)this.shop.getOwnerId())) < itemsPrice) {
            Message.SHOP_OWNER_NO_MONEY.send(seller);
            if (!this.shop.isNotify()) {
                return;
            }
            Player owner = Bukkit.getPlayer((UUID)this.shop.getOwnerId());
            if (owner != null) {
                Message.SHOP_OWNER_NO_MONEY_OWNER.send(owner, Map.of("%player-name%", seller.getName(), "%material%", material.name(), "%price%", String.valueOf(itemsPrice)));
            }
        }
        Inventory chestInventory = ((Chest)this.shop.getChestLocation().getBlock().getState()).getInventory();
        int soldItems = ShopUtils.extractItems((Inventory)seller.getInventory(), chestInventory, material, amount);
        EconomyResponse withdrawResponse = economy.withdrawPlayer(Bukkit.getOfflinePlayer((UUID)this.shop.getOwnerId()), itemsPrice);
        if (withdrawResponse.transactionSuccess()) {
            economy.depositPlayer((OfflinePlayer)seller, itemsPrice);
        }
        this.shopFile.overwriteSet("shops." + this.shop.getName() + ".bought-items", this.shopFile.getInt("shops." + this.shop.getName() + ".bought-items") + soldItems);
        this.shopFile.overwriteSet("shops." + this.shop.getName() + ".money-spent", this.shopFile.getDouble("shops." + this.shop.getName() + ".money-spent") + itemsPrice);
        this.shopFile.save();
        Message.SHOP_SOLD_TO.send(seller, Map.of("%price%", String.valueOf(itemsPrice), "%material%", material.name(), "%items-sold%", String.valueOf(soldItems)));
        Player owner = Bukkit.getPlayer((UUID)this.shop.getOwnerId());
        if (this.shop.isNotify() && owner != null) {
            Message.SHOP_BOUGHT_FROM.send(owner, Map.of("%price%", String.valueOf(itemsPrice), "%material%", material.name(), "%player-name%", seller.getName(), "%items-bought%", String.valueOf(soldItems)));
        }
    }

    private boolean hasChestSpace(Chest chest, Material material, int amount) {
        int maxStackSize = material.getMaxStackSize();
        int remainingAmount = amount;
        ItemStack[] itemStackArray = chest.getInventory().getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack item = itemStackArray[n2];
            if (remainingAmount <= 0) break;
            if (item == null) {
                remainingAmount -= maxStackSize;
            } else if (item.getType() == material && item.getAmount() < maxStackSize) {
                remainingAmount -= maxStackSize - item.getAmount();
            }
            ++n2;
        }
        return remainingAmount <= 0;
    }
}

