/*
 * Decompiled with CFR 0.152.
 */
package com.spygstudios.chestshop.shop;

import com.spygstudios.chestshop.ChestShop;
import com.spygstudios.spyglib.inventory.InventoryUtils;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Chest;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class ShopUtils {
    private static ChestShop plugin = ChestShop.getInstance();

    public static boolean isDisabledWorld(String worldName) {
        for (String disabledWorldName : plugin.getConf().getStringList("shops.disabled-worlds")) {
            if (!worldName.equalsIgnoreCase(disabledWorldName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlacklistedName(String name) {
        String nameLowerCase = name.toLowerCase();
        for (String invalidName : plugin.getConf().getStringList("shops.blacklisted-names")) {
            if (!nameLowerCase.contains(invalidName.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static double parsePrice(double price) {
        boolean centsEnabled = plugin.getConf().getBoolean("shops.decimals.enabled");
        double maxDecimals = centsEnabled ? Math.pow(10.0, plugin.getConf().getInt("shops.decimals.max")) : 1.0;
        return (double)Math.round(price * maxDecimals) / maxDecimals;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isDoubleChest(Block block) {
        void chestData;
        if (block.getType() != Material.CHEST) {
            return false;
        }
        BlockData data = block.getBlockData();
        if (!(data instanceof Chest)) {
            return false;
        }
        Chest chest = (Chest)data;
        return chestData.getType() != Chest.Type.SINGLE;
    }

    /*
     * WARNING - void declaration
     */
    public static Block getAdjacentChest(Block block) {
        void chestData;
        if (block.getType() != Material.CHEST) {
            return null;
        }
        BlockData data = block.getBlockData();
        if (!(data instanceof Directional)) {
            return null;
        }
        if (!(data instanceof Chest)) {
            return null;
        }
        Chest chest = (Chest)data;
        if (chestData.getType() == Chest.Type.SINGLE) {
            return null;
        }
        BlockFace facing = chestData.getFacing();
        BlockFace offset = ShopUtils.getConnectedChestOffset(facing, chestData.getType());
        if (offset == null) {
            return null;
        }
        Block otherBlock = block.getRelative(offset);
        if (otherBlock.getType() == Material.CHEST) {
            return otherBlock;
        }
        return null;
    }

    private static BlockFace getConnectedChestOffset(BlockFace facing, Chest.Type type) {
        return switch (facing) {
            case BlockFace.NORTH -> {
                if (type == Chest.Type.RIGHT) {
                    yield BlockFace.WEST;
                }
                yield BlockFace.EAST;
            }
            case BlockFace.SOUTH -> {
                if (type == Chest.Type.RIGHT) {
                    yield BlockFace.EAST;
                }
                yield BlockFace.WEST;
            }
            case BlockFace.WEST -> {
                if (type == Chest.Type.RIGHT) {
                    yield BlockFace.SOUTH;
                }
                yield BlockFace.NORTH;
            }
            case BlockFace.EAST -> {
                if (type == Chest.Type.RIGHT) {
                    yield BlockFace.NORTH;
                }
                yield BlockFace.SOUTH;
            }
            default -> null;
        };
    }

    public static int getMaxShops(Player player) {
        int maxShops = plugin.getConf().getInt("shops.max-shops.default");
        if (maxShops == -1) {
            return -1;
        }
        for (String permission : plugin.getConf().getConfigurationSection("shops.max-shops").getKeys(false)) {
            if (permission.equals("default") || !player.hasPermission("spygchestshop.max." + permission)) continue;
            int value = plugin.getConf().getInt("shops.max-shops." + permission);
            if (value == -1) {
                return -1;
            }
            maxShops = Math.max(maxShops, value);
        }
        return maxShops;
    }

    public static int countDurableItemsInInventory(Inventory inventory, Material material) {
        int itemCount = InventoryUtils.countItems((Inventory)inventory, item -> {
            if (!item.getType().equals((Object)material)) {
                return false;
            }
            return ShopUtils.isDurabilitySufficient(item);
        });
        return itemCount;
    }

    private static boolean isDurabilitySufficient(ItemStack item) {
        Damageable damageable;
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta instanceof Damageable && (damageable = (Damageable)itemMeta).hasDamage()) {
            short maxDurability = item.getType().getMaxDurability();
            int damageInPercent = (int)Math.ceil((double)damageable.getDamage() / (double)maxDurability * 100.0);
            int durabilityInPercent = 100 - damageInPercent;
            int minDurabilityPercent = plugin.getConfig().getInt("shops.minimum-durability");
            if (minDurabilityPercent > durabilityInPercent) {
                return false;
            }
        }
        return true;
    }

    public static int extractItems(Inventory fromInventory, Inventory toInventory, Material material, int itemCount) {
        int extractedItems = 0;
        ItemStack[] itemStackArray = fromInventory.getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack chestItem = itemStackArray[n2];
            if (itemCount <= 0) break;
            if (chestItem != null && chestItem.getType() == material && ShopUtils.isDurabilitySufficient(chestItem)) {
                int chestAmount = chestItem.getAmount();
                int removeAmount = Math.min(itemCount, chestAmount);
                ItemStack clone = chestItem.clone();
                clone.setAmount(removeAmount);
                HashMap leftover = toInventory.addItem(new ItemStack[]{clone});
                if (leftover.isEmpty()) {
                    chestItem.setAmount(chestAmount - removeAmount);
                    itemCount -= removeAmount;
                    extractedItems += removeAmount;
                } else {
                    int added = removeAmount - leftover.values().stream().mapToInt(ItemStack::getAmount).sum();
                    chestItem.setAmount(chestAmount - added);
                    itemCount -= added;
                    extractedItems += added;
                    break;
                }
            }
            ++n2;
        }
        return extractedItems;
    }
}

