/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.floral_tonics_and_tinctures.magic.enchantments.event;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.trashelemental.floral_tonics_and_tinctures.magic.enchantments.ModEnchantments;
import net.trashelemental.floral_tonics_and_tinctures.util.ModTags;

@Mod.EventBusSubscriber
public class FloralGiftEvents {
    @SubscribeEvent
    public static void FloralGiftActivateEvent(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        Level level = entity2.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (!((GameRules.BooleanValue)level2.m_46469_().m_46170_(GameRules.f_46135_)).m_46223_()) {
            return;
        }
        ItemStack weapon = entity2.m_6844_(EquipmentSlot.MAINHAND);
        if (weapon.m_41619_() || !weapon.m_41793_()) {
            return;
        }
        int enchantmentLevel = weapon.getEnchantmentLevel((Enchantment)ModEnchantments.FLORAL_GIFT.get());
        if (enchantmentLevel <= 0) {
            return;
        }
        float activationChance = 0.4f + 0.1f * (float)(enchantmentLevel - 1);
        if (entity2.m_217043_().m_188501_() > activationChance) {
            return;
        }
        Optional<Item> randomItem = FloralGiftEvents.getRandomItemFromTag(level2, ModTags.Items.HERBALISM_INGREDIENTS);
        if (randomItem.isEmpty()) {
            return;
        }
        ItemStack drop = new ItemStack((ItemLike)randomItem.get());
        event.getEntity().m_19983_(drop);
    }

    private static Optional<Item> getRandomItemFromTag(ServerLevel level, TagKey<Item> tagKey) {
        Registry itemRegistry = level.m_9598_().m_175515_(Registries.f_256913_);
        HolderSet.Named tagSet = itemRegistry.m_203431_(tagKey).orElse(null);
        if (tagSet == null || tagSet.m_203632_() == 0) {
            System.out.println("Tag " + tagKey.f_203868_() + " is empty or missing.");
            return Optional.empty();
        }
        List<Item> items = tagSet.m_203614_().map(Holder::m_203334_).toList();
        Item randomItem = items.get(level.f_46441_.m_188503_(items.size()));
        return Optional.of(randomItem);
    }
}

