/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.floral_tonics_and_tinctures.junkyard_lib.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TamableEntity
extends TamableAnimal {
    private final Item tameItem;
    private final Item breedItem;
    public Behavior behavior = Behavior.WANDER;

    public TamableEntity(EntityType<? extends TamableAnimal> entityType, Level level, Item tameItem, Item breedItem) {
        super(entityType, level);
        this.tameItem = tameItem;
        this.breedItem = breedItem;
    }

    public static boolean isTame(TamableEntity entity) {
        return entity.m_21824_();
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_150930_(this.breedItem);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)this.m_6095_().m_20615_((Level)serverLevel);
    }

    public void m_8119_() {
        TamableAnimal ta;
        super.m_8119_();
        LivingEntity target = this.m_5448_();
        LivingEntity owner = this.m_269323_();
        if (owner != null && target instanceof TamableAnimal && (ta = (TamableAnimal)target).m_269323_() != null && ta.m_21830_(owner)) {
            this.m_6710_(null);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!this.m_21824_() && itemstack.m_150930_(this.tameItem)) {
            this.m_142075_(player, hand, itemstack);
            if (!this.m_9236_().f_46443_) {
                if (this.f_19796_.m_188503_(5) == 0) {
                    this.m_21828_(player);
                    this.behavior = Behavior.FOLLOW;
                    this.onTamed(player);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
                this.m_21530_();
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)player) && !itemstack.m_150930_(this.breedItem)) {
            if (!this.m_9236_().f_46443_) {
                this.cycleBehavior(player);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    private void setBehaviorInPersistentData() {
        this.getPersistentData().m_128359_("Behavior", this.behavior.name());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Behavior", this.behavior.name());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Behavior")) {
            this.behavior = Behavior.valueOf(compound.m_128461_("Behavior"));
        }
    }

    public boolean isFollowing() {
        return this.behavior == Behavior.FOLLOW;
    }

    public boolean isWandering() {
        return this.behavior == Behavior.WANDER;
    }

    public boolean isStaying() {
        return this.behavior == Behavior.STAY;
    }

    private void cycleBehavior(Player player) {
        this.behavior = switch (this.behavior) {
            default -> throw new IncompatibleClassChangeError();
            case Behavior.FOLLOW -> Behavior.WANDER;
            case Behavior.WANDER -> Behavior.STAY;
            case Behavior.STAY -> Behavior.FOLLOW;
        };
        player.m_5661_((Component)Component.m_237113_((String)(this.getEntityName() + " will " + this.behavior.name().toLowerCase())), true);
        this.setBehaviorInPersistentData();
        this.onBehaviorChanged(this.behavior);
    }

    protected void onTamed(Player owner) {
    }

    protected void onBehaviorChanged(Behavior newBehavior) {
    }

    public String getEntityName() {
        if (this.m_8077_()) {
            return this.m_7770_().getString();
        }
        return this.m_6095_().m_20676_().getString();
    }

    public static enum Behavior {
        FOLLOW,
        WANDER,
        STAY;

    }
}

