/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.floral_tonics_and_tinctures.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import net.trashelemental.floral_tonics_and_tinctures.block.ModBlocks;
import net.trashelemental.floral_tonics_and_tinctures.magic.brewing.ModPotions;
import net.trashelemental.floral_tonics_and_tinctures.magic.effects.ModMobEffects;

public class TonicRecipeProvider
implements DataProvider {
    private final PackOutput output;
    private final String modid;
    public static int veryShortDuration = 400;
    public static int shortDuration = 900;
    public static int mediumDuration = 1800;
    public static int longDuration = 3600;

    public TonicRecipeProvider(PackOutput output, String modid) {
        this.output = output;
        this.modid = modid;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        CompletableFuture[] tasks = new CompletableFuture[]{this.saveRecipe(cache, "invisibility", this.tonicFromPositivePotion(Items.f_42209_, Potions.f_43605_)), this.saveRecipe(cache, "leaping", this.tonicFromPositivePotion(Items.f_41949_, Potions.f_43607_)), this.saveRecipe(cache, "luck", this.tonicFromPositivePotion(Items.f_42208_, Potions.f_43595_)), this.saveRecipe(cache, "night_vision", this.tonicFromPositivePotion(Items.f_41940_, Potions.f_43603_)), this.saveRecipe(cache, "regeneration", this.tonicFromPositivePotion(Items.f_41948_, Potions.f_43587_)), this.saveRecipe(cache, "slow_falling", this.tonicFromPositivePotion(Items.f_42207_, Potions.f_43596_)), this.saveRecipe(cache, "strength", this.tonicFromPositivePotion(Items.f_41954_, Potions.f_43590_)), this.saveRecipe(cache, "swiftness", this.tonicFromPositivePotion(Items.f_41939_, Potions.f_43612_)), this.saveRecipe(cache, "water_breathing", this.tonicFromPositivePotion(Items.f_42094_, Potions.f_43621_)), this.saveRecipe(cache, "fire_resistance", this.tonicFromPositivePotion(Items.f_41942_, Potions.f_43610_)), this.saveRecipe(cache, "dolphins_grace", this.tonicFromPositivePotion(Items.f_41868_, (Potion)ModPotions.DOLPHINS_GRACE_POTION.get())), this.saveRecipe(cache, "glowing", this.tonicFromPositivePotion(Items.f_151079_, (Potion)ModPotions.GLOWING_POTION.get())), this.saveRecipe(cache, "haste", this.tonicFromPositivePotion(Items.f_42206_, (Potion)ModPotions.HASTE_POTION.get())), this.saveRecipe(cache, "slowness", this.tonicFromNegativePotion(Items.f_41941_, Potions.f_43615_)), this.saveRecipe(cache, "poison", this.tonicFromNegativePotion(Items.f_41950_, Potions.f_43584_)), this.saveRecipe(cache, "blindness", this.tonicFromNegativePotion(Items.f_41943_, (Potion)ModPotions.BLINDNESS_POTION.get())), this.saveRecipe(cache, "wither", this.tonicFromNegativePotion(Items.f_41951_, (Potion)ModPotions.WITHER_POTION.get())), this.saveRecipe(cache, "levitation", this.tonicFromNegativePotion(Items.f_42003_, (Potion)ModPotions.LEVITATION_POTION.get())), this.saveRecipe(cache, "nausea", this.tonicFromNegativePotion(Items.f_41955_, (Potion)ModPotions.NAUSEA_POTION.get())), this.saveRecipe(cache, "weakness_orange", this.tonicFromNegativePotion(Items.f_41945_, Potions.f_43593_)), this.saveRecipe(cache, "weakness_pink", this.tonicFromNegativePotion(Items.f_41947_, Potions.f_43593_)), this.saveRecipe(cache, "weakness_white", this.tonicFromNegativePotion(Items.f_41946_, Potions.f_43593_)), this.saveRecipe(cache, "weakness_red", this.tonicFromNegativePotion(Items.f_41944_, Potions.f_43593_)), this.saveRecipe(cache, "prickly", this.tonicFromPositiveEffect(Items.f_41982_, (MobEffect)ModMobEffects.PRICKLY.get(), longDuration)), this.saveRecipe(cache, "purifying", this.tonicFromPositiveEffect(((Block)ModBlocks.MILKWEED.get()).m_5456_(), (MobEffect)ModMobEffects.PURIFYING.get(), longDuration)), this.saveRecipe(cache, "fiery", this.tonicFromPositiveEffect(((Block)ModBlocks.FIRE_LILY.get()).m_5456_(), (MobEffect)ModMobEffects.FIERY.get(), mediumDuration)), this.saveRecipe(cache, "frosty", this.tonicFromPositiveEffect(((Block)ModBlocks.HEATHER.get()).m_5456_(), (MobEffect)ModMobEffects.FROSTY.get(), mediumDuration)), this.saveRecipe(cache, "gold_rush", this.tonicFromPositiveEffect(((Block)ModBlocks.MIDAS_FINGERS.get()).m_5456_(), (MobEffect)ModMobEffects.GOLD_RUSH.get(), longDuration)), this.saveRecipe(cache, "magic_resistance", this.tonicFromPositiveEffect(((Block)ModBlocks.MOLY.get()).m_5456_(), (MobEffect)ModMobEffects.MAGIC_RESISTANCE.get(), longDuration)), this.saveRecipe(cache, "volatility", this.tonicFromNegativeEffect(((Block)ModBlocks.LAVADROP.get()).m_5456_(), (MobEffect)ModMobEffects.VOLATILITY.get(), veryShortDuration)), this.saveRecipe(cache, "resistance", this.tonicFromPositiveEffect(((Block)ModBlocks.STELLA.get()).m_5456_(), MobEffects.f_19606_, mediumDuration)), this.saveRecipe(cache, "floral_scent", this.tonicFromPositiveEffect(Blocks.f_271445_.m_5456_(), (MobEffect)ModMobEffects.FLORAL_SCENT.get(), longDuration)), this.saveRecipe(cache, "wayfaring", this.tonicFromPositiveEffect(((Block)ModBlocks.CLOVER_PATCH.get()).m_5456_(), (MobEffect)ModMobEffects.WAYFARING.get(), longDuration)), this.saveRecipe(cache, "paralyzed", this.moddedNegativeTonic("the_bumblezone", "pollen_puff", "paralyzed", shortDuration)), this.saveRecipe(cache, "protection_of_the_hive", this.moddedPositiveTonic("the_bumblezone", "pollen_puff", "protection_of_the_hive", longDuration)), this.saveRecipe(cache, "protection_of_the_hive", this.moddedPositiveTonic("the_bumblezone", "pollen_puff", "protection_of_the_hive", longDuration)), this.saveRecipe(cache, "protection_of_the_hive", this.moddedPositiveTonic("the_bumblezone", "pollen_puff", "protection_of_the_hive", longDuration)), this.saveRecipe(cache, "agility", this.moddedPositiveTonic("neapolitan", "banana", "agility", longDuration)), this.saveRecipe(cache, "berserking", this.moddedPositiveTonic("neapolitan", "mint_leaves", "berserking", longDuration)), this.saveRecipe(cache, "harmony", this.moddedPositiveTonic("neapolitan", "adzuki_beans", "harmony", longDuration)), this.saveRecipe(cache, "vanilla_scent", this.moddedPositiveTonic("neapolitan", "vanilla_pods", "vanilla_scent", longDuration)), this.saveRecipe(cache, "healing_touch", this.moddedPositiveTonic("brewery", "dried_corn", "healingtouch", mediumDuration)), this.saveRecipe(cache, "toxic_touch", this.moddedNegativeTonic("brewery", "dried_barley", "toxictouch", mediumDuration)), this.saveRecipe(cache, "pint_charisma", this.moddedPositiveTonic("brewery", "dried_barley", "pintcharisma", longDuration)), this.saveRecipe(cache, "pacify", this.moddedPositiveTonic("brewery", "hops", "pacify", longDuration)), this.saveRecipe(cache, "explosions", this.moddedNegativeTonic("brewery", "dried_corn", "explosion", mediumDuration)), this.saveRecipe(cache, "combustion", this.moddedNegativeTonic("brewery", "dried_oat", "combustion", mediumDuration)), this.saveRecipe(cache, "protective_touch", this.moddedPositiveTonic("brewery", "dried_oat", "protectivetouch", mediumDuration)), this.saveRecipe(cache, "party_starter", this.moddedNegativeTonic("brewery", "hops", "partystarter", mediumDuration)), this.saveRecipe(cache, "renewing_touch", this.moddedPositiveTonic("brewery", "dried_wheat", "renewingtouch", longDuration)), this.saveRecipe(cache, "bug_pheromones", this.moddedPositiveTonic("alexsmobs", "gongylidia", "bug_pheromones", longDuration)), this.saveRecipe(cache, "knockback_resistance", this.moddedPositiveTonic("alexsmobs", "acacia_blossom", "knockback_resistance", longDuration)), this.saveRecipe(cache, "deepsight", this.moddedPositiveTonic("alexscaves", "ping_pong_sponge", "deepsight", longDuration)), this.saveRecipe(cache, "rage", this.moddedPositiveTonic("alexscaves", "tree_star", "rage", veryShortDuration)), this.saveRecipe(cache, "sugar_rush", this.moddedPositiveTonic("alexscaves", "lollipop_bunch", "sugar_rush", veryShortDuration)), this.saveRecipe(cache, "rampage", this.moddedPositiveTonic("born_in_chaos_v1", "marigolds", "rampant_rampage", veryShortDuration)), this.saveRecipe(cache, "intoxication", this.moddedNegativeTonic("born_in_chaos_v1", "marigolds", "intoxication", veryShortDuration)), this.saveRecipe(cache, "ice_barrier", this.moddedPositiveTonic("born_in_chaos_v1", "river_mint", "ice_barrier", longDuration)), this.saveRecipe(cache, "stimulation", this.moddedNegativeTonic("born_in_chaos_v1", "river_mint", "stimulation", veryShortDuration)), this.saveRecipe(cache, "mana_regen", this.moddedPositiveTonic("ars_nouveau", "sourceberry_bush", "mana_regen", longDuration)), this.saveRecipe(cache, "spell_damage", this.moddedPositiveTonic("ars_nouveau", "magebloom", "spell_damage", longDuration)), this.saveRecipe(cache, "blasting", this.moddedPositiveTonic("ars_nouveau", "bombegranate_pod", "blasting", mediumDuration)), this.saveRecipe(cache, "shielding", this.moddedPositiveTonic("ars_nouveau", "bastion_pod", "shielding", mediumDuration)), this.saveRecipe(cache, "freezing", this.moddedPositiveTonic("ars_nouveau", "frostaya_pod", "freezing", mediumDuration)), this.saveRecipe(cache, "recovery", this.moddedPositiveTonic("ars_nouveau", "mendosteen_pod", "recovery", mediumDuration)), this.saveRecipe(cache, "repellence", this.moddedPositiveTonic("upgrade_aquatic", "pickerelweed", "repellence", longDuration)), this.saveRecipe(cache, "vibing", this.moddedNegativeTonic("upgrade_aquatic", "pickerelweed", "vibing", longDuration)), this.saveRecipe(cache, "sunscreen", this.moddedPositiveTonic("vampirism", "vampire_orchid", "sunscreen", longDuration)), this.saveRecipe(cache, "third_eye", this.moddedPositiveTonic("occultism", "datura", "third_eye", longDuration)), this.saveRecipe(cache, "bonding", this.moddedPositiveTonic("herbalbrews", "hibiscus", "bonding", longDuration)), this.saveRecipe(cache, "lifeleech", this.moddedNegativeTonic("herbalbrews", "hibiscus", "lifeleech", mediumDuration)), this.saveRecipe(cache, "tough", this.moddedPositiveTonic("herbalbrews", "lavender", "tough", longDuration)), this.saveRecipe(cache, "feral", this.moddedNegativeTonic("herbalbrews", "lavender", "feral", mediumDuration)), this.saveRecipe(cache, "arachnid_grace", this.moddedPositiveTonic("hexalia", "dahlia", "arachnid_grace", mediumDuration)), this.saveRecipe(cache, "bloodlust", this.moddedPositiveTonic("hexalia", "witchweed", "bloodlust", shortDuration)), this.saveRecipe(cache, "daybloom", this.moddedPositiveTonic("hexalia", "begonia", "daybloom", longDuration)), this.saveRecipe(cache, "siphon", this.moddedPositiveTonic("hexalia", "ghost_fern", "siphon", shortDuration)), this.saveRecipe(cache, "slimewalker", this.moddedPositiveTonic("hexalia", "lotus_flower", "slimewalker", mediumDuration)), this.saveRecipe(cache, "spikeskin", this.moddedPositiveTonic("hexalia", "mandrake", "spikeskin", mediumDuration)), this.saveRecipe(cache, "disease_resistance", this.moddedPositiveTonic("warriorsofpastepoch", "cistus", "disease_resistance", longDuration)), this.saveRecipe(cache, "morbidity", this.moddedNegativeTonic("warriorsofpastepoch", "cistus", "morbidity", shortDuration)), this.saveRecipe(cache, "allure", this.moddedPositiveTonic("botania", "blue_mystical_flower", "allure", mediumDuration)), this.saveRecipe(cache, "bloodthirst", this.moddedNegativeTonic("botania", "red_mystical_flower", "bloodthirst", shortDuration)), this.saveRecipe(cache, "emptiness", this.moddedPositiveTonic("botania", "black_mystical_flower", "emptiness", shortDuration)), this.saveRecipe(cache, "feather_feet", this.moddedPositiveTonic("botania", "light_blue_mystical_flower", "feather_feet", mediumDuration)), this.saveRecipe(cache, "soul_cross", this.moddedPositiveTonic("botania", "light_gray_mystical_flower", "soul_cross", mediumDuration))};
        return CompletableFuture.allOf(tasks);
    }

    public JsonObject tonicFromPositivePotion(Item ingredient, Potion potion) {
        return this.basePotionRecipe(Items.f_42501_, ingredient, Items.f_42590_, potion);
    }

    public JsonObject tonicFromNegativePotion(Item ingredient, Potion potion) {
        return this.basePotionRecipe(Items.f_42591_, ingredient, Items.f_42590_, potion);
    }

    public JsonObject tonicFromPositiveEffect(Item ingredient, MobEffect effect, int duration) {
        return this.baseEffectRecipe(Items.f_42501_, ingredient, Items.f_42590_, effect, duration);
    }

    public JsonObject tonicFromNegativeEffect(Item ingredient, MobEffect effect, int duration) {
        return this.baseEffectRecipe(Items.f_42591_, ingredient, Items.f_42590_, effect, duration);
    }

    public JsonObject moddedPositiveTonic(String modNamespace, String ingredientName, String effectName, int duration) {
        ResourceLocation additive = new ResourceLocation("minecraft", "sugar");
        ResourceLocation ingredient = new ResourceLocation(modNamespace, ingredientName);
        ResourceLocation bottle = new ResourceLocation("minecraft", "glass_bottle");
        ResourceLocation effect = new ResourceLocation(modNamespace, effectName);
        return this.baseModdedEffectRecipe(additive, ingredient, bottle, effect, duration);
    }

    public JsonObject moddedNegativeTonic(String modNamespace, String ingredientName, String effectName, int duration) {
        ResourceLocation additive = new ResourceLocation("minecraft", "spider_eye");
        ResourceLocation ingredient = new ResourceLocation(modNamespace, ingredientName);
        ResourceLocation bottle = new ResourceLocation("minecraft", "glass_bottle");
        ResourceLocation effect = new ResourceLocation(modNamespace, effectName);
        return this.baseModdedEffectRecipe(additive, ingredient, bottle, effect, duration);
    }

    private JsonObject basePotionRecipe(Item additive, Item ingredient, Item bottle, Potion potion) {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.modid + ":herbalism");
        json.add("additive", (JsonElement)this.item(additive));
        json.add("ingredient", (JsonElement)this.item(ingredient));
        json.add("bottle", (JsonElement)this.item(bottle));
        JsonObject result = new JsonObject();
        result.addProperty("item", this.modid + ":tonic");
        result.addProperty("count", (Number)1);
        result.addProperty("nbt", "{Potion:\"" + ForgeRegistries.POTIONS.getKey((Object)potion) + "\"}");
        json.add("result", (JsonElement)result);
        return json;
    }

    private JsonObject baseEffectRecipe(Item additive, Item ingredient, Item bottle, MobEffect effect, int duration) {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.modid + ":herbalism");
        json.add("additive", (JsonElement)this.item(additive));
        json.add("ingredient", (JsonElement)this.item(ingredient));
        json.add("bottle", (JsonElement)this.item(bottle));
        JsonObject result = new JsonObject();
        result.addProperty("item", this.modid + ":tonic");
        JsonArray effects = new JsonArray();
        JsonObject effectObj = new JsonObject();
        effectObj.addProperty("id", ForgeRegistries.MOB_EFFECTS.getKey((Object)effect).toString());
        effectObj.addProperty("duration", (Number)duration);
        effectObj.addProperty("amplifier", (Number)0);
        effectObj.addProperty("ambient", Boolean.valueOf(false));
        effectObj.addProperty("visible", Boolean.valueOf(true));
        effectObj.addProperty("show_icon", Boolean.valueOf(true));
        effects.add((JsonElement)effectObj);
        result.add("effects", (JsonElement)effects);
        json.add("result", (JsonElement)result);
        return json;
    }

    private JsonObject baseModdedEffectRecipe(ResourceLocation additive, ResourceLocation ingredient, ResourceLocation bottle, ResourceLocation effect, int duration) {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.modid + ":herbalism");
        json.add("additive", (JsonElement)this.item(additive));
        json.add("ingredient", (JsonElement)this.item(ingredient));
        json.add("bottle", (JsonElement)this.item(bottle));
        JsonObject result = new JsonObject();
        result.addProperty("item", this.modid + ":tonic");
        JsonArray effects = new JsonArray();
        JsonObject effectObj = new JsonObject();
        effectObj.addProperty("id", effect.toString());
        effectObj.addProperty("duration", (Number)duration);
        effectObj.addProperty("amplifier", (Number)0);
        effectObj.addProperty("ambient", Boolean.valueOf(false));
        effectObj.addProperty("visible", Boolean.valueOf(true));
        effectObj.addProperty("show_icon", Boolean.valueOf(true));
        effects.add((JsonElement)effectObj);
        result.add("effects", (JsonElement)effects);
        json.add("result", (JsonElement)result);
        return json;
    }

    private JsonObject item(Item item) {
        JsonObject obj = new JsonObject();
        obj.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)item).toString());
        return obj;
    }

    private JsonObject item(ResourceLocation id) {
        JsonObject obj = new JsonObject();
        obj.addProperty("item", id.toString());
        return obj;
    }

    private CompletableFuture<?> saveRecipe(CachedOutput cache, String name, JsonObject json) {
        Path path = this.output.m_245114_().resolve("data/" + this.modid + "/recipes/tonic_" + name + ".json");
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)path);
    }

    public String m_6055_() {
        return "Tonic Recipes: " + this.modid;
    }
}

