/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.floral_tonics_and_tinctures.magic.effects.event;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.trashelemental.floral_tonics_and_tinctures.magic.effects.ModMobEffects;

@Mod.EventBusSubscriber
public class FrostyEffectEvents {
    private static int minFreezeTicks = 300;
    private static int extraFreezeTicksPerLevel = 60;
    private static int maxFreezeTicks = 1000;
    private static final Map<LivingEntity, BlockPos> lastBlockPos = new WeakHashMap<LivingEntity, BlockPos>();

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent event) {
        int frostyLevel;
        LivingEntity entity;
        boolean targetHasEffect = false;
        boolean attackerHasEffect = false;
        LivingEntity target = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        MobEffect frosty = (MobEffect)ModMobEffects.FROSTY.get();
        if (attacker == null) {
            return;
        }
        if (target.m_9236_().f_46443_) {
            return;
        }
        if (target.m_21023_(frosty)) {
            targetHasEffect = true;
        }
        if (attacker instanceof LivingEntity && (entity = (LivingEntity)attacker).m_21023_(frosty)) {
            attackerHasEffect = true;
        }
        if (!targetHasEffect && !attackerHasEffect) {
            return;
        }
        if (targetHasEffect && attacker instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            frostyLevel = target.m_21124_(frosty).m_19564_();
            FrostyEffectEvents.applyFrost(livingAttacker, frostyLevel);
        }
        if (attackerHasEffect && attacker instanceof LivingEntity) {
            LivingEntity livingAttacker2 = (LivingEntity)attacker;
            frostyLevel = livingAttacker2.m_21124_(frosty).m_19564_();
            FrostyEffectEvents.applyFrost(target, frostyLevel);
        }
    }

    private static void applyFrost(LivingEntity entity, int frostyLevel) {
        int currentTicks = entity.m_146888_();
        int addedTicks = minFreezeTicks + extraFreezeTicksPerLevel * frostyLevel;
        if (currentTicks > 0) {
            addedTicks += extraFreezeTicksPerLevel;
        }
        entity.m_146917_(Math.min(currentTicks + addedTicks, maxFreezeTicks));
    }

    @SubscribeEvent
    public static void onMove(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (!entity.m_21023_((MobEffect)ModMobEffects.FROSTY.get())) {
            return;
        }
        if (!entity.m_20096_()) {
            return;
        }
        BlockPos currentPos = entity.m_20183_();
        BlockPos previousPos = lastBlockPos.get(entity);
        if (previousPos != null && previousPos.equals((Object)currentPos)) {
            return;
        }
        lastBlockPos.put(entity, currentPos);
        FrostyEffectEvents.freezeWater(entity);
    }

    public static void freezeWater(LivingEntity entity) {
        Level world = entity.m_9236_();
        BlockPos entityPos = entity.m_20183_();
        int radius = 5;
        BlockState iceBlock = Blocks.f_50449_.m_49966_();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                BlockPos above;
                BlockState state;
                mutablePos.m_122178_(entityPos.m_123341_() + dx, entityPos.m_123342_() - 1, entityPos.m_123343_() + dz);
                int ex = mutablePos.m_123341_() - entityPos.m_123341_();
                int ez = mutablePos.m_123343_() - entityPos.m_123343_();
                if (ex * ex + ez * ez > radius * radius || !(state = world.m_8055_((BlockPos)mutablePos)).m_60713_(Blocks.f_49990_) || state.m_60819_().m_76186_() != 8 || !world.m_8055_(above = mutablePos.m_7494_()).m_60795_()) continue;
                world.m_7731_((BlockPos)mutablePos, iceBlock, 3);
                world.m_186460_((BlockPos)mutablePos, Blocks.f_50449_, 60 + entity.m_217043_().m_188503_(61));
            }
        }
    }
}

