/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.floral_tonics_and_tinctures.menu.custom;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.trashelemental.floral_tonics_and_tinctures.block.ModBlocks;
import net.trashelemental.floral_tonics_and_tinctures.item.ModItems;
import net.trashelemental.floral_tonics_and_tinctures.menu.ModMenuTypes;
import net.trashelemental.floral_tonics_and_tinctures.util.recipe.ModRecipeTypes;

public class HerbalismTableMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final ItemStackHandler handler;

    public HerbalismTableMenu(int id, Inventory playerInv, final ContainerLevelAccess access) {
        super((MenuType)ModMenuTypes.HERBALISM_TABLE.get(), id);
        this.access = access;
        this.handler = new ItemStackHandler(4){

            protected void onContentsChanged(int slot) {
                if (slot == 3) {
                    return;
                }
                access.m_39292_((level, pos) -> HerbalismTableMenu.this.updateOutput((Level)level));
            }
        };
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.handler, 0, 8, 26){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_(Items.f_42501_) || stack.m_150930_(Items.f_42591_);
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.handler, 1, 32, 26){

            public boolean m_5857_(ItemStack stack) {
                return !stack.m_150930_((Item)ModItems.HERBALISM_KIT.get());
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.handler, 2, 20, 50){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_(Items.f_42590_);
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.handler, 3, 140, 37){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                for (int i = 0; i < 3; ++i) {
                    ItemStack input = HerbalismTableMenu.this.handler.getStackInSlot(i);
                    if (input.m_41619_()) continue;
                    input.m_41774_(1);
                    HerbalismTableMenu.this.handler.setStackInSlot(i, input);
                }
                access.m_39292_((level, pos) -> {
                    HerbalismTableMenu.this.updateOutput((Level)level);
                    if (!level.m_5776_()) {
                        level.m_5594_(null, pos, SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 1.5f);
                    }
                });
                super.m_142406_(player, stack);
            }
        });
        this.addPlayerInventory(playerInv);
    }

    private void addPlayerInventory(Inventory inv) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)inv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)inv, col, 8 + col * 18, 142));
        }
    }

    private void updateOutput(Level level) {
        if (level.f_46443_) {
            return;
        }
        SimpleContainer input = new SimpleContainer(this.handler.getSlots());
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            input.m_6836_(i, this.handler.getStackInSlot(i));
        }
        level.m_7465_().m_44013_((RecipeType)ModRecipeTypes.HERBALISM.get()).stream().filter(recipe -> recipe.matches(input, level)).findFirst().ifPresentOrElse(recipe -> this.handler.setStackInSlot(3, recipe.assemble(input, level.m_9598_())), () -> this.handler.setStackInSlot(3, ItemStack.f_41583_));
    }

    public boolean m_6875_(Player player) {
        return HerbalismTableMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ModBlocks.HERBALISM_TABLE.get()));
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack result = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            result = stackInSlot.m_41777_();
            if (index == 3) {
                if (!this.m_38903_(stackInSlot, 4, 40, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stackInSlot, result);
            } else if (index >= 0 && index <= 2 ? !this.m_38903_(stackInSlot, 4, 40, false) : index >= 4 && (stackInSlot.m_150930_(Items.f_42501_) || stackInSlot.m_150930_(Items.f_42591_) ? !this.m_38903_(stackInSlot, 0, 1, false) : (stackInSlot.m_150930_(Items.f_42590_) ? !this.m_38903_(stackInSlot, 2, 3, false) : !this.m_38903_(stackInSlot, 1, 2, false)))) {
                return ItemStack.f_41583_;
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stackInSlot.m_41613_() == result.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stackInSlot);
        }
        return result;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!player.m_9236_().f_46443_) {
            for (int i = 0; i < 3; ++i) {
                ItemStack stack = this.handler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                if (!player.m_150109_().m_36054_(stack)) {
                    player.m_36176_(stack, false);
                }
                this.handler.setStackInSlot(i, ItemStack.f_41583_);
            }
        }
    }
}

