/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.floral_tonics_and_tinctures.menu.custom.herbalism_kit;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.trashelemental.floral_tonics_and_tinctures.item.ModItems;
import net.trashelemental.floral_tonics_and_tinctures.menu.ModMenuTypes;
import net.trashelemental.floral_tonics_and_tinctures.util.ModTags;
import net.trashelemental.floral_tonics_and_tinctures.util.recipe.ModRecipeTypes;

public class HerbalismKitMenu
extends AbstractContainerMenu
implements Supplier<Map<Integer, Slot>> {
    private final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    private final Player player;
    private final Level level;
    private final ItemStackHandler internal = new ItemStackHandler(22){

        protected void onContentsChanged(int slot) {
            if (slot >= 0 && slot <= 2) {
                HerbalismKitMenu.this.updateOutput();
            }
        }
    };
    private final ItemStack bagStack;

    public HerbalismKitMenu(int id, Inventory inv, FriendlyByteBuf buf) {
        this(id, inv, buf.m_130267_());
    }

    public HerbalismKitMenu(int id, Inventory inv, ItemStack stack) {
        super((MenuType)ModMenuTypes.HERBALISM_KIT.get(), id);
        this.player = inv.f_35978_;
        this.level = inv.f_35978_.m_9236_();
        this.bagStack = stack;
        if (this.bagStack.m_41782_() && this.bagStack.m_41783_().m_128441_("Inventory")) {
            this.internal.deserializeNBT(this.bagStack.m_41783_().m_128469_("Inventory"));
        }
        this.customSlots.put(0, this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.internal, 0, 17, 66){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_(Items.f_42501_) || stack.m_150930_(Items.f_42591_);
            }
        }));
        this.customSlots.put(1, this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.internal, 1, 35, 66){

            public boolean m_5857_(ItemStack stack) {
                return !stack.m_150930_((Item)ModItems.HERBALISM_KIT.get());
            }
        }));
        this.customSlots.put(2, this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.internal, 2, 26, 84){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_(Items.f_42590_);
            }
        }));
        this.customSlots.put(3, this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.internal, 3, 135, 76){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                for (int i = 0; i < 3; ++i) {
                    ItemStack input = HerbalismKitMenu.this.internal.getStackInSlot(i);
                    if (input.m_41619_()) continue;
                    input.m_41774_(1);
                    HerbalismKitMenu.this.internal.setStackInSlot(i, input);
                }
                HerbalismKitMenu.this.updateOutput();
                if (!HerbalismKitMenu.this.level.m_5776_()) {
                    HerbalismKitMenu.this.level.m_5594_(null, player.m_20183_(), SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 1.5f);
                }
                super.m_142406_(player, stack);
            }
        }));
        int[][] positions = new int[][]{{8, 21}, {26, 21}, {44, 21}, {62, 21}, {80, 21}, {98, 21}, {116, 21}, {134, 21}, {152, 21}, {8, 39}, {26, 39}, {44, 39}, {62, 39}, {80, 39}, {98, 39}, {116, 39}, {134, 39}, {152, 39}};
        for (int i = 0; i < positions.length; ++i) {
            int index = i + 4;
            int x = positions[i][0];
            int y = positions[i][1];
            this.addStorageSlot(index, x, y, this.internal);
        }
        int startX = 9;
        int startY = 113;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)inv, col + row * 9 + 9, startX + col * 18, startY + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)inv, col, startX + col * 18, startY + 58));
        }
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack movedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            movedStack = slotStack.m_41777_();
            int kitStart = 0;
            int kitEnd = 21;
            int invStart = 22;
            int invEnd = this.f_38839_.size() - 1;
            if (index >= kitStart && index <= kitEnd ? !this.m_38903_(slotStack, invStart, invEnd + 1, true) : !this.m_38903_(slotStack, kitStart, kitEnd + 1, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == movedStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return movedStack;
    }

    @Override
    public Map<Integer, Slot> get() {
        return this.customSlots;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        CompoundTag tag = this.bagStack.m_41784_();
        tag.m_128365_("Inventory", (Tag)this.internal.serializeNBT());
        player.m_5496_(SoundEvents.f_11678_, 1.0f, 1.5f);
    }

    private Slot addStorageSlot(int index, int x, int y, ItemStackHandler handler) {
        Slot slot = this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, index, x, y){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_204117_(ModTags.Items.HERBALISM_GUI_ALLOWED);
            }
        });
        this.customSlots.put(index, slot);
        return slot;
    }

    private void updateOutput() {
        if (this.level.f_46443_) {
            return;
        }
        SimpleContainer input = new SimpleContainer(3);
        for (int i = 0; i < 3; ++i) {
            input.m_6836_(i, this.internal.getStackInSlot(i));
        }
        this.level.m_7465_().m_44013_((RecipeType)ModRecipeTypes.HERBALISM.get()).stream().filter(recipe -> recipe.matches(input, this.level)).findFirst().ifPresentOrElse(recipe -> this.internal.setStackInSlot(3, recipe.assemble(input, this.level.m_9598_())), () -> this.internal.setStackInSlot(3, ItemStack.f_41583_));
    }
}

