/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.floral_tonics_and_tinctures.util.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.trashelemental.floral_tonics_and_tinctures.item.custom.TonicItem;
import net.trashelemental.floral_tonics_and_tinctures.util.recipe.ModRecipeTypes;
import net.trashelemental.floral_tonics_and_tinctures.util.recipe.ModRecipes;

public class HerbalismRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack result;
    private final List<MobEffectInstance> customEffects;

    public HerbalismRecipe(ResourceLocation id, NonNullList<Ingredient> ingredients, ItemStack result, List<MobEffectInstance> customEffects) {
        this.id = id;
        this.ingredients = ingredients;
        this.result = result;
        this.customEffects = customEffects;
    }

    public boolean matches(SimpleContainer container, Level level) {
        if (level.m_5776_()) {
            return false;
        }
        if (this.ingredients.size() != 3) {
            return false;
        }
        return ((Ingredient)this.ingredients.get(0)).test(container.m_8020_(0)) && ((Ingredient)this.ingredients.get(1)).test(container.m_8020_(1)) && ((Ingredient)this.ingredients.get(2)).test(container.m_8020_(2));
    }

    public ItemStack assemble(SimpleContainer container, RegistryAccess registryAccess) {
        ItemStack output = this.result.m_41777_();
        if (output.m_41720_() instanceof TonicItem && !this.customEffects.isEmpty()) {
            PotionUtils.m_43552_((ItemStack)output, this.customEffects);
        }
        return output;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        ItemStack output = this.result.m_41777_();
        if (output.m_41720_() instanceof TonicItem && !this.customEffects.isEmpty()) {
            PotionUtils.m_43552_((ItemStack)output, this.customEffects);
        }
        return output;
    }

    public ItemStack getResultItem() {
        ItemStack output = this.result.m_41777_();
        if (output.m_41720_() instanceof TonicItem && !this.customEffects.isEmpty()) {
            PotionUtils.m_43552_((ItemStack)output, this.customEffects);
        }
        return output;
    }

    public boolean m_8004_(int w, int h) {
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.HERBALISM.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.HERBALISM.get();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public static class Serializer
    implements RecipeSerializer<HerbalismRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public HerbalismRecipe fromJson(ResourceLocation id, JsonObject json) {
            NonNullList ingredients = NonNullList.m_122780_((int)3, (Object)Ingredient.f_43901_);
            ingredients.set(0, (Object)Ingredient.m_43917_((JsonElement)json.getAsJsonObject("additive")));
            ingredients.set(1, (Object)Ingredient.m_43917_((JsonElement)json.getAsJsonObject("ingredient")));
            ingredients.set(2, (Object)Ingredient.m_43917_((JsonElement)json.getAsJsonObject("bottle")));
            JsonObject resultObj = json.getAsJsonObject("result");
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)resultObj);
            ArrayList<MobEffectInstance> customEffects = new ArrayList<MobEffectInstance>();
            if (resultObj.has("effects")) {
                JsonArray arr = GsonHelper.m_13933_((JsonObject)resultObj, (String)"effects");
                for (JsonElement el : arr) {
                    JsonObject effectObj = el.getAsJsonObject();
                    ResourceLocation effectId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)effectObj, (String)"id"));
                    MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(effectId);
                    if (effect == null) continue;
                    int duration = GsonHelper.m_13824_((JsonObject)effectObj, (String)"duration", (int)200);
                    int amplifier = GsonHelper.m_13824_((JsonObject)effectObj, (String)"amplifier", (int)0);
                    boolean ambient = GsonHelper.m_13855_((JsonObject)effectObj, (String)"ambient", (boolean)false);
                    boolean visible = GsonHelper.m_13855_((JsonObject)effectObj, (String)"visible", (boolean)true);
                    boolean showIcon = GsonHelper.m_13855_((JsonObject)effectObj, (String)"show_icon", (boolean)true);
                    customEffects.add(new MobEffectInstance(effect, duration, amplifier, ambient, visible, showIcon));
                }
            }
            return new HerbalismRecipe(id, (NonNullList<Ingredient>)ingredients, result, customEffects);
        }

        @Nullable
        public HerbalismRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList ingredients = NonNullList.m_122780_((int)3, (Object)Ingredient.f_43901_);
            for (int i = 0; i < 3; ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack result = buf.m_130267_();
            int size = buf.m_130242_();
            ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
            for (int i = 0; i < size; ++i) {
                ResourceLocation effectId = buf.m_130281_();
                int duration = buf.m_130242_();
                int amplifier = buf.m_130242_();
                boolean ambient = buf.readBoolean();
                boolean visible = buf.readBoolean();
                boolean showIcon = buf.readBoolean();
                MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(effectId);
                if (effect == null) continue;
                effects.add(new MobEffectInstance(effect, duration, amplifier, ambient, visible, showIcon));
            }
            return new HerbalismRecipe(id, (NonNullList<Ingredient>)ingredients, result, effects);
        }

        public void toNetwork(FriendlyByteBuf buf, HerbalismRecipe recipe) {
            for (Ingredient ing : recipe.m_7527_()) {
                ing.m_43923_(buf);
            }
            buf.m_130055_(recipe.result);
            buf.m_130130_(recipe.customEffects.size());
            for (MobEffectInstance inst : recipe.customEffects) {
                buf.m_130085_(BuiltInRegistries.f_256974_.m_7981_((Object)inst.m_19544_()));
                buf.m_130130_(inst.m_19557_());
                buf.m_130130_(inst.m_19564_());
                buf.writeBoolean(inst.m_19571_());
                buf.writeBoolean(inst.m_19572_());
                buf.writeBoolean(inst.m_19575_());
            }
        }
    }
}

