/*
 * Decompiled with CFR 0.152.
 */
package nl.chimpgamer.ultimatemobcoins.paper.hooks;

import dev.rosewood.rosestacker.api.RoseStackerAPI;
import dev.rosewood.rosestacker.config.SettingKey;
import dev.rosewood.rosestacker.event.EntityStackMultipleDeathEvent;
import dev.rosewood.rosestacker.stack.StackedEntity;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import nl.chimpgamer.ultimatemobcoins.libs.mccoroutine.folia.MCCoroutineKt;
import nl.chimpgamer.ultimatemobcoins.paper.UltimateMobCoinsPlugin;
import nl.chimpgamer.ultimatemobcoins.paper.extensions.PluginExtKt;
import nl.chimpgamer.ultimatemobcoins.paper.hooks.PluginHook;
import nl.chimpgamer.ultimatemobcoins.paper.listeners.RoseStackerListener;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnl/chimpgamer/ultimatemobcoins/paper/hooks/RoseStackerHook;", "Lnl/chimpgamer/ultimatemobcoins/paper/hooks/PluginHook;", "plugin", "Lnl/chimpgamer/ultimatemobcoins/paper/UltimateMobCoinsPlugin;", "<init>", "(Lnl/chimpgamer/ultimatemobcoins/paper/UltimateMobCoinsPlugin;)V", "roseStackerListener", "Lnl/chimpgamer/ultimatemobcoins/paper/listeners/RoseStackerListener;", "load", "", "unload", "isEntityStacked", "", "livingEntity", "Lorg/bukkit/entity/LivingEntity;", "areMultipleEntitiesDying", "event", "Lorg/bukkit/event/entity/EntityDeathEvent;", "shouldIgnoreNormalDeathEvent", "entity", "paper"})
public final class RoseStackerHook
extends PluginHook {
    private RoseStackerListener roseStackerListener;

    public RoseStackerHook(@NotNull UltimateMobCoinsPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        super(plugin, "RoseStacker");
    }

    @Override
    public void load() {
        if (!this.isLoaded() && this.canHook()) {
            this.roseStackerListener = new RoseStackerListener(this.getPlugin());
            Plugin plugin = this.getPlugin();
            Listener[] listenerArray = new Listener[1];
            RoseStackerListener roseStackerListener = this.roseStackerListener;
            if (roseStackerListener == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"roseStackerListener");
                roseStackerListener = null;
            }
            listenerArray[0] = roseStackerListener;
            PluginExtKt.registerSuspendingEvents(plugin, listenerArray, MapsKt.mapOf((Pair)new Pair(EntityStackMultipleDeathEvent.class, arg_0 -> RoseStackerHook.load$lambda$0(this, arg_0))));
            this.setLoaded(true);
            this.getPlugin().getLogger().info("Successfully loaded " + this.getPluginName() + " hook!");
        }
    }

    @Override
    public void unload() {
        if (!this.isLoaded()) {
            return;
        }
        RoseStackerListener roseStackerListener = this.roseStackerListener;
        if (roseStackerListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"roseStackerListener");
            roseStackerListener = null;
        }
        HandlerList.unregisterAll((Listener)roseStackerListener);
    }

    public final boolean isEntityStacked(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        if (!this.isLoaded()) {
            return true;
        }
        return RoseStackerAPI.getInstance().isEntityStacked(livingEntity);
    }

    public final boolean areMultipleEntitiesDying(@NotNull EntityDeathEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isLoaded()) {
            return false;
        }
        StackedEntity stackedEntity = RoseStackerAPI.getInstance().getStackedEntity(event.getEntity());
        if (stackedEntity == null) {
            return false;
        }
        StackedEntity stackedEntity2 = stackedEntity;
        return stackedEntity2.areMultipleEntitiesDying(event);
    }

    public final boolean shouldIgnoreNormalDeathEvent(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!this.isLoaded()) {
            return false;
        }
        RoseStackerAPI roseStackerAPI = RoseStackerAPI.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)roseStackerAPI, (String)"getInstance(...)");
        RoseStackerAPI api = roseStackerAPI;
        StackedEntity stackedEntity = api.getStackedEntity(entity);
        if (!api.isEntityStackMultipleDeathEventCalled() || stackedEntity == null || stackedEntity.getStackSize() == 1) {
            return false;
        }
        if (stackedEntity.isEntireStackKilledOnDeath()) {
            return true;
        }
        Player killer = entity.getKiller();
        if (!((Boolean)SettingKey.ENTITY_MULTIKILL_ENABLED.get()).booleanValue()) {
            return false;
        }
        if (!((Boolean)SettingKey.ENTITY_MULTIKILL_PLAYER_ONLY.get()).booleanValue() && killer == null) {
            return false;
        }
        if (!((Boolean)SettingKey.ENTITY_MULTIKILL_ENCHANTMENT_ENABLED.get()).booleanValue()) {
            return true;
        }
        if (killer == null) {
            return false;
        }
        NamespacedKey namespacedKey = NamespacedKey.fromString((String)((String)SettingKey.ENTITY_MULTIKILL_ENCHANTMENT_TYPE.get()));
        if (namespacedKey == null) {
            return false;
        }
        NamespacedKey enchantmentNamespacedKey = namespacedKey;
        Enchantment enchantment = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(enchantmentNamespacedKey);
        if (enchantment == null) {
            return false;
        }
        Enchantment enchantment2 = enchantment;
        return killer.getInventory().getItemInMainHand().getEnchantmentLevel(enchantment2) > 0;
    }

    private static final CoroutineContext load$lambda$0(RoseStackerHook this$0, Event it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!(it instanceof EntityStackMultipleDeathEvent)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Plugin plugin = this$0.getPlugin();
        LivingEntity livingEntity = ((EntityStackMultipleDeathEvent)it).getStack().getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getEntity(...)");
        return MCCoroutineKt.entityDispatcher(plugin, (Entity)livingEntity);
    }
}

