/*
 * Decompiled with CFR 0.152.
 */
package nl.chimpgamer.ultimatemobcoins.paper.hooks;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.DoubleFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import com.sk89q.worldguard.session.SessionManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nl.chimpgamer.ultimatemobcoins.paper.UltimateMobCoinsPlugin;
import nl.chimpgamer.ultimatemobcoins.paper.hooks.PluginHook;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lnl/chimpgamer/ultimatemobcoins/paper/hooks/WorldGuardHook;", "Lnl/chimpgamer/ultimatemobcoins/paper/hooks/PluginHook;", "plugin", "Lnl/chimpgamer/ultimatemobcoins/paper/UltimateMobCoinsPlugin;", "<init>", "(Lnl/chimpgamer/ultimatemobcoins/paper/UltimateMobCoinsPlugin;)V", "allowMobCoinsDropsFlag", "Lcom/sk89q/worldguard/protection/flags/StateFlag;", "multiplyMobCoinDropsFlag", "Lcom/sk89q/worldguard/protection/flags/DoubleFlag;", "multiplyMobCoinDropChanceFlag", "sessionManager", "Lcom/sk89q/worldguard/session/SessionManager;", "getSessionManager", "()Lcom/sk89q/worldguard/session/SessionManager;", "regionContainer", "Lcom/sk89q/worldguard/protection/regions/RegionContainer;", "getRegionContainer", "()Lcom/sk89q/worldguard/protection/regions/RegionContainer;", "load", "", "unload", "isMobCoinDropsAllowed", "", "player", "Lorg/bukkit/entity/Player;", "location", "Lorg/bukkit/Location;", "getMobCoinDropsMultiplier", "", "getMobCoinDropChanceMultiplier", "registerAllowMobCoinsDropsFlag", "flagRegistry", "Lcom/sk89q/worldguard/protection/flags/registry/FlagRegistry;", "registerMultiplyMobCoinsDropsFlag", "registerMultiplyMobCoinsDropChanceFlag", "paper"})
public final class WorldGuardHook
extends PluginHook {
    @NotNull
    private StateFlag allowMobCoinsDropsFlag;
    @NotNull
    private DoubleFlag multiplyMobCoinDropsFlag;
    @NotNull
    private DoubleFlag multiplyMobCoinDropChanceFlag;

    public WorldGuardHook(@NotNull UltimateMobCoinsPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        super(plugin, "WorldGuard");
        this.allowMobCoinsDropsFlag = new StateFlag("allow-mobcoin-drops", true);
        this.multiplyMobCoinDropsFlag = new DoubleFlag("multiply-mobcoin-drops");
        this.multiplyMobCoinDropChanceFlag = new DoubleFlag("multiply-mobcoin-drop-chance");
    }

    private final SessionManager getSessionManager() {
        SessionManager sessionManager = WorldGuard.getInstance().getPlatform().getSessionManager();
        Intrinsics.checkNotNullExpressionValue((Object)sessionManager, (String)"getSessionManager(...)");
        return sessionManager;
    }

    private final RegionContainer getRegionContainer() {
        RegionContainer regionContainer = WorldGuard.getInstance().getPlatform().getRegionContainer();
        Intrinsics.checkNotNullExpressionValue((Object)regionContainer, (String)"getRegionContainer(...)");
        return regionContainer;
    }

    @Override
    public void load() {
        if (!this.shouldHook()) {
            return;
        }
        if (!this.isPluginLoaded()) {
            return;
        }
        FlagRegistry flagRegistry = WorldGuard.getInstance().getFlagRegistry();
        Intrinsics.checkNotNull((Object)flagRegistry);
        this.registerAllowMobCoinsDropsFlag(flagRegistry);
        this.registerMultiplyMobCoinsDropsFlag(flagRegistry);
        this.registerMultiplyMobCoinsDropChanceFlag(flagRegistry);
        this.setLoaded(true);
        this.getPlugin().getLogger().info("Successfully loaded " + this.getPluginName() + " hook!");
    }

    @Override
    public void unload() {
        this.setLoaded(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMobCoinDropsAllowed(@NotNull Player player, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        if (!this.isLoaded()) {
            return true;
        }
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        RegionQuery regionQuery = this.getRegionContainer().createQuery();
        if (this.getSessionManager().hasBypass(localPlayer, localPlayer.getWorld())) return true;
        StateFlag[] stateFlagArray = new StateFlag[]{this.allowMobCoinsDropsFlag};
        if (!regionQuery.testState(BukkitAdapter.adapt((Location)location), localPlayer, stateFlagArray)) return false;
        return true;
    }

    public final double getMobCoinDropsMultiplier(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.isLoaded()) {
            return 0.0;
        }
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        RegionQuery regionQuery = this.getRegionContainer().createQuery();
        Double d = (Double)regionQuery.queryValue(BukkitAdapter.adapt((Location)player.getLocation()), localPlayer, (Flag)this.multiplyMobCoinDropsFlag);
        return d != null ? d : 0.0;
    }

    public final double getMobCoinDropChanceMultiplier(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.isLoaded()) {
            return 0.0;
        }
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        RegionQuery regionQuery = this.getRegionContainer().createQuery();
        Double d = (Double)regionQuery.queryValue(BukkitAdapter.adapt((Location)player.getLocation()), localPlayer, (Flag)this.multiplyMobCoinDropChanceFlag);
        return d != null ? d : 0.0;
    }

    private final void registerAllowMobCoinsDropsFlag(FlagRegistry flagRegistry) {
        block2: {
            try {
                flagRegistry.register((Flag)this.allowMobCoinsDropsFlag);
            }
            catch (FlagConflictException flagConflictException) {
                Flag existingFlag = flagRegistry.get("allow-mobcoin-drops");
                if (!(existingFlag instanceof StateFlag)) break block2;
                this.allowMobCoinsDropsFlag = (StateFlag)existingFlag;
            }
        }
    }

    private final void registerMultiplyMobCoinsDropsFlag(FlagRegistry flagRegistry) {
        block2: {
            try {
                flagRegistry.register((Flag)this.multiplyMobCoinDropsFlag);
            }
            catch (FlagConflictException flagConflictException) {
                Flag existingFlag = flagRegistry.get("multiply-mobcoin-drops");
                if (!(existingFlag instanceof DoubleFlag)) break block2;
                this.multiplyMobCoinDropsFlag = (DoubleFlag)existingFlag;
            }
        }
    }

    private final void registerMultiplyMobCoinsDropChanceFlag(FlagRegistry flagRegistry) {
        block2: {
            try {
                flagRegistry.register((Flag)this.multiplyMobCoinDropChanceFlag);
            }
            catch (FlagConflictException flagConflictException) {
                Flag existingFlag = flagRegistry.get("multiply-mobcoin-drop-chance");
                if (!(existingFlag instanceof DoubleFlag)) break block2;
                this.multiplyMobCoinDropsFlag = (DoubleFlag)existingFlag;
            }
        }
    }
}

