/*
 * Decompiled with CFR 0.152.
 */
package nl.chimpgamer.ultimatemobcoins.paper.managers;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nl.chimpgamer.ultimatemobcoins.paper.UltimateMobCoinsPlugin;
import nl.chimpgamer.ultimatemobcoins.paper.hooks.EcoMobsHook;
import nl.chimpgamer.ultimatemobcoins.paper.hooks.HeadDatabaseHook;
import nl.chimpgamer.ultimatemobcoins.paper.hooks.ItemsAdderHook;
import nl.chimpgamer.ultimatemobcoins.paper.hooks.MiniPlaceholdersHook;
import nl.chimpgamer.ultimatemobcoins.paper.hooks.MythicMobsHook;
import nl.chimpgamer.ultimatemobcoins.paper.hooks.NexoHook;
import nl.chimpgamer.ultimatemobcoins.paper.hooks.OraxenHook;
import nl.chimpgamer.ultimatemobcoins.paper.hooks.PlaceholderAPIHook;
import nl.chimpgamer.ultimatemobcoins.paper.hooks.RoseStackerHook;
import nl.chimpgamer.ultimatemobcoins.paper.hooks.VaultHook;
import nl.chimpgamer.ultimatemobcoins.paper.hooks.WorldGuardHook;
import nl.chimpgamer.ultimatemobcoins.paper.hooks.betonquest.BetonQuestHook;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginEnableEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u00020/J\b\u00101\u001a\u00020/H\u0002J\u0006\u00102\u001a\u00020/J\b\u00103\u001a\u00020/H\u0002J\u0010\u00104\u001a\u00020/2\u0006\u00105\u001a\u000206H\u0007J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:J\u000e\u0010;\u001a\u0002082\u0006\u00109\u001a\u00020:J\u0016\u0010<\u001a\u00020=2\u0006\u00109\u001a\u00020:2\u0006\u0010>\u001a\u00020?J\u000e\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u0006D"}, d2={"Lnl/chimpgamer/ultimatemobcoins/paper/managers/HookManager;", "Lorg/bukkit/event/Listener;", "plugin", "Lnl/chimpgamer/ultimatemobcoins/paper/UltimateMobCoinsPlugin;", "<init>", "(Lnl/chimpgamer/ultimatemobcoins/paper/UltimateMobCoinsPlugin;)V", "placeholderAPIHook", "Lnl/chimpgamer/ultimatemobcoins/paper/hooks/PlaceholderAPIHook;", "mythicMobsHook", "Lnl/chimpgamer/ultimatemobcoins/paper/hooks/MythicMobsHook;", "getMythicMobsHook", "()Lnl/chimpgamer/ultimatemobcoins/paper/hooks/MythicMobsHook;", "ecoMobsHook", "Lnl/chimpgamer/ultimatemobcoins/paper/hooks/EcoMobsHook;", "getEcoMobsHook", "()Lnl/chimpgamer/ultimatemobcoins/paper/hooks/EcoMobsHook;", "vaultHook", "Lnl/chimpgamer/ultimatemobcoins/paper/hooks/VaultHook;", "getVaultHook", "()Lnl/chimpgamer/ultimatemobcoins/paper/hooks/VaultHook;", "betonQuestHook", "Lnl/chimpgamer/ultimatemobcoins/paper/hooks/betonquest/BetonQuestHook;", "worldGuardHook", "Lnl/chimpgamer/ultimatemobcoins/paper/hooks/WorldGuardHook;", "miniPlaceholdersHook", "Lnl/chimpgamer/ultimatemobcoins/paper/hooks/MiniPlaceholdersHook;", "roseStackerHook", "Lnl/chimpgamer/ultimatemobcoins/paper/hooks/RoseStackerHook;", "getRoseStackerHook", "()Lnl/chimpgamer/ultimatemobcoins/paper/hooks/RoseStackerHook;", "headDatabaseHook", "Lnl/chimpgamer/ultimatemobcoins/paper/hooks/HeadDatabaseHook;", "getHeadDatabaseHook", "()Lnl/chimpgamer/ultimatemobcoins/paper/hooks/HeadDatabaseHook;", "nexoHook", "Lnl/chimpgamer/ultimatemobcoins/paper/hooks/NexoHook;", "getNexoHook", "()Lnl/chimpgamer/ultimatemobcoins/paper/hooks/NexoHook;", "oraxenHook", "Lnl/chimpgamer/ultimatemobcoins/paper/hooks/OraxenHook;", "getOraxenHook", "()Lnl/chimpgamer/ultimatemobcoins/paper/hooks/OraxenHook;", "itemsAdderHook", "Lnl/chimpgamer/ultimatemobcoins/paper/hooks/ItemsAdderHook;", "getItemsAdderHook", "()Lnl/chimpgamer/ultimatemobcoins/paper/hooks/ItemsAdderHook;", "load", "", "unload", "checkPlaceholderAPI", "loadWorldGuard", "disablePlaceholderAPI", "onPluginEnable", "event", "Lorg/bukkit/event/server/PluginEnableEvent;", "getMobCoinDropsMultiplier", "", "player", "Lorg/bukkit/entity/Player;", "getMobCoinDropChanceMultiplier", "isMobCoinDropsAllowed", "", "location", "Lorg/bukkit/Location;", "getEntityName", "", "entity", "Lorg/bukkit/entity/LivingEntity;", "paper"})
public final class HookManager
implements Listener {
    @NotNull
    private final UltimateMobCoinsPlugin plugin;
    private PlaceholderAPIHook placeholderAPIHook;
    @NotNull
    private final MythicMobsHook mythicMobsHook;
    @NotNull
    private final EcoMobsHook ecoMobsHook;
    @NotNull
    private final VaultHook vaultHook;
    @NotNull
    private final BetonQuestHook betonQuestHook;
    @Nullable
    private WorldGuardHook worldGuardHook;
    @NotNull
    private final MiniPlaceholdersHook miniPlaceholdersHook;
    @NotNull
    private final RoseStackerHook roseStackerHook;
    @NotNull
    private final HeadDatabaseHook headDatabaseHook;
    @NotNull
    private final NexoHook nexoHook;
    @NotNull
    private final OraxenHook oraxenHook;
    @NotNull
    private final ItemsAdderHook itemsAdderHook;

    public HookManager(@NotNull UltimateMobCoinsPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        this.plugin = plugin;
        this.mythicMobsHook = new MythicMobsHook(this.plugin);
        this.ecoMobsHook = new EcoMobsHook(this.plugin);
        this.vaultHook = new VaultHook(this.plugin);
        this.betonQuestHook = new BetonQuestHook(this.plugin);
        this.miniPlaceholdersHook = new MiniPlaceholdersHook(this.plugin);
        this.roseStackerHook = new RoseStackerHook(this.plugin);
        this.headDatabaseHook = new HeadDatabaseHook(this.plugin);
        this.nexoHook = new NexoHook(this.plugin);
        this.oraxenHook = new OraxenHook(this.plugin);
        this.itemsAdderHook = new ItemsAdderHook(this.plugin);
    }

    @NotNull
    public final MythicMobsHook getMythicMobsHook() {
        return this.mythicMobsHook;
    }

    @NotNull
    public final EcoMobsHook getEcoMobsHook() {
        return this.ecoMobsHook;
    }

    @NotNull
    public final VaultHook getVaultHook() {
        return this.vaultHook;
    }

    @NotNull
    public final RoseStackerHook getRoseStackerHook() {
        return this.roseStackerHook;
    }

    @NotNull
    public final HeadDatabaseHook getHeadDatabaseHook() {
        return this.headDatabaseHook;
    }

    @NotNull
    public final NexoHook getNexoHook() {
        return this.nexoHook;
    }

    @NotNull
    public final OraxenHook getOraxenHook() {
        return this.oraxenHook;
    }

    @NotNull
    public final ItemsAdderHook getItemsAdderHook() {
        return this.itemsAdderHook;
    }

    public final void load() {
        this.checkPlaceholderAPI();
        this.mythicMobsHook.load();
        this.ecoMobsHook.load();
        this.vaultHook.load();
        this.betonQuestHook.load();
        this.miniPlaceholdersHook.load();
        this.roseStackerHook.load();
        this.headDatabaseHook.load();
        this.nexoHook.load();
        this.oraxenHook.load();
        this.itemsAdderHook.load();
    }

    public final void unload() {
        this.disablePlaceholderAPI();
        this.mythicMobsHook.unload();
        this.ecoMobsHook.unload();
        this.miniPlaceholdersHook.unload();
        this.roseStackerHook.unload();
        this.headDatabaseHook.unload();
        this.nexoHook.unload();
        this.oraxenHook.unload();
        this.itemsAdderHook.unload();
    }

    private final void checkPlaceholderAPI() {
        if (this.plugin.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.placeholderAPIHook = new PlaceholderAPIHook(this.plugin);
            PlaceholderAPIHook placeholderAPIHook = this.placeholderAPIHook;
            if (placeholderAPIHook == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"placeholderAPIHook");
                placeholderAPIHook = null;
            }
            placeholderAPIHook.register();
        }
    }

    public final void loadWorldGuard() {
        block1: {
            if (this.plugin.getServer().getPluginManager().getPlugin("WorldGuard") == null || !this.plugin.getHooksConfig().isHookEnabled("WorldGuard")) break block1;
            WorldGuardHook worldGuardHook = this.worldGuardHook = new WorldGuardHook(this.plugin);
            if (worldGuardHook != null) {
                worldGuardHook.load();
            }
        }
    }

    private final void disablePlaceholderAPI() {
        if (this.placeholderAPIHook != null) {
            PlaceholderAPIHook placeholderAPIHook = this.placeholderAPIHook;
            if (placeholderAPIHook == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"placeholderAPIHook");
                placeholderAPIHook = null;
            }
            placeholderAPIHook.unregister();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler
    public final void onPluginEnable(@NotNull PluginEnableEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = event.getPlugin().getName();
        switch (string.hashCode()) {
            case -247554940: {
                if (string.equals("EcoMobs")) break;
                return;
            }
            case 1009531058: {
                if (!string.equals("BetonQuest")) return;
                this.betonQuestHook.load();
                return;
            }
        }
        this.ecoMobsHook.load();
    }

    public final double getMobCoinDropsMultiplier(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        WorldGuardHook worldGuardHook = this.worldGuardHook;
        return worldGuardHook != null ? worldGuardHook.getMobCoinDropsMultiplier(player) : 0.0;
    }

    public final double getMobCoinDropChanceMultiplier(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        WorldGuardHook worldGuardHook = this.worldGuardHook;
        return worldGuardHook != null ? worldGuardHook.getMobCoinDropChanceMultiplier(player) : 0.0;
    }

    public final boolean isMobCoinDropsAllowed(@NotNull Player player, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WorldGuardHook worldGuardHook = this.worldGuardHook;
        return !(worldGuardHook != null ? !worldGuardHook.isMobCoinDropsAllowed(player, location) : false);
    }

    @NotNull
    public final String getEntityName(@NotNull LivingEntity entity) {
        String ecoMobId;
        String mythicMobId;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        String string = entity.getType().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String entityTypeName = string;
        if (this.mythicMobsHook.isMythicMob((Entity)entity) && (mythicMobId = this.mythicMobsHook.getMythicMobId((Entity)entity)) != null) {
            entityTypeName = mythicMobId;
        }
        if (this.ecoMobsHook.isEcoMob(entity) && (ecoMobId = this.ecoMobsHook.getEcoMobId(entity)) != null) {
            entityTypeName = ecoMobId;
        }
        return entityTypeName;
    }
}

