/*
 * Decompiled with CFR 0.152.
 */
package nl.chimpgamer.ultimatemobcoins.paper.managers;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nl.chimpgamer.ultimatemobcoins.paper.UltimateMobCoinsPlugin;
import nl.chimpgamer.ultimatemobcoins.paper.configurations.SettingsConfig;
import nl.chimpgamer.ultimatemobcoins.paper.managers.DatabaseManager;
import nl.chimpgamer.ultimatemobcoins.paper.storage.dao.sql.SQLUserDao;
import nl.chimpgamer.ultimatemobcoins.paper.storage.sql.UsersTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.DatabaseConfig;
import org.jetbrains.exposed.sql.DatabaseKt;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\u000e\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lnl/chimpgamer/ultimatemobcoins/paper/managers/SQLDatabaseManager;", "Lnl/chimpgamer/ultimatemobcoins/paper/managers/DatabaseManager;", "plugin", "Lnl/chimpgamer/ultimatemobcoins/paper/UltimateMobCoinsPlugin;", "<init>", "(Lnl/chimpgamer/ultimatemobcoins/paper/UltimateMobCoinsPlugin;)V", "database", "Lorg/jetbrains/exposed/sql/Database;", "userDao", "Lnl/chimpgamer/ultimatemobcoins/paper/storage/dao/sql/SQLUserDao;", "getUserDao", "()Lnl/chimpgamer/ultimatemobcoins/paper/storage/dao/sql/SQLUserDao;", "isDatabaseInitialized", "", "()Z", "connect", "", "initialize", "close", "databaseNameAndVersion", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "paper"})
@SourceDebugExtension(value={"SMAP\nSQLDatabaseManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SQLDatabaseManager.kt\nnl/chimpgamer/ultimatemobcoins/paper/managers/SQLDatabaseManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,114:1\n126#2:115\n153#2,3:116\n*S KotlinDebug\n*F\n+ 1 SQLDatabaseManager.kt\nnl/chimpgamer/ultimatemobcoins/paper/managers/SQLDatabaseManager\n*L\n70#1:115\n70#1:116,3\n*E\n"})
public final class SQLDatabaseManager
extends DatabaseManager {
    @NotNull
    private final UltimateMobCoinsPlugin plugin;
    private Database database;
    @NotNull
    private final SQLUserDao userDao;

    public SQLDatabaseManager(@NotNull UltimateMobCoinsPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        super(plugin);
        this.plugin = plugin;
        this.userDao = new SQLUserDao(this.plugin);
    }

    @Override
    @NotNull
    public SQLUserDao getUserDao() {
        return this.userDao;
    }

    public final boolean isDatabaseInitialized() {
        return this.database != null;
    }

    /*
     * WARNING - void declaration
     */
    private final void connect() {
        File file = this.plugin.getDataFolder();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getDataFolder(...)");
        File databaseFile = FilesKt.resolve((File)file, (String)"data.db");
        SettingsConfig settings = this.plugin.getSettingsConfig();
        String string = settings.getStorageType().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        switch (string) {
            case "sqlite": {
                HikariConfig hikariConfig;
                HikariConfig $this$connect_u24lambda_u240 = hikariConfig = new HikariConfig();
                boolean bl = false;
                $this$connect_u24lambda_u240.setPoolName("UltimateMobCoins-pool");
                $this$connect_u24lambda_u240.setJdbcUrl("jdbc:sqlite:" + databaseFile.getAbsolutePath());
                $this$connect_u24lambda_u240.setDriverClassName("org.sqlite.JDBC");
                $this$connect_u24lambda_u240.setMaximumPoolSize(1);
                $this$connect_u24lambda_u240.setTransactionIsolation("TRANSACTION_SERIALIZABLE");
                HikariConfig hikariConfig2 = hikariConfig;
                this.database = Database.Companion.connect$default((Database.Companion)Database.Companion, (DataSource)((DataSource)new HikariDataSource(hikariConfig2)), null, (DatabaseConfig)DatabaseConfig.Companion.invoke(SQLDatabaseManager::connect$lambda$1), null, null, (int)26, null);
                break;
            }
            case "mariadb": 
            case "postgresql": 
            case "mysql": {
                HikariConfig hikariConfig;
                Map $this$connect_u24lambda_u243;
                String storageType;
                String host = settings.getStorageHost();
                int port = settings.getStoragePort();
                String databaseName = settings.getStorageDatabase();
                String username = settings.getStorageUsername();
                String password = settings.getStoragePassword();
                Map properties = MapsKt.toMutableMap(settings.getStorageProperties());
                if (Intrinsics.areEqual((Object)storageType, (Object)"mysql")) {
                    Map $this$connect_u24lambda_u242 = var10_14 = properties;
                    boolean bl = false;
                    $this$connect_u24lambda_u242.putIfAbsent("cachePrepStmts", "true");
                    $this$connect_u24lambda_u242.putIfAbsent("prepStmtCacheSize", "250");
                    $this$connect_u24lambda_u242.putIfAbsent("prepStmtCacheSqlLimit", "2048");
                    $this$connect_u24lambda_u242.putIfAbsent("useServerPrepStmts", "true");
                    $this$connect_u24lambda_u242.putIfAbsent("useLocalSessionState", "true");
                    $this$connect_u24lambda_u242.putIfAbsent("rewriteBatchedStatements", "true");
                    $this$connect_u24lambda_u242.putIfAbsent("cacheResultSetMetadata", "true");
                    $this$connect_u24lambda_u242.putIfAbsent("cacheServerConfiguration", "true");
                    $this$connect_u24lambda_u242.putIfAbsent("elideSetAutoCommits", "true");
                    $this$connect_u24lambda_u242.putIfAbsent("maintainTimeStats", "true");
                    $this$connect_u24lambda_u242.putIfAbsent("alwaysSendSetIsolation", "false");
                    $this$connect_u24lambda_u242.putIfAbsent("cacheCallableStmts", "true");
                } else if (Intrinsics.areEqual((Object)storageType, (Object)"postgresql")) {
                    $this$connect_u24lambda_u243 = var10_14 = properties;
                    boolean bl = false;
                    properties.remove("useUnicode");
                    properties.remove("characterEncoding");
                }
                String url = null;
                url = "jdbc:" + storageType + "://" + host + ":" + port + "/" + databaseName;
                if (!properties.isEmpty()) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    $this$connect_u24lambda_u243 = properties;
                    String string2 = url;
                    boolean $i$f$map = false;
                    void var13_19 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                    boolean $i$f$mapTo = false;
                    Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        void it;
                        Map.Entry item$iv$iv;
                        Map.Entry entry = item$iv$iv = iterator.next();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getKey() + "=" + it.getValue());
                    }
                    url = string2 + "?" + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
                }
                HikariConfig $this$connect_u24lambda_u245 = hikariConfig = new HikariConfig();
                boolean bl = false;
                $this$connect_u24lambda_u245.setPoolName("UltimateMobCoins-pool");
                $this$connect_u24lambda_u245.setJdbcUrl(url);
                String string3 = storageType;
                $this$connect_u24lambda_u245.setDriverClassName(Intrinsics.areEqual((Object)string3, (Object)"mariadb") ? "org.mariadb.jdbc.Driver" : (Intrinsics.areEqual((Object)string3, (Object)"postgresql") ? "org.postgresql.Driver" : "com.mysql.cj.jdbc.Driver"));
                $this$connect_u24lambda_u245.setUsername(username);
                $this$connect_u24lambda_u245.setPassword(password);
                $this$connect_u24lambda_u245.setMaximumPoolSize(settings.getStoragePoolSettingsMaximumPoolSize());
                $this$connect_u24lambda_u245.setMinimumIdle(settings.getStoragePoolSettingsMinimumIdle());
                $this$connect_u24lambda_u245.setMaxLifetime(settings.getStoragePoolSettingsMaximumLifetime());
                $this$connect_u24lambda_u245.setConnectionTimeout(settings.getStoragePoolSettingsConnectionTimeout());
                $this$connect_u24lambda_u245.setInitializationFailTimeout(-1L);
                HikariConfig hikariConfig3 = hikariConfig;
                this.database = Database.Companion.connect$default((Database.Companion)Database.Companion, (DataSource)((DataSource)new HikariDataSource(hikariConfig3)), null, null, null, null, (int)30, null);
            }
        }
    }

    @Override
    public void initialize() {
        this.connect();
        if (this.isDatabaseInitialized()) {
            ThreadLocalTransactionManagerKt.transaction$default(null, arg_0 -> SQLDatabaseManager.initialize$lambda$6(this, arg_0), (int)1, null);
        }
    }

    @Override
    public void close() {
        Database database = this.database;
        if (database == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"database");
            database = null;
        }
        TransactionManager.Companion.closeAndUnregister(database);
    }

    @Override
    @Nullable
    public Object databaseNameAndVersion(@NotNull Continuation<? super String> $completion) {
        Database database = this.database;
        if (database == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"database");
            database = null;
        }
        String string = DatabaseKt.getName((Database)database);
        Database database2 = this.database;
        if (database2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"database");
            database2 = null;
        }
        return string + " " + database2.getVersion();
    }

    private static final Unit connect$lambda$1(DatabaseConfig.Builder $this$DatabaseConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$DatabaseConfig, (String)"$this$DatabaseConfig");
        $this$DatabaseConfig.setDefaultMinRetryDelay(100L);
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$6(SQLDatabaseManager this$0, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        UsersTable[] usersTableArray = new UsersTable[]{UsersTable.INSTANCE};
        SchemaUtils.create$default((SchemaUtils)SchemaUtils.INSTANCE, (Table[])((Table[])usersTableArray), (boolean)false, (int)2, null);
        String string = this$0.plugin.getSettingsConfig().getStorageType().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (!Intrinsics.areEqual((Object)string, (Object)"sqlite")) {
            Transaction.exec$default((Transaction)$this$transaction, (String)((String)CollectionsKt.single((List)UsersTable.INSTANCE.getCoins().modifyStatement())), null, null, (int)6, null);
            Transaction.exec$default((Transaction)$this$transaction, (String)((String)CollectionsKt.single((List)UsersTable.INSTANCE.getCoinsCollected().modifyStatement())), null, null, (int)6, null);
            Transaction.exec$default((Transaction)$this$transaction, (String)((String)CollectionsKt.single((List)UsersTable.INSTANCE.getCoinsSpent().modifyStatement())), null, null, (int)6, null);
        }
        return Unit.INSTANCE;
    }
}

