/*
 * Decompiled with CFR 0.152.
 */
package nl.chimpgamer.ultimatemobcoins.paper.models;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nl.chimpgamer.ultimatemobcoins.paper.utils.SoundUtils;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnl/chimpgamer/ultimatemobcoins/paper/models/ConfigurableSound;", "", "enabled", "", "sound", "", "volume", "", "pitch", "<init>", "(ZLjava/lang/String;FF)V", "bukkitSound", "Lorg/bukkit/Sound;", "play", "", "player", "Lorg/bukkit/entity/Player;", "Companion", "paper"})
public final class ConfigurableSound {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean enabled;
    @NotNull
    private final String sound;
    private final float volume;
    private final float pitch;
    @Nullable
    private final Sound bukkitSound;

    public ConfigurableSound(boolean enabled, @NotNull String sound, float volume, float pitch) {
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        this.enabled = enabled;
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
        this.bukkitSound = SoundUtils.INSTANCE.getSound(this.sound);
    }

    public final void play(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.enabled) {
            return;
        }
        Sound bukkitSound = this.bukkitSound;
        if (bukkitSound == null) {
            System.out.println((Object)("Tried to play `" + this.sound + "` but that sound does not exist!"));
            return;
        }
        player.playSound(player.getLocation(), bukkitSound, this.volume, this.pitch);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a8\u0006\t"}, d2={"Lnl/chimpgamer/ultimatemobcoins/paper/models/ConfigurableSound$Companion;", "", "<init>", "()V", "deserialize", "Lnl/chimpgamer/ultimatemobcoins/paper/models/ConfigurableSound;", "map", "", "", "paper"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConfigurableSound deserialize(@NotNull Map<String, ? extends Object> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"map");
            boolean enabled = false;
            String sound = "";
            float volume = 1.0f;
            float pitch = 1.0f;
            if (map2.containsKey("enabled")) {
                enabled = Boolean.parseBoolean(String.valueOf(map2.get("enabled")));
            }
            if (map2.containsKey("sound")) {
                sound = String.valueOf(map2.get("sound"));
            }
            if (map2.containsKey("volume")) {
                volume = Float.parseFloat(String.valueOf(map2.get("volume")));
            }
            if (map2.containsKey("pitch")) {
                pitch = Float.parseFloat(String.valueOf(map2.get("pitch")));
            }
            return new ConfigurableSound(enabled, sound, volume, pitch);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

