/*
 * Decompiled with CFR 0.152.
 */
package nl.chimpgamer.ultimatemobcoins.paper.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0000\u00a2\u0006\u0002\b\u0014J\u0010\u0010\u0015\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lnl/chimpgamer/ultimatemobcoins/paper/utils/NumberFormatter;", "", "<init>", "()V", "COMMAS_FORMAT", "Ljava/text/DecimalFormat;", "getCOMMAS_FORMAT", "()Ljava/text/DecimalFormat;", "FIXED_FORMAT", "getFIXED_FORMAT", "PRETTY_FORMAT", "compactSuffixes", "", "getCompactSuffixes", "()[C", "setPrettyFormat", "", "pattern", "", "symbolLocaleString", "setPrettyFormat$paper", "displayCurrency", "value", "Ljava/math/BigDecimal;", "compactDecimalFormat", "number", "", "paper"})
public final class NumberFormatter {
    @NotNull
    public static final NumberFormatter INSTANCE = new NumberFormatter();
    @NotNull
    private static final DecimalFormat COMMAS_FORMAT = new DecimalFormat("#,###");
    @NotNull
    private static final DecimalFormat FIXED_FORMAT = new DecimalFormat("#");
    @NotNull
    private static DecimalFormat PRETTY_FORMAT = new DecimalFormat("###,##0.00");
    @NotNull
    private static final char[] compactSuffixes;

    private NumberFormatter() {
    }

    @NotNull
    public final DecimalFormat getCOMMAS_FORMAT() {
        return COMMAS_FORMAT;
    }

    @NotNull
    public final DecimalFormat getFIXED_FORMAT() {
        return FIXED_FORMAT;
    }

    @NotNull
    public final char[] getCompactSuffixes() {
        return compactSuffixes;
    }

    public final void setPrettyFormat$paper(@NotNull String pattern, @Nullable String symbolLocaleString) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        DecimalFormatSymbols decimalFormatSymbols = symbolLocaleString != null ? DecimalFormatSymbols.getInstance(Locale.forLanguageTag(symbolLocaleString)) : DecimalFormatSymbols.getInstance(Locale.US);
        DecimalFormat currencyFormat = new DecimalFormat(pattern, decimalFormatSymbols);
        currencyFormat.setRoundingMode(RoundingMode.FLOOR);
        PRETTY_FORMAT = currencyFormat;
    }

    @NotNull
    public final String displayCurrency(@Nullable BigDecimal value) {
        String str;
        String string = str = PRETTY_FORMAT.format(value);
        Intrinsics.checkNotNull((Object)string);
        if (StringsKt.endsWith$default((String)string, (String)".00", (boolean)false, (int)2, null)) {
            string = str;
            Intrinsics.checkNotNull((Object)string);
            str = StringsKt.dropLast((String)string, (int)3);
        }
        string = str;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final String compactDecimalFormat(@NotNull Number number) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        long numValue = number.longValue();
        int value = (int)Math.floor(Math.log10(numValue));
        int base = value / 3;
        if (value >= 3 && base < compactSuffixes.length) {
            object = new DecimalFormat("#0.0").format((double)numValue / Math.pow(10.0, base * 3)) + compactSuffixes[base];
        } else {
            String string = new DecimalFormat("#,##0").format(numValue);
            Intrinsics.checkNotNull((Object)string);
            object = string;
        }
        return object;
    }

    static {
        char[] cArray = new char[]{' ', 'k', 'M', 'B', 'T', 'P', 'E'};
        compactSuffixes = cArray;
    }
}

