/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloadedcompanion.client.config;

import io.github.steaf23.bingoreloadedcompanion.card.BingoCard;
import io.github.steaf23.bingoreloadedcompanion.card.BingoGamemode;
import io.github.steaf23.bingoreloadedcompanion.card.Task;
import io.github.steaf23.bingoreloadedcompanion.client.BingoReloadedCompanionClient;
import io.github.steaf23.bingoreloadedcompanion.client.config.DiscardConfirmScreen;
import io.github.steaf23.bingoreloadedcompanion.client.hud.BingoCardHudElement;
import io.github.steaf23.bingoreloadedcompanion.client.hud.HudConfigManager;
import io.github.steaf23.bingoreloadedcompanion.client.hud.HudPlacement;
import io.github.steaf23.bingoreloadedcompanion.client.util.ScreenHelper;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class BingoConfigScreen
extends class_437 {
    private final class_437 modMenuScreen;
    private final HudConfigManager configManager;
    private final BingoCardHudElement previewCard;
    private static final class_2960 HIDE_BUTTON = class_2960.method_60654((String)"bingoreloadedcompanion:hide_button");
    private static final class_2960 HIDE_BUTTON_HIGHLIGHT = class_2960.method_60654((String)"bingoreloadedcompanion:hide_button_highlighted");
    private static final class_2960 SHOW_BUTTON = class_2960.method_60654((String)"bingoreloadedcompanion:show_button");
    private static final class_2960 SHOW_BUTTON_HIGHLIGHT = class_2960.method_60654((String)"bingoreloadedcompanion:show_button_highlighted");
    private static final class_2960 RESET_BUTTON = class_2960.method_60654((String)"bingoreloadedcompanion:reset_button");
    private static final class_2960 RESET_BUTTON_HIGHLIGHT = class_2960.method_60654((String)"bingoreloadedcompanion:reset_button_highlighted");
    private static final class_2960 SCALE_BUTTON = class_2960.method_60654((String)"bingoreloadedcompanion:scale_button");
    private static final class_2960 SCALE_BUTTON_HIGHLIGHT = class_2960.method_60654((String)"bingoreloadedcompanion:scale_button_highlighted");
    private static final class_2960 SLIDER_BUTTON_SLIDER = class_2960.method_60654((String)"bingoreloadedcompanion:slider_button_slider");
    private static final class_2960 SLIDER_BUTTON_SLIDER_HIGHLIGHT = class_2960.method_60654((String)"bingoreloadedcompanion:slider_button_slider_highlighted");
    private static final class_2960 SLIDER_BUTTON_BACKGROUND = class_2960.method_60654((String)"bingoreloadedcompanion:slider_button_background");
    private static final class_2960 SLIDER_BUTTON_PROGRESS = class_2960.method_60654((String)"bingoreloadedcompanion:slider_button_progress");
    private static final int BUTTON_WIDTH = 14;
    private static final int SLIDER_WIDTH = 10;
    private static final int SLIDER_BACKGROUND_WIDTH = 30;
    private static final int BUTTON_HEIGHT = 14;
    private static final long MOVE_CURSOR = GLFW.glfwCreateStandardCursor((int)221193);
    private class_2960 selectedElement;
    private class_2960 hoveringElement;
    private boolean dragging = false;
    private boolean draggingSlider = false;
    private double clickOffsetX;
    private double clickOffsetY;
    private boolean removed = false;
    private final List<class_2960> elements = List.of(BingoReloadedCompanionClient.BINGO_CARD_TASKS, BingoReloadedCompanionClient.BINGO_CARD_GAMEMODE);

    protected BingoConfigScreen(class_437 modMenuScreen, HudConfigManager hudConfig) {
        super(class_2561.method_30163((String)"Bingo Reloaded Options"));
        this.modMenuScreen = modMenuScreen;
        this.configManager = hudConfig;
        this.previewCard = new BingoCardHudElement(this.configManager);
        ArrayList<Task> testTasks = new ArrayList<Task>();
        for (int i = 0; i < 25; ++i) {
            testTasks.add(new Task(Task.TaskCompletion.INCOMPLETE, class_2960.method_60654((String)"bingoreloaded:item"), class_1802.field_8407, 1));
        }
        BingoCard testCard5x = new BingoCard(BingoGamemode.REGULAR, 5, testTasks);
        this.previewCard.setCard(testCard5x);
    }

    protected void method_25426() {
        class_4185 backButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"Save & Exit"), btn -> {
            if (this.field_22787 == null) {
                return;
            }
            this.configManager.save();
            this.closeScreen();
        }).method_46433(5, this.field_22790 - 20 - 5).method_46431();
        this.method_37063((class_364)backButton);
        int buttonWidth = Math.max(150, this.field_22793.method_27525((class_5348)class_2561.method_30163((String)"Reset all elements")) + 10);
        class_4185 resetButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"Reset all elements"), btn -> this.configManager.resetAllElements()).method_46433(this.field_22789 - buttonWidth - 5, this.field_22790 - 20 - 5).method_46431();
        this.method_37063((class_364)resetButton);
    }

    public void method_25432() {
        GLFW.glfwSetCursor((long)this.getGameWindowId(), (long)0L);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        super.method_25394(context, mouseX, mouseY, deltaTicks);
        this.previewCard.renderElement(context, deltaTicks);
        double infoAlpha = mouseY < 40 ? 0.5 : 1.0;
        List<class_2561> text = List.of(class_2561.method_30163((String)"Click on an element to select it."), class_2561.method_30163((String)"You can move it by dragging the mouse or using the movement keys."));
        int recordWidth = 0;
        for (class_2561 t : text) {
            int textWidth = this.field_22793.method_27525((class_5348)t);
            if (textWidth <= recordWidth) continue;
            recordWidth = textWidth;
        }
        int textHeight = text.size() * 15 + 5;
        int backgroundWidth = recordWidth + 10;
        int backgroundStartX = this.field_22789 / 2 - backgroundWidth / 2;
        context.method_25294(backgroundStartX, 0, backgroundStartX + backgroundWidth, textHeight, ScreenHelper.addAlphaToColor(0, (int)(128.0 * infoAlpha)));
        int y = 5;
        for (class_2561 t : text) {
            int textWidth = this.field_22793.method_27525((class_5348)t);
            int textX = this.field_22789 / 2 - textWidth / 2;
            context.method_51439(this.field_22793, t, textX, y, ScreenHelper.addAlphaToColor(class_124.field_1068.method_532(), (int)(255.0 * infoAlpha)), true);
            y += 15;
        }
        for (class_2960 element : this.elements) {
            HudPlacement placement = this.configManager.getHudPlacement(element);
            HudConfigManager.Rect rect = this.configManager.getUsedRectOfElement(element);
            if (!placement.visible()) {
                context.method_25294(rect.x(), rect.y(), rect.endX(), rect.endY(), 0x44FF0000);
            } else if (placement.transparency() < 0.1) {
                context.method_25294(rect.x(), rect.y(), rect.endX(), rect.endY(), 0x1100FFFF);
            }
            if (this.selectedElement == element) {
                int buttonY;
                context.method_73198(rect.x() - 3, rect.y() - 3, rect.width() + 6, rect.height() + 6, ScreenHelper.addAlphaToColor(class_124.field_1054.method_532(), 200));
                int showButtonX = rect.endX() - 30;
                int scaleButtonX = rect.endX() - 46;
                int resetButtonX = rect.endX() - 14;
                int n = buttonY = this.field_22790 - rect.endY() > 18 ? rect.endY() + 4 : rect.y() - 14 - 4;
                if (this.isMouseOverShowButton(mouseX, mouseY) && this.configManager.getHudPlacement(element).visible()) {
                    context.method_51438(class_310.method_1551().field_1772, class_2561.method_30163((String)"Hide"), mouseX, mouseY);
                    context.method_52706(class_10799.field_56883, HIDE_BUTTON_HIGHLIGHT, showButtonX, buttonY, 14, 14);
                } else if (this.isMouseOverShowButton(mouseX, mouseY)) {
                    context.method_51438(class_310.method_1551().field_1772, class_2561.method_30163((String)"Show"), mouseX, mouseY);
                    context.method_52706(class_10799.field_56883, SHOW_BUTTON_HIGHLIGHT, showButtonX, buttonY, 14, 14);
                } else if (this.configManager.getHudPlacement(element).visible()) {
                    context.method_52706(class_10799.field_56883, HIDE_BUTTON, showButtonX, buttonY, 14, 14);
                } else {
                    context.method_52706(class_10799.field_56883, SHOW_BUTTON, showButtonX, buttonY, 14, 14);
                }
                if (this.isMouseOverResetButton(mouseX, mouseY)) {
                    context.method_51438(class_310.method_1551().field_1772, class_2561.method_30163((String)"Reset"), mouseX, mouseY);
                    context.method_52706(class_10799.field_56883, RESET_BUTTON_HIGHLIGHT, resetButtonX, buttonY, 14, 14);
                } else {
                    context.method_52706(class_10799.field_56883, RESET_BUTTON, resetButtonX, buttonY, 14, 14);
                }
                if (this.isMouseOverScaleButton(mouseX, mouseY)) {
                    context.method_51438(class_310.method_1551().field_1772, class_2561.method_30163((String)"Change size"), mouseX, mouseY);
                    context.method_52706(class_10799.field_56883, SCALE_BUTTON_HIGHLIGHT, scaleButtonX, buttonY, 14, 14);
                } else {
                    context.method_52706(class_10799.field_56883, SCALE_BUTTON, scaleButtonX, buttonY, 14, 14);
                }
                int sliderButtonX = rect.endX() - 78;
                this.drawSlider(context, sliderButtonX, buttonY, placement.transparency(), mouseX, mouseY);
                continue;
            }
            if (this.hoveringElement != element) continue;
            context.method_25294(rect.x() - 2, rect.y() - 2, rect.endX() + 2, rect.endY() + 2, 0x44DADADA);
        }
        if (this.dragging && this.selectedElement != null) {
            HudConfigManager.Rect dragRect = this.configManager.getUsedRectOfElement(this.selectedElement);
            int offsetX = (int)((double)mouseX - this.clickOffsetX);
            int offsetY = (int)((double)mouseY - this.clickOffsetY);
            context.method_25294(offsetX - 2, offsetY - 2, offsetX + dragRect.width() + 2, offsetY + dragRect.height() + 2, 0x44DADADA);
        }
    }

    private void drawSlider(class_332 context, int x, int y, double value, int mouseX, int mouseY) {
        class_2960 sliderTexture = SLIDER_BUTTON_SLIDER;
        if (this.isMouseOverTransparencySlider(mouseX, mouseY)) {
            context.method_51438(class_310.method_1551().field_1772, class_2561.method_30163((String)"Transparency"), mouseX, mouseY);
            sliderTexture = SLIDER_BUTTON_SLIDER_HIGHLIGHT;
        }
        int range = 20;
        int progressStartX = (int)((double)range * (1.0 - value));
        int progressSizeX = range - (progressStartX + 5);
        context.method_52706(class_10799.field_56883, SLIDER_BUTTON_BACKGROUND, x, y, 30, 14);
        context.method_70846(class_10799.field_56883, SLIDER_BUTTON_PROGRESS, 30, 14, progressStartX + 5, 0, x + progressStartX + 5, y, progressSizeX + 10, 14);
        context.method_52706(class_10799.field_56883, sliderTexture, x + progressStartX, y, 10, 14);
    }

    private boolean isMouseOverElement(class_2960 element, double mouseX, double mouseY) {
        HudConfigManager.Rect rect = this.configManager.getUsedRectOfElement(element);
        return ScreenHelper.isPointWithinBounds(rect.x(), rect.y(), rect.width(), rect.height(), mouseX, mouseY);
    }

    private boolean isMouseOverScaleButton(double mouseX, double mouseY) {
        if (this.selectedElement == null) {
            return false;
        }
        HudConfigManager.Rect usedRect = this.configManager.getUsedRectOfElement(this.selectedElement);
        int buttonX = usedRect.endX() - 46;
        int buttonY = this.field_22790 - usedRect.endY() > 18 ? usedRect.endY() + 4 : usedRect.y() - 14 - 4;
        return ScreenHelper.isPointWithinBounds(buttonX, buttonY, 14, 14, mouseX, mouseY);
    }

    private boolean isMouseOverShowButton(double mouseX, double mouseY) {
        if (this.selectedElement == null) {
            return false;
        }
        HudConfigManager.Rect usedRect = this.configManager.getUsedRectOfElement(this.selectedElement);
        int buttonX = usedRect.endX() - 30;
        int buttonY = this.field_22790 - usedRect.endY() > 18 ? usedRect.endY() + 4 : usedRect.y() - 14 - 4;
        return ScreenHelper.isPointWithinBounds(buttonX, buttonY, 14, 14, mouseX, mouseY);
    }

    private boolean isMouseOverResetButton(double mouseX, double mouseY) {
        if (this.selectedElement == null) {
            return false;
        }
        HudConfigManager.Rect usedRect = this.configManager.getUsedRectOfElement(this.selectedElement);
        int buttonX = usedRect.endX() - 14;
        int buttonY = this.field_22790 - usedRect.endY() > 18 ? usedRect.endY() + 4 : usedRect.y() - 14 - 4;
        return ScreenHelper.isPointWithinBounds(buttonX, buttonY, 14, 14, mouseX, mouseY);
    }

    private boolean isMouseOverTransparencySlider(double mouseX, double mouseY) {
        if (this.selectedElement == null) {
            return false;
        }
        HudConfigManager.Rect usedRect = this.configManager.getUsedRectOfElement(this.selectedElement);
        int buttonX = usedRect.endX() - 78;
        int buttonY = this.field_22790 - usedRect.endY() > 18 ? usedRect.endY() + 4 : usedRect.y() - 14 - 4;
        return ScreenHelper.isPointWithinBounds(buttonX, buttonY, 30, 14, mouseX, mouseY);
    }

    private long getGameWindowId() {
        return this.field_22787.method_22683().method_4490();
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (doubled) {
            return true;
        }
        int button = click.method_74245();
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        if (button != 0) {
            return super.method_25402(click, doubled);
        }
        if (this.isMouseOverShowButton(mouseX, mouseY)) {
            this.configManager.toggleElementVisible(this.selectedElement);
            return true;
        }
        if (this.isMouseOverResetButton(mouseX, mouseY)) {
            this.configManager.resetElement(this.selectedElement);
            return true;
        }
        if (this.isMouseOverScaleButton(mouseX, mouseY)) {
            int scale = (int)this.configManager.getHudPlacement(this.selectedElement).scaleX();
            scale = 1 + (scale - 1 + 1) % 4;
            this.configManager.setElementScale(this.selectedElement, scale, scale);
            return true;
        }
        if (this.isMouseOverTransparencySlider(mouseX, mouseY)) {
            this.draggingSlider = true;
            int range = 20;
            HudConfigManager.Rect usedRect = this.configManager.getUsedRectOfElement(this.selectedElement);
            int buttonX = usedRect.endX() - 78;
            int targetX = (int)mouseX - buttonX;
            int pixelValue = Math.clamp((long)targetX, 5, range + 5);
            this.configManager.setElementTransparency(this.selectedElement, 1.0 - (double)(pixelValue - 5) / (double)range);
            return true;
        }
        for (class_2960 element : this.elements) {
            if (!this.isMouseOverElement(element, mouseX, mouseY)) continue;
            if (this.selectedElement == element) {
                this.dragging = true;
                HudConfigManager.Rect selectedRect = this.configManager.getUsedRectOfElement(element);
                this.clickOffsetX = mouseX - (double)selectedRect.x();
                this.clickOffsetY = mouseY - (double)selectedRect.y();
            } else if (this.selectedElement != element) {
                this.selectedElement = element;
                GLFW.glfwSetCursor((long)this.getGameWindowId(), (long)MOVE_CURSOR);
            }
            return true;
        }
        this.selectedElement = null;
        return super.method_25402(click, doubled);
    }

    public boolean method_25406(class_11909 click) {
        int button = click.method_74245();
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        if (this.selectedElement != null && this.dragging) {
            this.configManager.moveElement(this.selectedElement, (int)(mouseX - this.clickOffsetX), (int)(mouseY - this.clickOffsetY), this.field_22789, this.field_22790);
            this.dragging = false;
            this.clickOffsetX = 0.0;
            this.clickOffsetY = 0.0;
            return true;
        }
        if (this.selectedElement != null && this.draggingSlider) {
            this.draggingSlider = false;
        }
        return super.method_25406(click);
    }

    public void method_16014(double mouseX, double mouseY) {
        if (this.isMouseOverTransparencySlider(mouseX, mouseY) && this.draggingSlider) {
            int range = 20;
            HudConfigManager.Rect usedRect = this.configManager.getUsedRectOfElement(this.selectedElement);
            int buttonX = usedRect.endX() - 78;
            int targetX = (int)mouseX - buttonX;
            int pixelValue = Math.clamp((long)targetX, 5, range + 5);
            this.configManager.setElementTransparency(this.selectedElement, 1.0 - (double)(pixelValue - 5) / (double)range);
            return;
        }
        for (class_2960 element : this.elements) {
            if (!this.isMouseOverElement(element, mouseX, mouseY)) continue;
            if (element == this.selectedElement) {
                GLFW.glfwSetCursor((long)this.getGameWindowId(), (long)MOVE_CURSOR);
            }
            this.hoveringElement = element;
            if (this.hoveringElement != this.selectedElement) {
                GLFW.glfwSetCursor((long)this.getGameWindowId(), (long)0L);
            }
            return;
        }
        if (this.hoveringElement != null) {
            this.hoveringElement = null;
            GLFW.glfwSetCursor((long)this.getGameWindowId(), (long)0L);
        }
    }

    public boolean method_25404(class_11908 key) {
        int keyCode = key.comp_4795();
        int scanCode = key.comp_4796();
        int modifiers = key.comp_4797();
        if (keyCode == 256) {
            this.closeScreen();
            return true;
        }
        if (this.selectedElement == null) {
            return super.method_25404(key);
        }
        if (keyCode == 87 || keyCode == 265) {
            HudConfigManager.Rect rect = this.configManager.getUsedRectOfElement(this.selectedElement);
            this.configManager.moveElement(this.selectedElement, rect.x(), rect.y() - 1, this.field_22789, this.field_22790);
        } else if (keyCode == 83 || keyCode == 264) {
            HudConfigManager.Rect rect = this.configManager.getUsedRectOfElement(this.selectedElement);
            this.configManager.moveElement(this.selectedElement, rect.x(), rect.y() + 1, this.field_22789, this.field_22790);
        } else if (keyCode == 65 || keyCode == 263) {
            HudConfigManager.Rect rect = this.configManager.getUsedRectOfElement(this.selectedElement);
            this.configManager.moveElement(this.selectedElement, rect.x() - 1, rect.y(), this.field_22789, this.field_22790);
        } else if (keyCode == 68 || keyCode == 262) {
            HudConfigManager.Rect rect = this.configManager.getUsedRectOfElement(this.selectedElement);
            this.configManager.moveElement(this.selectedElement, rect.x() + 1, rect.y(), this.field_22789, this.field_22790);
        }
        return super.method_25404(key);
    }

    public boolean method_25422() {
        return false;
    }

    protected void closeScreen() {
        if (this.field_22787 == null) {
            return;
        }
        if (this.configManager.hasChanged()) {
            this.field_22787.method_1507((class_437)new DiscardConfirmScreen(new BingoConfigScreen(this.modMenuScreen, this.configManager), this.modMenuScreen, this.configManager::load));
            return;
        }
        this.configManager.load();
        this.field_22787.method_1507(this.modMenuScreen);
    }
}

