/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloadedcompanion.client.hud;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.github.steaf23.bingoreloadedcompanion.client.hud.HudConfig;
import io.github.steaf23.bingoreloadedcompanion.client.hud.HudPlacement;
import java.io.IOException;
import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class HudConfigSerializer
extends TypeAdapter<HudConfig> {
    public void write(JsonWriter jsonWriter, HudConfig hudConfig) throws IOException {
        jsonWriter.beginObject();
        jsonWriter.name("elements");
        jsonWriter.beginObject();
        for (class_2960 id : hudConfig.elements().keySet()) {
            jsonWriter.name(id.toString());
            this.writePlacement(jsonWriter, hudConfig.elements().get(id));
        }
        jsonWriter.endObject();
        this.writeVersion(jsonWriter, hudConfig.version());
        jsonWriter.endObject();
    }

    public HudConfig read(JsonReader jsonReader) throws IOException {
        HashMap<class_2960, HudPlacement> map = new HashMap<class_2960, HudPlacement>();
        String version = "0.0";
        jsonReader.beginObject();
        while (jsonReader.hasNext() && jsonReader.peek().equals((Object)JsonToken.NAME)) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "elements": {
                    jsonReader.beginObject();
                    while (jsonReader.hasNext()) {
                        String id = jsonReader.nextName();
                        HudPlacement placement = this.readPlacement(jsonReader);
                        map.put(class_2960.method_60654((String)id), placement);
                    }
                    jsonReader.endObject();
                    break;
                }
                case "version": {
                    version = jsonReader.nextString();
                }
            }
        }
        jsonReader.endObject();
        return new HudConfig(version, map);
    }

    protected void writePlacement(JsonWriter json, HudPlacement placement) throws IOException {
        json.beginObject();
        json.name("x");
        json.value(placement.x());
        json.name("y");
        json.value(placement.y());
        json.name("visible");
        json.value(placement.visible());
        json.name("scaleX");
        json.value(placement.scaleX());
        json.name("scaleY");
        json.value(placement.scaleY());
        json.name("transparency");
        json.value(placement.transparency());
        json.endObject();
    }

    protected HudPlacement readPlacement(JsonReader json) throws IOException {
        json.beginObject();
        double x = 0.0;
        double y = 0.0;
        boolean visible = true;
        double scaleX = 1.0;
        double scaleY = 1.0;
        double transparency = 1.0;
        block16: while (json.hasNext() && json.peek().equals((Object)JsonToken.NAME)) {
            String name;
            switch (name = json.nextName()) {
                case "x": {
                    x = Math.clamp(json.nextDouble(), 0.0, 1.0);
                    continue block16;
                }
                case "y": {
                    y = Math.clamp(json.nextDouble(), 0.0, 1.0);
                    continue block16;
                }
                case "visible": {
                    visible = json.nextBoolean();
                    continue block16;
                }
                case "scaleX": {
                    scaleX = Math.clamp(json.nextDouble(), 1.0, 4.0);
                    continue block16;
                }
                case "scaleY": {
                    scaleY = Math.clamp(json.nextDouble(), 1.0, 4.0);
                    continue block16;
                }
                case "transparency": {
                    transparency = Math.clamp(json.nextDouble(), 0.0, 1.0);
                    continue block16;
                }
            }
            json.skipValue();
        }
        json.endObject();
        return new HudPlacement(x, y, visible, (float)scaleX, (float)scaleY, transparency);
    }

    protected void writeVersion(JsonWriter json, String version) throws IOException {
        json.name("version");
        json.value(version);
    }
}

