/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloadedcompanion.client;

import io.github.steaf23.bingoreloadedcompanion.client.ExtraMath;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_5251;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class TextColorGradient {
    Map<class_5251, Float> colors = new HashMap<class_5251, Float>();

    public TextColorGradient addColor(@NotNull class_5251 color, float position) throws IllegalArgumentException {
        if ((double)position < 0.0 || (double)position > 1.0) {
            throw new IllegalArgumentException("position must be between 0.0 and 1.0.");
        }
        this.colors.put(color, Float.valueOf(position));
        return this;
    }

    public boolean removeColor(@NotNull class_5251 color) {
        return this.colors.remove(color) != null;
    }

    public class_5251 sample(float position) {
        if (this.colors.isEmpty()) {
            return class_5251.method_27718((class_124)class_124.field_1068);
        }
        if (this.colors.size() == 1) {
            return (class_5251)this.colors.keySet().stream().toList().getFirst();
        }
        List<class_5251> sortedColors = this.colors.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).toList();
        class_5251 leftColor = sortedColors.get(0);
        class_5251 rightColor = sortedColors.get(1);
        for (int i = 0; i < sortedColors.size() - 1; ++i) {
            if (!(position >= this.colors.get(sortedColors.get(i)).floatValue()) || !(position <= this.colors.get(sortedColors.get(i + 1)).floatValue())) continue;
            leftColor = sortedColors.get(i);
            rightColor = sortedColors.get(i + 1);
        }
        float leftPosition = this.colors.get(leftColor).floatValue();
        float rightPosition = this.colors.get(rightColor).floatValue();
        float lerpValue = ExtraMath.map(position, leftPosition, rightPosition, 0.0f, 1.0f);
        return TextColorGradient.lerpChatColor(leftColor, rightColor, lerpValue);
    }

    public static class_5251 lerpChatColor(@NotNull class_5251 left, @NotNull class_5251 right, float value) {
        int leftRgb = left.method_27716();
        int rightRgb = right.method_27716();
        int red = (int)ExtraMath.lerp((leftRgb & 0xFF0000) >> 16, (rightRgb & 0xFF0000) >> 16, value);
        int green = (int)ExtraMath.lerp((leftRgb & 0xFF00) >> 8, (rightRgb & 0xFF00) >> 8, value);
        int blue = (int)ExtraMath.lerp(leftRgb & 0xFF, rightRgb & 0xFF, value);
        return class_5251.method_27717((int)new Color(Math.clamp((long)red, 0, 255), Math.clamp((long)green, 0, 255), Math.clamp((long)blue, 0, 255)).getRGB());
    }
}

