/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloadedcompanion.client.config;

import io.github.steaf23.bingoreloadedcompanion.card.BingoCard;
import io.github.steaf23.bingoreloadedcompanion.card.BingoGamemode;
import io.github.steaf23.bingoreloadedcompanion.card.Task;
import io.github.steaf23.bingoreloadedcompanion.client.BingoReloadedCompanionClient;
import io.github.steaf23.bingoreloadedcompanion.client.hud.BingoCardHudElement;
import io.github.steaf23.bingoreloadedcompanion.client.hud.HudConfigManager;
import io.github.steaf23.bingoreloadedcompanion.client.hud.HudPlacement;
import io.github.steaf23.bingoreloadedcompanion.client.util.ScreenHelper;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class BingoConfigScreen
extends class_437 {
    private final class_437 modMenuScreen;
    private final HudConfigManager configManager;
    private final BingoCardHudElement previewCard;
    private static final class_2960 HIDE_BUTTON = class_2960.method_60654((String)"bingoreloadedcompanion:hide_button");
    private static final class_2960 HIDE_BUTTON_HIGHLIGHT = class_2960.method_60654((String)"bingoreloadedcompanion:hide_button_highlighted");
    private static final class_2960 SHOW_BUTTON = class_2960.method_60654((String)"bingoreloadedcompanion:show_button");
    private static final class_2960 SHOW_BUTTON_HIGHLIGHT = class_2960.method_60654((String)"bingoreloadedcompanion:show_button_highlighted");
    private static final class_2960 RESET_BUTTON = class_2960.method_60654((String)"bingoreloadedcompanion:reset_button");
    private static final class_2960 RESET_BUTTON_HIGHLIGHT = class_2960.method_60654((String)"bingoreloadedcompanion:reset_button_highlighted");
    private static final class_2960 SCALE_BUTTON = class_2960.method_60654((String)"bingoreloadedcompanion:scale_button");
    private static final class_2960 SCALE_BUTTON_HIGHLIGHT = class_2960.method_60654((String)"bingoreloadedcompanion:scale_button_highlighted");
    private static final int BUTTON_WIDTH = 14;
    private static final int BUTTON_HEIGHT = 14;
    private static final long MOVE_CURSOR = GLFW.glfwCreateStandardCursor((int)221193);
    private class_2960 selectedElement;
    private class_2960 hoveringElement;
    private boolean dragging = false;
    private double clickOffsetX;
    private double clickOffsetY;
    private final List<class_2960> elements = List.of(BingoReloadedCompanionClient.BINGO_CARD_TASKS, BingoReloadedCompanionClient.BINGO_CARD_GAMEMODE);

    protected BingoConfigScreen(class_437 modMenuScreen, HudConfigManager hudConfig) {
        super(class_2561.method_30163((String)"Bingo Reloaded Options"));
        this.modMenuScreen = modMenuScreen;
        this.configManager = hudConfig;
        this.previewCard = new BingoCardHudElement(this.configManager);
        ArrayList<Task> testTasks = new ArrayList<Task>();
        for (int i = 0; i < 25; ++i) {
            testTasks.add(new Task(Task.TaskCompletion.INCOMPLETE, class_2960.method_60654((String)"bingoreloaded:item"), class_1802.field_8407, 1));
        }
        BingoCard testCard5x = new BingoCard(BingoGamemode.REGULAR, 5, testTasks);
        this.previewCard.setCard(testCard5x);
    }

    protected void method_25426() {
        class_4185 backButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"Save & Exit"), btn -> {
            if (this.field_22787 == null) {
                return;
            }
            this.configManager.save();
            this.field_22787.method_1507(this.modMenuScreen);
        }).method_46433(5, this.field_22790 - 20 - 5).method_46431();
        this.method_37063((class_364)backButton);
    }

    public void method_25432() {
        this.configManager.load();
        super.method_25432();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        super.method_25394(context, mouseX, mouseY, deltaTicks);
        this.previewCard.renderElement(context, deltaTicks);
        int textWidth = this.field_22793.method_1727("You can move it by dragging the mouse or using the movement keys.");
        context.method_51434(this.field_22793, List.of(class_2561.method_30163((String)""), class_2561.method_30163((String)"Click on an element to select it."), class_2561.method_30163((String)"You can move it by dragging the mouse or using the movement keys.")), this.field_22789 / 2 - textWidth / 2, 10);
        for (class_2960 element : this.elements) {
            HudPlacement placement = this.configManager.getHudPlacement(element);
            HudConfigManager.Rect rect = this.configManager.getUsedRectOfElement(element);
            if (!placement.visible()) {
                context.method_25294(rect.x(), rect.y(), rect.endX(), rect.endY(), 0x44FF0000);
            }
            if (this.selectedElement == element) {
                int buttonY;
                context.method_49601(rect.x() - 3, rect.y() - 3, rect.width() + 6, rect.height() + 6, ScreenHelper.addAlphaToColor(class_124.field_1054.method_532(), 200));
                int showButtonX = rect.endX() - 30;
                int scaleButtonX = rect.endX() - 46;
                int resetButtonX = rect.endX() - 14;
                int n = buttonY = this.field_22790 - rect.endY() > 18 ? rect.endY() + 4 : rect.y() - 14 - 4;
                if (this.isMouseOverShowButton(mouseX, mouseY) && this.configManager.getHudPlacement(element).visible()) {
                    context.method_51438(class_310.method_1551().field_1772, class_2561.method_30163((String)"Hide"), 100, 100);
                    context.method_52706(class_10799.field_56883, HIDE_BUTTON_HIGHLIGHT, showButtonX, buttonY, 14, 14);
                } else if (this.isMouseOverShowButton(mouseX, mouseY)) {
                    context.method_51438(class_310.method_1551().field_1772, class_2561.method_30163((String)"Show"), mouseX, mouseY);
                    context.method_52706(class_10799.field_56883, SHOW_BUTTON_HIGHLIGHT, showButtonX, buttonY, 14, 14);
                } else if (this.configManager.getHudPlacement(element).visible()) {
                    context.method_52706(class_10799.field_56883, HIDE_BUTTON, showButtonX, buttonY, 14, 14);
                } else {
                    context.method_52706(class_10799.field_56883, SHOW_BUTTON, showButtonX, buttonY, 14, 14);
                }
                if (this.isMouseOverResetButton(mouseX, mouseY)) {
                    context.method_51438(class_310.method_1551().field_1772, class_2561.method_30163((String)"Reset"), mouseX, mouseY);
                    context.method_52706(class_10799.field_56883, RESET_BUTTON_HIGHLIGHT, resetButtonX, buttonY, 14, 14);
                } else {
                    context.method_52706(class_10799.field_56883, RESET_BUTTON, resetButtonX, buttonY, 14, 14);
                }
                if (this.isMouseOverScaleButton(mouseX, mouseY)) {
                    context.method_51438(class_310.method_1551().field_1772, class_2561.method_30163((String)"Scale"), mouseX, mouseY);
                    context.method_52706(class_10799.field_56883, SCALE_BUTTON_HIGHLIGHT, scaleButtonX, buttonY, 14, 14);
                    continue;
                }
                context.method_52706(class_10799.field_56883, SCALE_BUTTON, scaleButtonX, buttonY, 14, 14);
                continue;
            }
            if (this.hoveringElement != element) continue;
            context.method_25294(rect.x() - 2, rect.y() - 2, rect.endX() + 2, rect.endY() + 2, 0x44DADADA);
        }
        if (this.dragging && this.selectedElement != null) {
            HudConfigManager.Rect dragRect = this.configManager.getUsedRectOfElement(this.selectedElement);
            int offsetX = (int)((double)mouseX - this.clickOffsetX);
            int offsetY = (int)((double)mouseY - this.clickOffsetY);
            context.method_25294(offsetX - 2, offsetY - 2, offsetX + dragRect.width() + 2, offsetY + dragRect.height() + 2, 0x44DADADA);
        }
    }

    private boolean isMouseOverElement(class_2960 element, double mouseX, double mouseY) {
        HudConfigManager.Rect rect = this.configManager.getUsedRectOfElement(element);
        return ScreenHelper.isPointWithinBounds(rect.x(), rect.y(), rect.width(), rect.height(), mouseX, mouseY);
    }

    private boolean isMouseOverScaleButton(double mouseX, double mouseY) {
        if (this.selectedElement == null) {
            return false;
        }
        HudConfigManager.Rect usedRect = this.configManager.getUsedRectOfElement(this.selectedElement);
        int buttonX = usedRect.endX() - 46;
        int buttonY = this.field_22790 - usedRect.endY() > 18 ? usedRect.endY() + 4 : usedRect.y() - 14 - 4;
        return ScreenHelper.isPointWithinBounds(buttonX, buttonY, 14, 14, mouseX, mouseY);
    }

    private boolean isMouseOverShowButton(double mouseX, double mouseY) {
        if (this.selectedElement == null) {
            return false;
        }
        HudConfigManager.Rect usedRect = this.configManager.getUsedRectOfElement(this.selectedElement);
        int buttonX = usedRect.endX() - 30;
        int buttonY = this.field_22790 - usedRect.endY() > 18 ? usedRect.endY() + 4 : usedRect.y() - 14 - 4;
        return ScreenHelper.isPointWithinBounds(buttonX, buttonY, 14, 14, mouseX, mouseY);
    }

    private boolean isMouseOverResetButton(double mouseX, double mouseY) {
        if (this.selectedElement == null) {
            return false;
        }
        HudConfigManager.Rect usedRect = this.configManager.getUsedRectOfElement(this.selectedElement);
        int buttonX = usedRect.endX() - 14;
        int buttonY = this.field_22790 - usedRect.endY() > 18 ? usedRect.endY() + 4 : usedRect.y() - 14 - 4;
        return ScreenHelper.isPointWithinBounds(buttonX, buttonY, 14, 14, mouseX, mouseY);
    }

    private long getGameWindowId() {
        return this.field_22787.method_22683().method_4490();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return super.method_25402(mouseX, mouseY, button);
        }
        if (this.isMouseOverShowButton(mouseX, mouseY)) {
            this.configManager.toggleElementVisible(this.selectedElement);
            return true;
        }
        if (this.isMouseOverResetButton(mouseX, mouseY)) {
            this.configManager.resetElement(this.selectedElement);
            return true;
        }
        if (this.isMouseOverScaleButton(mouseX, mouseY)) {
            int scale = (int)this.configManager.getHudPlacement(this.selectedElement).scaleX();
            scale = 1 + (scale - 1 + 1) % 4;
            this.configManager.setElementScale(this.selectedElement, scale, scale);
            return true;
        }
        for (class_2960 element : this.elements) {
            if (!this.isMouseOverElement(element, mouseX, mouseY)) continue;
            if (this.selectedElement == element) {
                this.dragging = true;
                HudConfigManager.Rect selectedRect = this.configManager.getUsedRectOfElement(element);
                this.clickOffsetX = mouseX - (double)selectedRect.x();
                this.clickOffsetY = mouseY - (double)selectedRect.y();
            } else if (this.selectedElement != element) {
                this.selectedElement = element;
                GLFW.glfwSetCursor((long)this.getGameWindowId(), (long)MOVE_CURSOR);
            }
            return true;
        }
        this.selectedElement = null;
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.selectedElement != null && this.dragging) {
            this.configManager.moveElement(this.selectedElement, (int)(mouseX - this.clickOffsetX), (int)(mouseY - this.clickOffsetY), this.field_22789, this.field_22790);
            this.dragging = false;
            this.clickOffsetX = 0.0;
            this.clickOffsetY = 0.0;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_16014(double mouseX, double mouseY) {
        for (class_2960 element : this.elements) {
            if (!this.isMouseOverElement(element, mouseX, mouseY)) continue;
            if (element == this.selectedElement) {
                GLFW.glfwSetCursor((long)this.getGameWindowId(), (long)MOVE_CURSOR);
            }
            this.hoveringElement = element;
            if (this.hoveringElement != this.selectedElement) {
                GLFW.glfwSetCursor((long)this.getGameWindowId(), (long)0L);
            }
            return;
        }
        if (this.hoveringElement != null) {
            this.hoveringElement = null;
            GLFW.glfwSetCursor((long)this.getGameWindowId(), (long)0L);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.selectedElement == null) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        if (keyCode == 87 || keyCode == 265) {
            HudConfigManager.Rect rect = this.configManager.getUsedRectOfElement(this.selectedElement);
            this.configManager.moveElement(this.selectedElement, rect.x(), rect.y() - 1, this.field_22789, this.field_22790);
        } else if (keyCode == 83 || keyCode == 264) {
            HudConfigManager.Rect rect = this.configManager.getUsedRectOfElement(this.selectedElement);
            this.configManager.moveElement(this.selectedElement, rect.x(), rect.y() + 1, this.field_22789, this.field_22790);
        } else if (keyCode == 65 || keyCode == 263) {
            HudConfigManager.Rect rect = this.configManager.getUsedRectOfElement(this.selectedElement);
            this.configManager.moveElement(this.selectedElement, rect.x() - 1, rect.y(), this.field_22789, this.field_22790);
        } else if (keyCode == 68 || keyCode == 262) {
            HudConfigManager.Rect rect = this.configManager.getUsedRectOfElement(this.selectedElement);
            this.configManager.moveElement(this.selectedElement, rect.x() + 1, rect.y(), this.field_22789, this.field_22790);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }
}

