/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloadedcompanion.client.hud;

import com.google.common.collect.ImmutableList;
import io.github.steaf23.bingoreloadedcompanion.card.BingoCard;
import io.github.steaf23.bingoreloadedcompanion.card.HotswapTaskHolder;
import io.github.steaf23.bingoreloadedcompanion.card.Task;
import io.github.steaf23.bingoreloadedcompanion.client.ExtraMath;
import io.github.steaf23.bingoreloadedcompanion.client.TextColorGradient;
import io.github.steaf23.bingoreloadedcompanion.client.hud.HudConfigManager;
import io.github.steaf23.bingoreloadedcompanion.client.hud.HudPlacement;
import io.github.steaf23.bingoreloadedcompanion.client.hud.HudTimer;
import io.github.steaf23.bingoreloadedcompanion.client.util.ScreenHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElement;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5251;
import net.minecraft.class_9779;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

@Environment(value=EnvType.CLIENT)
public class BingoCardHudElement
implements HudElement {
    private static final class_2960 GAMEMODE_LOGOS = class_2960.method_60654((String)"bingoreloadedcompanion:textures/gui/gamemode_logos.png");
    private static final class_2960 TASK_BACKGROUND = class_2960.method_60654((String)"bingoreloadedcompanion:textures/gui/sprites/task_background.png");
    private static final class_2960 TASK_BACKGROUND_ADVANCEMENT = class_2960.method_60654((String)"bingoreloadedcompanion:textures/gui/sprites/task_background_advancement.png");
    private static final class_2960 TASK_BACKGROUND_STATISTIC = class_2960.method_60654((String)"bingoreloadedcompanion:textures/gui/sprites/task_background_statistic.png");
    private static final class_2960 TASK_BACKGROUND_HOTSWAP = class_2960.method_60654((String)"bingoreloadedcompanion:textures/gui/sprites/task_background_hotswap.png");
    private static final class_2960 TASK_ADVANCEMENT_ICON = class_2960.method_60654((String)"bingoreloadedcompanion:textures/gui/sprites/task_advancement_icon.png");
    private static final class_2960 TASK_STATISTIC_ICON = class_2960.method_60654((String)"bingoreloadedcompanion:textures/gui/sprites/task_statistic_icon.png");
    private static final class_2960 TASK_COMPLETED_OVERLAY = class_2960.method_60654((String)"bingoreloadedcompanion:textures/gui/sprites/task_completed_overlay.png");
    private static final Integer RECOVERY_COLOR = ((class_5251)class_5251.method_27719((String)"#5cb1ff").getOrThrow()).method_27716();
    private static final TextColorGradient HOTSWAP_EXPIRATION_GRADIENT = new TextColorGradient().addColor((class_5251)class_5251.method_27719((String)"#ffffff").getOrThrow(), 0.0f).addColor((class_5251)class_5251.method_27719((String)"#3cff00").getOrThrow(), 0.05f).addColor((class_5251)class_5251.method_27719((String)"#ffd200").getOrThrow(), 0.25f).addColor((class_5251)class_5251.method_27719((String)"#e85e21").getOrThrow(), 0.5f).addColor((class_5251)class_5251.method_27719((String)"#750e0e").getOrThrow(), 0.8f).addColor(class_5251.method_27718((class_124)class_124.field_1063), 1.0f);
    private static final int ITEM_SIZE = 16;
    private final HudConfigManager hudConfig;
    @Nullable
    private BingoCard card;
    @Nullable
    private ImmutableList<HotswapTaskHolder> hotswapTaskHolders;
    private long lastHotswapUpdateTick = 0L;
    boolean visible = true;
    boolean renderingInScreen = false;
    private static final class_2960 TASKS_ELEMENT = class_2960.method_60654((String)"bingoreloadedcompanion:hud/bingocard/tasks");
    private static final class_2960 GAMEMODE_ELEMENT = class_2960.method_60654((String)"bingoreloadedcompanion:hud/bingocard/gamemode");

    public BingoCardHudElement(HudConfigManager hudConfig) {
        this.hudConfig = hudConfig;
    }

    public void setCard(@Nullable BingoCard card) {
        this.card = card;
        if (card == null) {
            this.hotswapTaskHolders = null;
        }
    }

    public void setVisible(boolean visible) {
        if (this.card == null) {
            return;
        }
        this.visible = visible;
    }

    public boolean isHidden() {
        return !this.visible;
    }

    public void setHotswapHolders(ImmutableList<HotswapTaskHolder> holders) {
        this.hotswapTaskHolders = holders;
        this.lastHotswapUpdateTick = HudTimer.getTicks();
    }

    public void renderFromScreen(class_332 drawContext, float tickDelta) {
        if (!this.renderingInScreen) {
            return;
        }
        this.renderElement(drawContext, tickDelta);
    }

    public void render(class_332 drawContext, class_9779 renderTickCounter) {
        if (this.renderingInScreen) {
            return;
        }
        this.renderElement(drawContext, renderTickCounter.method_60636());
    }

    public void setRenderingInScreen(boolean renderingInScreen) {
        this.renderingInScreen = renderingInScreen;
    }

    public void renderElement(class_332 drawContext, float tickDelta) {
        HudPlacement bannerPlacement;
        if (this.card == null || this.isHidden()) {
            return;
        }
        HudPlacement tasksPlacement = this.hudConfig.getHudPlacement(TASKS_ELEMENT);
        if (tasksPlacement.visible()) {
            this.renderTasks(drawContext, tickDelta);
        }
        if ((bannerPlacement = this.hudConfig.getHudPlacement(GAMEMODE_ELEMENT)).visible()) {
            this.renderBanner(drawContext, tickDelta);
        }
    }

    private void renderTasks(class_332 context, float tickDelta) {
        HudConfigManager.Rect tasksRect = this.hudConfig.getUsedRectOfElement(TASKS_ELEMENT);
        HudPlacement placement = this.hudConfig.getHudPlacement(TASKS_ELEMENT);
        float scaleFactorX = 1.0f / (float)class_310.method_1551().method_22683().method_4495() * placement.scaleX();
        float scaleFactorY = 1.0f / (float)class_310.method_1551().method_22683().method_4495() * placement.scaleY();
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.translate((float)tasksRect.x(), (float)tasksRect.y());
        matrices.scale(scaleFactorX, scaleFactorY);
        matrices.translate((float)(-tasksRect.x()), (float)(-tasksRect.y()));
        if (this.card.tasks().isEmpty()) {
            return;
        }
        int spacing = 6;
        int startOffsetX = tasksRect.x();
        int startOffsetY = tasksRect.y();
        int taskIdx = 0;
        for (int y = 0; y < this.card.size(); ++y) {
            for (int x = 0; x < this.card.size(); ++x) {
                int xStart = startOffsetX + spacing * x + x * 16;
                int yStart = startOffsetY + spacing * y + y * 16;
                if (this.card.size() == 3) {
                    xStart += spacing + 16;
                    yStart += spacing + 16;
                }
                Task task = this.card.tasks().get(taskIdx);
                HotswapTaskHolder holder = null;
                if (this.hotswapTaskHolders != null && taskIdx < this.hotswapTaskHolders.size()) {
                    holder = (HotswapTaskHolder)this.hotswapTaskHolders.get(taskIdx);
                }
                this.renderTask(context, task, xStart, yStart, holder, tickDelta);
                ++taskIdx;
            }
        }
        matrices.popMatrix();
    }

    private void renderBanner(class_332 context, float tickDelta) {
        HudConfigManager.Rect gamemodeRect = this.hudConfig.getUsedRectOfElement(GAMEMODE_ELEMENT);
        HudPlacement placement = this.hudConfig.getHudPlacement(GAMEMODE_ELEMENT);
        float scaleFactorX = 1.0f / (float)class_310.method_1551().method_22683().method_4495() * placement.scaleX();
        float scaleFactorY = 1.0f / (float)class_310.method_1551().method_22683().method_4495() * placement.scaleY();
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.translate((float)gamemodeRect.x(), (float)gamemodeRect.y());
        matrices.scale(scaleFactorX, scaleFactorY);
        matrices.translate((float)(-gamemodeRect.x()), (float)(-gamemodeRect.y()));
        int textureIndex = this.card.mode().getIndex();
        int gamemodeBannerSizeX = 128;
        int gamemodeBannerSizeY = 32;
        int gamemodeStartX = gamemodeRect.x();
        int gamemodeStartY = gamemodeRect.y();
        context.method_25302(class_10799.field_56883, GAMEMODE_LOGOS, gamemodeStartX, gamemodeStartY, 0.0f, (float)(textureIndex * gamemodeBannerSizeY), gamemodeBannerSizeX, gamemodeBannerSizeY, gamemodeBannerSizeX, gamemodeBannerSizeY, 128, 128);
        matrices.popMatrix();
    }

    protected void renderTask(class_332 drawContext, @NotNull Task task, int x, int y, @Nullable HotswapTaskHolder hotswapContext, float delta) {
        String taskType;
        boolean hotswapRecovering = hotswapContext != null && hotswapContext.recovering();
        boolean hotswapExpires = hotswapContext != null && hotswapContext.expires();
        int borderX = x;
        int borderY = y;
        int taskX = x + 2;
        int taskY = y + 2;
        Task.TaskCompletion completion = task.completion();
        if (hotswapRecovering) {
            float predictedTime = (float)hotswapContext.currentTimeSeconds() - (float)(HudTimer.getTicks() - this.lastHotswapUpdateTick) / 20.0f + delta;
            int color = ScreenHelper.addAlphaToColor(RECOVERY_COLOR, 255);
            this.renderHotswapBackground(drawContext, (int)hotswapContext.totalTimeSeconds(), predictedTime, borderX, borderY, color, false);
            return;
        }
        if (hotswapExpires) {
            float predictedTime = (float)hotswapContext.currentTimeSeconds() - (float)(HudTimer.getTicks() - this.lastHotswapUpdateTick) / 20.0f + delta;
            int color = ScreenHelper.addAlphaToColor(HOTSWAP_EXPIRATION_GRADIENT.sample(1.0f - predictedTime / (float)hotswapContext.totalTimeSeconds()).method_27716(), 200);
            this.renderHotswapBackground(drawContext, (int)hotswapContext.totalTimeSeconds(), predictedTime, borderX, borderY, color, true);
        } else {
            String taskType2;
            class_2960 backgroundTexture = switch (taskType2 = task.taskType().toString()) {
                case "bingoreloaded:advancement" -> TASK_BACKGROUND_ADVANCEMENT;
                case "bingoreloaded:statistic" -> TASK_BACKGROUND_STATISTIC;
                default -> TASK_BACKGROUND;
            };
            drawContext.method_25291(class_10799.field_56883, backgroundTexture, borderX, borderY, 0.0f, 0.0f, 21, 21, 21, 21, ScreenHelper.addAlphaToColor(0xFFFFFF, 128));
        }
        if (completion.completed()) {
            drawContext.method_25291(class_10799.field_56883, TASK_COMPLETED_OVERLAY, borderX, borderY, 0.0f, 0.0f, 21, 21, 21, 21, ScreenHelper.addAlphaToColor(completion.teamColor(), 255));
        }
        class_1799 stack = new class_1799((class_1935)task.itemType(), task.requiredAmount());
        drawContext.method_51427(stack, taskX, taskY);
        switch (taskType = task.taskType().toString()) {
            case "bingoreloaded:advancement": {
                drawContext.method_25290(class_10799.field_56883, TASK_ADVANCEMENT_ICON, borderX, borderY, 0.0f, 0.0f, 21, 24, 21, 24);
                break;
            }
            case "bingoreloaded:statistic": {
                drawContext.method_25290(class_10799.field_56883, TASK_STATISTIC_ICON, borderX, borderY, 0.0f, 0.0f, 21, 24, 21, 24);
            }
        }
        class_327 textRenderer = class_310.method_1551().field_1772;
        drawContext.method_51431(textRenderer, stack, taskX, taskY);
    }

    private void renderHotswapBackground(class_332 context, float startTime, float currentTime, int x, int y, int color, boolean reverse) {
        int frameWidth = 21;
        int frameHeight = 21;
        int totalFrames = 62;
        int currentFrame = (int)ExtraMath.map(currentTime, 0.0f, startTime, 0.0f, totalFrames);
        currentFrame = reverse ? totalFrames - currentFrame : currentFrame;
        context.method_25291(class_10799.field_56883, TASK_BACKGROUND_HOTSWAP, x, y, (float)(currentFrame * frameWidth), (float)frameHeight, frameWidth, frameHeight, frameWidth * totalFrames, frameHeight, color);
    }
}

