/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloadedcompanion.client.hud;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.steaf23.bingoreloadedcompanion.client.hud.ConfigurableHudRegistry;
import io.github.steaf23.bingoreloadedcompanion.client.hud.HudConfig;
import io.github.steaf23.bingoreloadedcompanion.client.hud.HudConfigSerializer;
import io.github.steaf23.bingoreloadedcompanion.client.hud.HudInfo;
import io.github.steaf23.bingoreloadedcompanion.client.hud.HudPlacement;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class HudConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(HudConfig.class, (Object)new HudConfigSerializer()).create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("bingoreloadedcompanion.json");
    private Map<class_2960, HudPlacement> elementPlaces = new HashMap<class_2960, HudPlacement>();

    public void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                this.elementPlaces = ((HudConfig)GSON.fromJson((Reader)reader, HudConfig.class)).elements();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.save();
        }
    }

    public void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            GSON.toJson((Object)new HudConfig(this.elementPlaces), (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void moveElement(class_2960 id, int toX, int toY) {
        HudPlacement place = this.getHudPlacement(id);
        this.elementPlaces.put(id, place.move(toX, toY));
    }

    public void moveElement(class_2960 id, int toX, int toY, int borderX, int borderY) {
        HudPlacement place = this.getHudPlacement(id);
        Rect usedRect = this.getUsedRectOfElement(id);
        this.elementPlaces.put(id, place.move(Math.clamp((long)toX, 0, borderX - usedRect.width()), Math.clamp((long)toY, 0, borderY - usedRect.height())));
    }

    public void setElementVisible(class_2960 id, boolean visible) {
        HudPlacement placement = this.getHudPlacement(id);
        this.elementPlaces.put(id, placement.setVisible(visible));
    }

    public void toggleElementVisible(class_2960 id) {
        HudPlacement placement;
        this.elementPlaces.put(id, placement.setVisible(!(placement = this.getHudPlacement(id)).visible()));
    }

    public void setElementScale(class_2960 id, float scaleX, float scaleY) {
        HudPlacement placement = this.getHudPlacement(id);
        this.elementPlaces.put(id, placement.setScale(scaleX, scaleY));
    }

    public void resetElement(class_2960 id) {
        this.elementPlaces.remove(id);
    }

    @NotNull
    public Rect getUsedRectOfElement(class_2960 id) {
        HudInfo info = ConfigurableHudRegistry.getInfo(id);
        HudPlacement placement = this.getHudPlacement(id);
        if (info == null) {
            return new Rect(0, 0, 0, 0);
        }
        return new Rect(placement.x(), placement.y(), (int)((double)info.minSizeX() * (1.0 / (double)class_310.method_1551().method_22683().method_4495() * (double)placement.scaleX())), (int)((double)info.minSizeY() * (1.0 / (double)class_310.method_1551().method_22683().method_4495() * (double)placement.scaleY())));
    }

    @NotNull
    public HudPlacement getHudPlacement(class_2960 id) {
        if (this.elementPlaces.containsKey(id)) {
            return this.elementPlaces.get(id);
        }
        HudPlacement def = ConfigurableHudRegistry.getDefaultPlacement(id);
        return def == null ? new HudPlacement(0, 0, true, 3.0f, 3.0f) : def;
    }

    @Environment(value=EnvType.CLIENT)
    public record Rect(int x, int y, int width, int height) {
        public int endX() {
            return this.x + this.width;
        }

        public int endY() {
            return this.y + this.height;
        }
    }
}

