/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloadedcompanion.client.creator;

import io.github.steaf23.bingoreloadedcompanion.card.taskslot.AdvancementTask;
import io.github.steaf23.bingoreloadedcompanion.card.taskslot.ItemTask;
import io.github.steaf23.bingoreloadedcompanion.card.taskslot.TaskSlot;
import io.github.steaf23.bingoreloadedcompanion.client.TaskTooltipComponent;
import io.github.steaf23.bingoreloadedcompanion.client.creator.ScreenTab;
import io.github.steaf23.bingoreloadedcompanion.client.util.ScreenHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import net.minecraft.class_8001;

@Environment(value=EnvType.CLIENT)
public class BingoCardTaskListScreen
extends class_437 {
    private static final TaskTab[] TABS = new TaskTab[]{new TaskTab(0, class_1802.field_8279, class_2561.method_30163((String)"Items")), new TaskTab(1, class_1802.field_8449, class_2561.method_30163((String)"Advancements")), new TaskTab(2, class_1802.field_18674, class_2561.method_30163((String)"Statistics"))};
    private static final class_2960 MENU = class_2960.method_60654((String)"bingoreloadedcompanion:textures/gui/task_list.png");
    private static final class_2960 SELECTED_SLOT = class_2960.method_60654((String)"bingoreloadedcompanion:selected_slot");
    private static final class_2960 HIGHER_COUNT_BUTTON = class_2960.method_60654((String)"bingoreloadedcompanion:higher_count");
    private static final class_2960 LOWER_COUNT_BUTTON = class_2960.method_60654((String)"bingoreloadedcompanion:lower_count");
    private static final class_2960 FILTER_EMPTY = class_2960.method_60654((String)"bingoreloadedcompanion:filter_empty");
    private static final class_2960 TAB_SELECTED = class_2960.method_60656((String)"container/creative_inventory/tab_top_selected_2");
    private static final class_2960 TAB_UNSELECTED = class_2960.method_60656((String)"container/creative_inventory/tab_top_unselected_2");
    private static final class_2960 SCROLLER = class_2960.method_60656((String)"container/creative_inventory/scroller");
    private static final class_2960 SCROLLER_DISABLED = class_2960.method_60656((String)"container/creative_inventory/scroller_disabled");
    private static final int MENU_WIDTH = 222;
    private static final int MENU_HEIGHT = 148;
    private static final int TAB_WIDTH = 26;
    private static final int TAB_HEIGHT = 32;
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    private static final int SCROLL_HEIGHT = 118;
    private static final int SCROLL_X = 202;
    private static final int SCROLL_Y = 20;
    private static final int SLOT_WIDTH = 24;
    private static final int SLOT_HEIGHT = 24;
    private static final int SLOT_START_X = 7;
    private static final int SLOT_START_Y = 19;
    private static final int BUTTON_WIDTH = 26;
    private static final int BUTTON_HEIGHT = 26;
    private TaskTab selectedTab;
    private class_342 filterField;
    private int scrollStep = -1;
    private final Map<class_2960, TaskSlot> selectedTasks = new HashMap<class_2960, TaskSlot>();
    private List<? extends TaskSlot> filteredItemTasks;
    private List<? extends TaskSlot> visibleTasks;
    private List<ScreenTab> tabs;
    private boolean scrolling = false;

    public BingoCardTaskListScreen(class_2561 title, List<? extends TaskSlot> tasks) {
        super(title);
        for (TaskSlot taskSlot : tasks) {
            this.selectedTasks.put(taskSlot.id(), taskSlot);
        }
        this.filteredItemTasks = new ArrayList<TaskSlot>();
        this.visibleTasks = new ArrayList<TaskSlot>();
    }

    protected void method_25426() {
        this.selectedTab = TABS[0];
        int startX = this.menuStartX();
        int startY = this.menuStartY();
        this.filterField = new class_342(class_310.method_1551().field_1772, startX + 114, startY + 4, 85, 14, class_2561.method_30163((String)""));
        this.filterField.method_1858(true);
        this.filterField.method_1862(true);
        this.filterField.method_1856(false);
        this.filterField.method_25365(true);
        this.method_37063((class_364)this.filterField);
        this.setScrollStep(0);
        this.applyFilter();
    }

    public boolean method_25421() {
        return false;
    }

    private void setScrollStep(int newStep) {
        if (this.scrollStep == newStep) {
            return;
        }
        this.scrollStep = Math.clamp((long)newStep, 0, this.getOverflowRows());
        this.updateVisibleTasks();
    }

    private void setTaskCount(TaskSlot task, int newCount) {
        class_2960 id = task.id();
        if (newCount > 0) {
            this.selectedTasks.put(id, task.copyWithCount(newCount));
        } else {
            this.selectedTasks.remove(id);
        }
    }

    private void applyFilter() {
        String text = this.filterField.method_1882().toLowerCase().replace(" ", "_");
        List<Object> tasks = switch (this.selectedTab.index) {
            case 0 -> this.allItemTasks();
            case 1 -> this.allAdvancementTasks();
            case 2 -> this.allStatisticTasks();
            default -> List.of();
        };
        this.filteredItemTasks = tasks.stream().filter(t -> t.id().toString().contains(text)).toList();
        this.updateVisibleTasks();
    }

    private void updateVisibleTasks() {
        int startIndex = this.scrollStep * 8;
        this.visibleTasks = this.filteredItemTasks.isEmpty() ? List.of() : this.filteredItemTasks.subList(startIndex, Math.min(startIndex + 40, this.filteredItemTasks.size() - 1));
    }

    private int getOverflowRows() {
        return Math.max(0, this.filteredItemTasks.size() / 8 - 4);
    }

    private List<? extends TaskSlot> allItemTasks() {
        return class_7923.field_41178.method_10220().map(item -> new ItemTask(class_7923.field_41178.method_10221(item), 0)).toList().subList(1, class_7923.field_41178.method_10204() - 1);
    }

    private List<? extends TaskSlot> allAdvancementTasks() {
        return class_310.method_1551().method_1562().method_2869().method_53814().method_53693().stream().map(placedAdv -> new AdvancementTask(placedAdv.method_53649(), false)).toList();
    }

    private List<? extends TaskSlot> allStatisticTasks() {
        return List.of();
    }

    private void switchTab(TaskTab newTab) {
        this.selectedTab = newTab;
        this.filterField.method_1852("");
        this.applyFilter();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        String oldFilter = this.filterField.method_1882();
        boolean result = this.filterField.method_25404(keyCode, scanCode, modifiers);
        if (!oldFilter.equals(this.filterField.method_1882())) {
            this.applyFilter();
        }
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return result;
    }

    public boolean method_25400(char chr, int modifiers) {
        String oldFilter = this.filterField.method_1882();
        boolean result = this.filterField.method_25400(chr, modifiers);
        if (!oldFilter.equals(this.filterField.method_1882())) {
            this.applyFilter();
        }
        if (super.method_25400(chr, modifiers)) {
            return true;
        }
        return result;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        super.method_25394(context, mouseX, mouseY, deltaTicks);
        int startX = this.menuStartX();
        int startY = this.menuStartY();
        int firstTabX = this.firstTabX();
        int tabStartY = this.tabStartY();
        for (TaskTab tab : TABS) {
            if (tab.index == this.selectedTab.index) continue;
            context.method_52706(class_10799.field_56883, TAB_UNSELECTED, firstTabX + this.getTabStartX(tab), tabStartY, 26, 32);
        }
        context.method_25290(class_10799.field_56883, MENU, startX, startY, 0.0f, 0.0f, 256, 256, 256, 256);
        context.method_52706(class_10799.field_56883, TAB_SELECTED, firstTabX + this.getTabStartX(this.selectedTab), tabStartY, 26, 32);
        for (TaskTab tab : TABS) {
            context.method_51427(tab.icon.method_7854(), firstTabX + this.getTabStartX(tab) + 5, tabStartY + 8);
        }
        context.method_51439(class_310.method_1551().field_1772, this.selectedTab.name(), startX + 8, startY + 6, -12566464, false);
        if (this.filteredItemTasks.size() > 40) {
            int scrollRange = 103;
            int scrollerHeight = this.scrollStep * scrollRange / this.getOverflowRows();
            context.method_52706(class_10799.field_56883, SCROLLER, startX + 202, startY + 20 + scrollerHeight, 12, 15);
        } else {
            context.method_52706(class_10799.field_56883, SCROLLER_DISABLED, startX + 202, startY + 20, 12, 15);
        }
        int slotStartX = startX + 7;
        int slotStartY = startY + 19;
        int hoveredIndex = -1;
        TaskSlot hoveredTask = null;
        int index = 0;
        for (TaskSlot taskSlot : this.visibleTasks) {
            TaskSlot task = taskSlot;
            class_2960 id = task.id();
            if (this.selectedTasks.containsKey(id)) {
                task = this.selectedTasks.get(id);
            }
            int slotX = index % 8;
            int slotY = index / 8;
            int x = slotStartX + slotX * 24 + 4;
            int y = slotStartY + slotY * 24 + 4;
            if (task.completeCount() > 0) {
                context.method_52706(class_10799.field_56883, SELECTED_SLOT, x - 4, y - 4, 24, 24);
            }
            if (this.isMouseOverSlot(mouseX, mouseY, slotX, slotY)) {
                hoveredIndex = index;
                hoveredTask = task;
            } else {
                class_1799 stack = new class_1799((class_1935)task.item(), task.completeCount() == 0 ? 1 : task.completeCount());
                context.method_51427(stack, x, y);
                context.method_51432(this.field_22793, stack, x, y, task.completeCount() == 1 ? "1" : null);
            }
            ++index;
        }
        if (hoveredIndex != -1) {
            int xIndex = hoveredIndex % 8;
            int n = hoveredIndex / 8;
            int slotX = slotStartX + 24 * xIndex;
            int slotY = slotStartY + 24 * n;
            if (this.isMouseOnIncreaseCountButton(mouseX, mouseY, xIndex, n)) {
                context.method_52706(class_10799.field_56883, HIGHER_COUNT_BUTTON, slotX - 1, slotY - 1, 26, 26);
            } else {
                context.method_52706(class_10799.field_56883, LOWER_COUNT_BUTTON, slotX - 1, slotY - 1, 26, 26);
            }
            TaskTooltipComponent tooltipComponent = new TaskTooltipComponent(hoveredTask);
            context.method_51435(this.field_22793, List.of(tooltipComponent), slotX - tooltipComponent.method_32664(this.field_22793) / 2, slotY - tooltipComponent.method_32661(this.field_22793) + 9, class_8001.field_41687, null);
        }
        for (TaskTab tab : TABS) {
            if (!this.isMouseOverTab(mouseX, mouseY, tab)) continue;
            context.method_71276(tab.name, mouseX, mouseY);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        for (TaskTab tab : TABS) {
            if (!this.isMouseOverTab((int)mouseX, (int)mouseY, tab)) continue;
            if (tab.index != this.selectedTab.index) {
                this.switchTab(tab);
            }
            return true;
        }
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 8; ++x) {
                if (!this.isMouseOverSlot((int)mouseX, (int)mouseY, x, y)) continue;
                TaskSlot task = this.visibleTasks.get(y * 8 + x);
                class_2960 id = task.id();
                if (this.selectedTasks.containsKey(id)) {
                    task = this.selectedTasks.get(id);
                }
                if (this.isMouseOnIncreaseCountButton((int)mouseX, (int)mouseY, x, y)) {
                    this.setTaskCount(task, task.completeCount() + 1);
                    continue;
                }
                this.setTaskCount(task, task.completeCount() - 1);
            }
        }
        if (this.isMouseOverScrollbar((int)mouseX, (int)mouseY)) {
            this.scrolling = true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.scrolling) {
            return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        int min = this.menuStartY() + 20 + 7;
        int max = min + 118 - 15 - 7;
        int targetPixel = (int)mouseY;
        targetPixel = Math.clamp((long)targetPixel, min, max);
        this.setScrollStep((targetPixel -= min) * this.getOverflowRows() / (max - min));
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        this.setScrollStep(this.scrollStep - (int)Math.signum(verticalAmount));
        return true;
    }

    private int getTabStartX(TaskTab tab) {
        return 26 * tab.index + tab.index - 1;
    }

    private boolean isMouseOverTab(int mouseX, int mouseY, TaskTab tab) {
        return ScreenHelper.isPointWithinBounds(this.firstTabX() + this.getTabStartX(tab) + 4, this.tabStartY() + 4, 18, 24, mouseX, mouseY);
    }

    private boolean isMouseOverSlot(int mouseX, int mouseY, int slotX, int slotY) {
        return ScreenHelper.isPointWithinBounds(this.menuStartX() + 7 + 24 * slotX + 1, this.menuStartY() + 19 + 24 * slotY + 1, 22, 22, mouseX, mouseY);
    }

    private boolean isMouseOnIncreaseCountButton(int mouseX, int mouseY, int slotX, int slotY) {
        return ScreenHelper.isPointWithinBounds(this.menuStartX() + 7 + 24 * slotX + 1, this.menuStartY() + 19 + 24 * slotY, 22, 11, mouseX, mouseY);
    }

    private boolean isMouseOverScrollbar(int mouseX, int mouseY) {
        return ScreenHelper.isPointWithinBounds(this.menuStartX() + 202, this.menuStartY() + 20, 12, 118, mouseX, mouseY);
    }

    private int menuStartX() {
        return this.field_22789 / 2 - 111;
    }

    private int menuStartY() {
        return this.field_22790 / 2 - 74;
    }

    private int firstTabX() {
        return this.menuStartX() + 111 - (TABS.length * 26 + (TABS.length - 1)) / 2;
    }

    private int tabStartY() {
        return this.menuStartY() - 32 + 4;
    }

    @Environment(value=EnvType.CLIENT)
    private record TaskTab(int index, class_1792 icon, class_2561 name) {
    }
}

