/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloadedcompanion.client.hud;

import com.google.common.collect.ImmutableList;
import io.github.steaf23.bingoreloadedcompanion.card.BingoCard;
import io.github.steaf23.bingoreloadedcompanion.card.HotswapTaskHolder;
import io.github.steaf23.bingoreloadedcompanion.card.Task;
import io.github.steaf23.bingoreloadedcompanion.client.ExtraMath;
import io.github.steaf23.bingoreloadedcompanion.client.TextColorGradient;
import io.github.steaf23.bingoreloadedcompanion.client.hud.HudConfigManager;
import io.github.steaf23.bingoreloadedcompanion.client.hud.HudPlacement;
import io.github.steaf23.bingoreloadedcompanion.client.hud.HudTimer;
import io.github.steaf23.bingoreloadedcompanion.client.util.ScreenHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElement;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5251;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class BingoCardHudElement
implements HudElement {
    private static final class_2960 GAMEMODE_LOGOS = class_2960.method_60654((String)"bingoreloadedcompanion:textures/gui/gamemode_logos.png");
    private static final class_2960 SLOT_BACKGROUND = class_2960.method_60654((String)"bingoreloadedcompanion:textures/gui/sprites/card_slot.png");
    private static final class_2960 TIMER_ROUND = class_2960.method_60654((String)"bingoreloadedcompanion:textures/gui/sprites/timer.png");
    private static final class_2960 TIMER_SQUARE = class_2960.method_60654((String)"bingoreloadedcompanion:textures/gui/sprites/timer_square.png");
    private static final Integer ADVANCEMENT_COLOR = class_124.field_1060.method_532();
    private static final Integer STATISTIC_COLOR = class_124.field_1076.method_532();
    private static final Integer RECOVERY_COLOR = ((class_5251)class_5251.method_27719((String)"#5cb1ff").getOrThrow()).method_27716();
    private static final TextColorGradient HOTSWAP_EXPIRATION_GRADIENT = new TextColorGradient().addColor((class_5251)class_5251.method_27719((String)"#ffd200").getOrThrow(), 0.0f).addColor((class_5251)class_5251.method_27719((String)"#e85e21").getOrThrow(), 0.5f).addColor((class_5251)class_5251.method_27719((String)"#750e0e").getOrThrow(), 0.8f).addColor(class_5251.method_27718((class_124)class_124.field_1063), 1.0f);
    private static final int ITEM_SIZE = 16;
    private final HudConfigManager hudConfig;
    @Nullable
    private BingoCard card;
    @Nullable
    private ImmutableList<HotswapTaskHolder> hotswapTaskHolders;
    private long lastHotswapUpdateTick = 0L;
    boolean renderingInScreen = false;
    private static final class_2960 TASKS_ELEMENT = class_2960.method_60654((String)"bingoreloadedcompanion:hud/bingocard/tasks");
    private static final class_2960 GAMEMODE_ELEMENT = class_2960.method_60654((String)"bingoreloadedcompanion:hud/bingocard/gamemode");

    public BingoCardHudElement(HudConfigManager hudConfig) {
        this.hudConfig = hudConfig;
    }

    public void setCard(@Nullable BingoCard card) {
        this.card = card;
        if (card == null) {
            this.hotswapTaskHolders = null;
        }
    }

    public void setHotswapHolders(ImmutableList<HotswapTaskHolder> holders) {
        this.hotswapTaskHolders = holders;
        this.lastHotswapUpdateTick = HudTimer.getTicks();
    }

    public void renderFromScreen(class_332 drawContext, float tickDelta) {
        if (!this.renderingInScreen) {
            return;
        }
        this.renderElement(drawContext, tickDelta);
    }

    public void render(class_332 drawContext, class_9779 renderTickCounter) {
        if (this.renderingInScreen) {
            return;
        }
        this.renderElement(drawContext, renderTickCounter.method_60636());
    }

    public void setRenderingInScreen(boolean renderingInScreen) {
        this.renderingInScreen = renderingInScreen;
    }

    public void renderElement(class_332 drawContext, float tickDelta) {
        HudPlacement bannerPlacement;
        if (this.card == null) {
            return;
        }
        HudPlacement tasksPlacement = this.hudConfig.getHudPlacement(TASKS_ELEMENT);
        if (tasksPlacement.visible()) {
            this.renderTasks(drawContext, tickDelta);
        }
        if ((bannerPlacement = this.hudConfig.getHudPlacement(GAMEMODE_ELEMENT)).visible()) {
            this.renderBanner(drawContext, tickDelta);
        }
    }

    private void renderTasks(class_332 context, float tickDelta) {
        HudConfigManager.Rect tasksRect = this.hudConfig.getUsedRectOfElement(TASKS_ELEMENT);
        if (this.card.tasks().isEmpty()) {
            return;
        }
        int spacing = 3;
        int startOffsetX = tasksRect.x();
        int startOffsetY = tasksRect.y();
        int taskIdx = 0;
        for (int y = 0; y < this.card.size(); ++y) {
            for (int x = 0; x < this.card.size(); ++x) {
                int xStart = startOffsetX + spacing * x + x * 16;
                int yStart = startOffsetY + spacing * y + y * 16;
                if (this.card.size() == 3) {
                    xStart += spacing + 16;
                    yStart += spacing + 16;
                }
                Task task = this.card.tasks().get(taskIdx);
                HotswapTaskHolder holder = null;
                if (this.hotswapTaskHolders != null && taskIdx < this.hotswapTaskHolders.size()) {
                    holder = (HotswapTaskHolder)this.hotswapTaskHolders.get(taskIdx);
                }
                this.renderTask(context, task, xStart, yStart, holder, tickDelta);
                ++taskIdx;
            }
        }
    }

    private void renderBanner(class_332 context, float tickDelta) {
        HudConfigManager.Rect gamemodeRect = this.hudConfig.getUsedRectOfElement(GAMEMODE_ELEMENT);
        int textureIndex = this.card.mode().getIndex();
        int gamemodeBannerSizeX = 128;
        int gamemodeBannerSizeY = 32;
        int gamemodeStartX = gamemodeRect.x();
        int gamemodeStartY = gamemodeRect.y();
        context.method_25302(class_10799.field_56883, GAMEMODE_LOGOS, gamemodeStartX, gamemodeStartY, 0.0f, (float)(textureIndex * gamemodeBannerSizeY), gamemodeBannerSizeX, gamemodeBannerSizeY, gamemodeBannerSizeX, gamemodeBannerSizeY, 128, 128);
    }

    protected void renderTask(class_332 drawContext, Task task, int x, int y, @Nullable HotswapTaskHolder hotswapContext, float delta) {
        String taskType;
        boolean hotswapRecovering = hotswapContext != null && hotswapContext.recovering();
        boolean hotswapExpires = hotswapContext != null && hotswapContext.expires();
        Task.TaskCompletion completion = task.completion();
        if (completion.completed() && !hotswapRecovering) {
            drawContext.method_25291(class_10799.field_56883, SLOT_BACKGROUND, x, y, 0.0f, 0.0f, 17, 17, 17, 17, ScreenHelper.addAlphaToColor(completion.teamColor(), 200));
        } else {
            if (hotswapRecovering) {
                float predictedTime = (float)hotswapContext.currentTimeSeconds() - (float)(HudTimer.getTicks() - this.lastHotswapUpdateTick) / 20.0f + delta;
                int color = ScreenHelper.addAlphaToColor(RECOVERY_COLOR, 255);
                this.renderTimerRound(drawContext, (int)hotswapContext.totalTimeSeconds(), predictedTime, x, y, color, false);
                return;
            }
            if (hotswapExpires) {
                float predictedTime = (float)hotswapContext.currentTimeSeconds() - (float)(HudTimer.getTicks() - this.lastHotswapUpdateTick) / 20.0f + delta;
                int color = ScreenHelper.addAlphaToColor(HOTSWAP_EXPIRATION_GRADIENT.sample(1.0f - predictedTime / (float)hotswapContext.totalTimeSeconds()).method_27716(), 200);
                this.renderTimerSquare(drawContext, (int)hotswapContext.totalTimeSeconds(), predictedTime, x, y, color, true);
            } else {
                drawContext.method_25291(class_10799.field_56883, SLOT_BACKGROUND, x, y, 0.0f, 0.0f, 17, 17, 17, 17, -2013265920);
            }
        }
        class_1799 stack = new class_1799((class_1935)task.itemType(), task.requiredAmount());
        drawContext.method_51427(stack, x, y);
        int bannerColor = switch (taskType = task.taskType().toString()) {
            case "bingoreloaded:advancement" -> ScreenHelper.addAlphaToColor(ADVANCEMENT_COLOR, 255);
            case "bingoreloaded:statistic" -> ScreenHelper.addAlphaToColor(STATISTIC_COLOR, 255);
            default -> 0;
        };
        int bannerStartX = x - 1;
        int bannerStartY = y + 12;
        drawContext.method_25294(bannerStartX, bannerStartY, bannerStartX + 16 + 2, bannerStartY + 4, bannerColor);
        class_327 textRenderer = class_310.method_1551().field_1772;
        drawContext.method_51431(textRenderer, stack, x, y);
    }

    private void renderTimerRound(class_332 context, float startTime, float currentTime, int x, int y, int color, boolean reverse) {
        this.renderTimer(TIMER_ROUND, context, startTime, currentTime, x, y, color, reverse);
    }

    private void renderTimerSquare(class_332 context, float startTime, float currentTime, int x, int y, int color, boolean reverse) {
        this.renderTimer(TIMER_SQUARE, context, startTime, currentTime, x, y, color, reverse);
    }

    private void renderTimer(class_2960 type, class_332 context, float startTime, float currentTime, int x, int y, int color, boolean reverse) {
        int frameSize = 17;
        int frame = (int)ExtraMath.map(currentTime, 0.0f, startTime, 0.0f, 41.0f);
        frame = reverse ? 41 - frame : frame;
        context.method_25291(class_10799.field_56883, type, x, y, (float)(frame * frameSize), (float)frameSize, frameSize, frameSize, frameSize * 41, frameSize, color);
    }
}

