/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.item.SupportCardItem;
import net.tracen.umapyoi.item.UmaSoulItem;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.item.data.DataLocation;
import net.tracen.umapyoi.registry.UmaFactorRegistry;
import net.tracen.umapyoi.registry.UmaSkillRegistry;
import net.tracen.umapyoi.registry.factors.FactorType;
import net.tracen.umapyoi.registry.factors.UmaFactor;
import net.tracen.umapyoi.registry.factors.UmaFactorStack;
import net.tracen.umapyoi.registry.training.card.SupportCard;
import net.tracen.umapyoi.registry.umadata.UmaData;
import net.tracen.umapyoi.utils.UmaFactorUtils;
import net.tracen.umapyoi.utils.UmaSoulUtils;

public class UmapyoiCreativeGroup {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"umapyoi");
    public static final Holder<CreativeModeTab> UMAPYOI_ITEMS = CREATIVE_MODE_TABS.register("umapyoi", () -> CreativeModeTab.builder().icon(() -> ((Item)((Item)ItemRegistry.HACHIMI_MID.get())).getDefaultInstance()).title((Component)Component.translatable((String)"itemGroup.umapyoi")).displayItems((features, output) -> {
        features.holders();
        ItemRegistry.ITEMS.getEntries().forEach(item -> {
            if (item == ItemRegistry.UMA_FACTOR_ITEM) {
                UmapyoiCreativeGroup.fillFactorContainer(output);
                return;
            }
            if (item == ItemRegistry.UMA_SOUL) {
                UmapyoiCreativeGroup.fillUmaSoul(features, output);
                return;
            }
            if (item == ItemRegistry.SUPPORT_CARD) {
                UmapyoiCreativeGroup.fillSupportCard(features, output);
                return;
            }
            if (item == ItemRegistry.SKILL_BOOK) {
                UmapyoiCreativeGroup.fillSkillBook(output);
                return;
            }
            output.accept((ItemLike)item.get());
        });
    }).build());

    private static void fillFactorContainer(CreativeModeTab.Output output) {
        UmaFactorRegistry.REGISTRY.stream().forEach(factor -> {
            if (factor == UmaFactorRegistry.SKILL_FACTOR.get() || factor.getFactorType() == FactorType.UNIQUE) {
                return;
            }
            ArrayList stackList = Lists.newArrayList((Object[])new UmaFactorStack[]{new UmaFactorStack((UmaFactor)factor, 1)});
            ItemStack result = ((Item)ItemRegistry.UMA_FACTOR_ITEM.get()).getDefaultInstance();
            result.set(DataComponentsTypeRegistry.DATA_LOCATION, (Object)new DataLocation(UmaData.DEFAULT_UMA_ID));
            result.set(DataComponentsTypeRegistry.FACTOR_DATA, UmaFactorUtils.serializeData(stackList));
            output.accept(result);
        });
    }

    private static void fillUmaSoul(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        UmaSoulItem.sortedUmaDataList(parameters.holders()).forEach(entry -> {
            ItemStack initUmaSoul = UmaSoulUtils.initUmaSoul(((Item)ItemRegistry.UMA_SOUL.get()).getDefaultInstance(), entry.key().location(), (UmaData)entry.value());
            UmaSoulUtils.setPhysique(initUmaSoul, 5);
            output.accept(initUmaSoul);
        });
    }

    private static void fillSupportCard(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        SupportCardItem.sortedCardDataList(parameters.holders()).forEach(card -> {
            if (card.getKey().location().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"umapyoi", (String)"blank_card"))) {
                return;
            }
            ItemStack result = SupportCard.init(card.getKey().location(), (SupportCard)card.value());
            output.accept(result);
        });
    }

    private static void fillSkillBook(CreativeModeTab.Output output) {
        for (ResourceLocation skill : UmaSkillRegistry.REGISTRY.keySet()) {
            ItemStack result = ((Item)ItemRegistry.SKILL_BOOK.get()).getDefaultInstance();
            result.set(DataComponentsTypeRegistry.DATA_LOCATION, (Object)new DataLocation(skill));
            output.accept(result);
        }
    }
}

