/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.tracen.umapyoi.block.AbstractPedestalBlock;
import net.tracen.umapyoi.block.BlockRegistry;
import net.tracen.umapyoi.block.SilverSupportAlbumPedestalBlock;
import net.tracen.umapyoi.block.entity.BlockEntityRegistry;
import net.tracen.umapyoi.block.entity.SilverUmaPedestalBlockEntity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SilverUmaPedestalBlock
extends AbstractPedestalBlock {
    public static final MapCodec<SilverUmaPedestalBlock> CODEC = SilverUmaPedestalBlock.simpleCodec(p -> new SilverUmaPedestalBlock());

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public SilverUmaPedestalBlock() {
        super(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.STONE).noOcclusion());
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntityRegistry.SILVER_UMA_PEDESTAL.get()).create(pos, state);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity tileEntity;
        if (!level.isClientSide && (tileEntity = level.getBlockEntity(pos)) instanceof SilverUmaPedestalBlockEntity) {
            SilverUmaPedestalBlockEntity blockEntity = (SilverUmaPedestalBlockEntity)tileEntity;
            return this.interactBEWithoutItem(level, pos, player, blockEntity.isEmpty(), blockEntity.removeItem());
        }
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity tileEntity;
        if (!level.isClientSide && (tileEntity = level.getBlockEntity(pos)) instanceof SilverUmaPedestalBlockEntity) {
            SilverUmaPedestalBlockEntity blockEntity = (SilverUmaPedestalBlockEntity)tileEntity;
            return this.interactBEWithItem(stack, level, pos, player, hand, blockEntity, true);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tileEntity = worldIn.getBlockEntity(pos);
            if (tileEntity instanceof SilverUmaPedestalBlockEntity) {
                SilverUmaPedestalBlockEntity blockEntity = (SilverUmaPedestalBlockEntity)tileEntity;
                Containers.dropContents((Level)worldIn, (BlockPos)pos, blockEntity.getDroppableInventory());
                worldIn.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, worldIn, pos, newState, isMoving);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        if (level.isClientSide) {
            return SilverUmaPedestalBlock.createTickerHelper(blockEntity, (BlockEntityType)((BlockEntityType)BlockEntityRegistry.SILVER_UMA_PEDESTAL.get()), SilverUmaPedestalBlockEntity::animationTick);
        }
        return SilverUmaPedestalBlock.createTickerHelper(blockEntity, (BlockEntityType)((BlockEntityType)BlockEntityRegistry.SILVER_UMA_PEDESTAL.get()), SilverUmaPedestalBlockEntity::workingTick);
    }

    @Override
    protected void transformOnBook(Level level, BlockPos pos) {
        level.destroyBlock(pos, false);
        level.setBlock(pos, ((SilverSupportAlbumPedestalBlock)((Object)BlockRegistry.SILVER_SUPPORT_ALBUM_PEDESTAL.get())).defaultBlockState(), 3);
    }
}

