/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.tracen.umapyoi.block.BlockRegistry;
import net.tracen.umapyoi.block.StatuesUpperBlock;
import net.tracen.umapyoi.block.entity.BlockEntityRegistry;
import net.tracen.umapyoi.block.entity.ThreeGoddessBlockEntity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ThreeGoddessBlock
extends BaseEntityBlock {
    public static final MapCodec<ThreeGoddessBlock> CODEC = ThreeGoddessBlock.simpleCodec(p -> new ThreeGoddessBlock());
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public ThreeGoddessBlock() {
        super(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.POLISHED_ANDESITE).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pLevel.getBlockState(pPos.above()).is((Block)BlockRegistry.THREE_GODDESS_UPPER.get()) || pLevel.getBlockState(pPos.above()).isAir();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        pLevel.setBlock(pPos.above(), ((StatuesUpperBlock)((Object)BlockRegistry.THREE_GODDESS_UPPER.get())).defaultBlockState(), 3);
        super.onPlace(pState, pLevel, pPos, pOldState, pIsMoving);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntityRegistry.THREE_GODDESS.get()).create(pos, state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            BlockEntity tileEntity = level.getBlockEntity(pos);
            if (tileEntity instanceof ThreeGoddessBlockEntity) {
                ThreeGoddessBlockEntity blockEntity = (ThreeGoddessBlockEntity)tileEntity;
                player.openMenu((MenuProvider)blockEntity, pos);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tileEntity = worldIn.getBlockEntity(pos);
            if (tileEntity instanceof ThreeGoddessBlockEntity) {
                ThreeGoddessBlockEntity blockEntity = (ThreeGoddessBlockEntity)tileEntity;
                Containers.dropContents((Level)worldIn, (BlockPos)pos, blockEntity.getDroppableInventory());
                worldIn.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            if (worldIn.getBlockState(pos.above()).is((Block)BlockRegistry.THREE_GODDESS_UPPER.get())) {
                worldIn.removeBlock(pos.above(), false);
            }
            super.onRemove(state, worldIn, pos, newState, isMoving);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        if (level.isClientSide) {
            return ThreeGoddessBlock.createTickerHelper(blockEntity, (BlockEntityType)((BlockEntityType)BlockEntityRegistry.THREE_GODDESS.get()), ThreeGoddessBlockEntity::animationTick);
        }
        return ThreeGoddessBlock.createTickerHelper(blockEntity, (BlockEntityType)((BlockEntityType)BlockEntityRegistry.THREE_GODDESS.get()), ThreeGoddessBlockEntity::workingTick);
    }
}

