/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.client;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.utils.UmaSoulUtils;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MotivationOverlay
implements LayeredDraw.Layer {
    public static final MotivationOverlay INSTANCE = new MotivationOverlay();
    private final Minecraft minecraft = Minecraft.getInstance();
    private static final ResourceLocation HUD = ResourceLocation.fromNamespaceAndPath((String)"umapyoi", (String)"textures/gui/motivations.png");

    private MotivationOverlay() {
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker tracker) {
        if (!((Boolean)UmapyoiConfig.OVERLAY_SWITCH.get()).booleanValue()) {
            return;
        }
        int x = guiGraphics.guiWidth() / 2;
        int y = guiGraphics.guiHeight();
        LocalPlayer player = this.minecraft.player;
        if (player.isSpectator()) {
            return;
        }
        if (!UmapyoiAPI.getUmaSoul((LivingEntity)player).isEmpty()) {
            switch (UmaSoulUtils.getMotivation(UmapyoiAPI.getUmaSoul((LivingEntity)player))) {
                case BAD: {
                    guiGraphics.blit(HUD, x + 118, y - 37, 0.0f, 60.0f, 64, 14, 64, 96);
                    guiGraphics.drawString(this.minecraft.font, (Component)Component.translatable((String)"umapyoi.motivation.bad"), x + 132, y - 34, 0xFFFFFF);
                    break;
                }
                case DOWN: {
                    guiGraphics.blit(HUD, x + 118, y - 37, 0.0f, 45.0f, 64, 14, 64, 96);
                    guiGraphics.drawString(this.minecraft.font, (Component)Component.translatable((String)"umapyoi.motivation.down"), x + 132, y - 34, 0xFFFFFF);
                    break;
                }
                case NORMAL: {
                    guiGraphics.blit(HUD, x + 118, y - 37, 0.0f, 30.0f, 64, 14, 64, 96);
                    guiGraphics.drawString(this.minecraft.font, (Component)Component.translatable((String)"umapyoi.motivation.normal"), x + 132, y - 34, 0xFFFFFF);
                    break;
                }
                case GOOD: {
                    guiGraphics.blit(HUD, x + 118, y - 37, 0.0f, 15.0f, 64, 14, 64, 96);
                    guiGraphics.drawString(this.minecraft.font, (Component)Component.translatable((String)"umapyoi.motivation.good"), x + 132, y - 34, 0xFFFFFF);
                    break;
                }
                case PERFECT: {
                    guiGraphics.blit(HUD, x + 118, y - 37, 0.0f, 0.0f, 64, 14, 64, 96);
                    guiGraphics.drawString(this.minecraft.font, (Component)Component.translatable((String)"umapyoi.motivation.perfect"), x + 132, y - 34, 0xFFFFFF);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)UmaSoulUtils.getMotivation(UmapyoiAPI.getUmaSoul((LivingEntity)player))));
                }
            }
        }
    }
}

