/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.compat.jei;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;
import net.tracen.umapyoi.compat.jei.category.JEIDisassemblyCategory;
import net.tracen.umapyoi.compat.jei.category.JEIGachaCategory;
import net.tracen.umapyoi.compat.jei.recipes.JEISimpleRecipe;
import net.tracen.umapyoi.compat.jei.recipes.UmapyoiJEIRecipes;
import net.tracen.umapyoi.data.tag.UmapyoiItemTags;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.utils.GachaRanking;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final ResourceLocation PLUGIN_ID = ResourceLocation.fromNamespaceAndPath((String)"umapyoi", (String)"jei_plugin");
    public static final RecipeType<JEISimpleRecipe> GACHA_JEI_TYPE = RecipeType.create((String)"umapyoi", (String)"gacha_recipe", JEISimpleRecipe.class);
    public static final RecipeType<JEISimpleRecipe> DISASSEMBLY_JEI_TYPE = RecipeType.create((String)"umapyoi", (String)"disassembly_recipe", JEISimpleRecipe.class);

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new JEIGachaCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new JEIDisassemblyCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(DISASSEMBLY_JEI_TYPE, this.getAllDisassemblyRecipes());
        registration.addRecipes(GACHA_JEI_TYPE, this.getAllGachaRecipes());
    }

    private List<JEISimpleRecipe> getAllDisassemblyRecipes() {
        ArrayList result = Lists.newArrayList();
        result.add(UmapyoiJEIRecipes.disassembleUmasoul(((Item)ItemRegistry.CRYSTAL_SILVER.get()).getDefaultInstance(), GachaRanking.R));
        result.add(UmapyoiJEIRecipes.disassembleUmasoul(((Item)ItemRegistry.CRYSTAL_GOLD.get()).getDefaultInstance(), GachaRanking.SR));
        result.add(UmapyoiJEIRecipes.disassembleUmasoul(((Item)ItemRegistry.CRYSTAL_RAINBOW.get()).getDefaultInstance(), GachaRanking.SSR));
        result.add(UmapyoiJEIRecipes.disassembleSupportCard(((Item)ItemRegistry.HORSESHOE_SILVER.get()).getDefaultInstance(), GachaRanking.R));
        result.add(UmapyoiJEIRecipes.disassembleSupportCard(((Item)ItemRegistry.HORSESHOE_GOLD.get()).getDefaultInstance(), GachaRanking.SR));
        result.add(UmapyoiJEIRecipes.disassembleSupportCard(((Item)ItemRegistry.HORSESHOE_RAINBOW.get()).getDefaultInstance(), GachaRanking.SSR));
        return result;
    }

    private List<JEISimpleRecipe> getAllGachaRecipes() {
        return Lists.newArrayList((Object[])new JEISimpleRecipe[]{UmapyoiJEIRecipes.gachaUmasoul(Ingredient.of(UmapyoiItemTags.COMMON_GACHA_ITEM), GachaRanking.R), UmapyoiJEIRecipes.gachaUmasoul(DifferenceIngredient.of((Ingredient)DifferenceIngredient.of((Ingredient)DifferenceIngredient.of((Ingredient)Ingredient.of(UmapyoiItemTags.UMA_TICKET), (Ingredient)Ingredient.of(UmapyoiItemTags.SSR_UMA_TICKET)), (Ingredient)Ingredient.of(UmapyoiItemTags.SR_UMA_TICKET)), (Ingredient)Ingredient.of(UmapyoiItemTags.COMMON_GACHA_ITEM)), GachaRanking.R, GachaRanking.SR, GachaRanking.SSR), UmapyoiJEIRecipes.gachaUmasoul(Ingredient.of(UmapyoiItemTags.SR_UMA_TICKET), GachaRanking.SR, GachaRanking.SSR), UmapyoiJEIRecipes.gachaUmasoul(Ingredient.of(UmapyoiItemTags.SSR_UMA_TICKET), GachaRanking.SSR), UmapyoiJEIRecipes.gachaSupportCard(Ingredient.of(UmapyoiItemTags.COMMON_GACHA_ITEM), GachaRanking.R), UmapyoiJEIRecipes.gachaSupportCard(DifferenceIngredient.of((Ingredient)DifferenceIngredient.of((Ingredient)DifferenceIngredient.of((Ingredient)Ingredient.of(UmapyoiItemTags.CARD_TICKET), (Ingredient)Ingredient.of(UmapyoiItemTags.SSR_CARD_TICKET)), (Ingredient)Ingredient.of(UmapyoiItemTags.SR_CARD_TICKET)), (Ingredient)Ingredient.of(UmapyoiItemTags.COMMON_GACHA_ITEM)), GachaRanking.R, GachaRanking.SR, GachaRanking.SSR), UmapyoiJEIRecipes.gachaSupportCard(Ingredient.of(UmapyoiItemTags.SR_CARD_TICKET), GachaRanking.SR, GachaRanking.SSR), UmapyoiJEIRecipes.gachaSupportCard(Ingredient.of(UmapyoiItemTags.SSR_CARD_TICKET), GachaRanking.SSR)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((Item)ItemRegistry.DISASSEMBLY_BLOCK.get()).getDefaultInstance(), new RecipeType[]{DISASSEMBLY_JEI_TYPE});
        registration.addRecipeCatalyst(((Item)ItemRegistry.UMA_PEDESTAL.get()).getDefaultInstance(), new RecipeType[]{GACHA_JEI_TYPE});
        registration.addRecipeCatalyst(((Item)ItemRegistry.SILVER_UMA_PEDESTAL.get()).getDefaultInstance(), new RecipeType[]{GACHA_JEI_TYPE});
    }

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }
}

