/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.curios;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.events.ApplyUmasoulAttributeEvent;
import net.tracen.umapyoi.events.ResumeActionPointEvent;
import net.tracen.umapyoi.events.SettingPropertyEvent;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import net.tracen.umapyoi.utils.UmaStatusUtils;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class UmaSoulCuriosWrapper
implements ICurio {
    private final ItemStack stack;

    public UmaSoulCuriosWrapper(ItemStack stack) {
        this.stack = stack;
    }

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext) {
        return new ICurio.SoundInfo((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), 1.0f, 1.0f);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void curioTick(SlotContext slotContext) {
        if (!slotContext.identifier().equalsIgnoreCase("uma_soul")) {
            return;
        }
        LivingEntity entity = slotContext.entity();
        Level commandSenderWorld = entity.getCommandSenderWorld();
        if (this.getStack().isEmpty()) {
            return;
        }
        if (!commandSenderWorld.isClientSide()) {
            this.resumeActionPoint(entity);
        }
    }

    private void resumeActionPoint(LivingEntity entity) {
        if (((ResumeActionPointEvent)NeoForge.EVENT_BUS.post((Event)new ResumeActionPointEvent(entity, this.stack))).isCanceled()) {
            return;
        }
        if (UmaSoulUtils.getActionPoint(this.getStack()) != UmaSoulUtils.getMaxActionPoint(this.getStack())) {
            UmaSoulUtils.setActionPoint(this.getStack(), Math.min(UmaSoulUtils.getActionPoint(this.getStack()) + 1, UmaSoulUtils.getMaxActionPoint(this.getStack())));
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id) {
        LinkedHashMultimap atts = LinkedHashMultimap.create();
        LivingEntity user = slotContext.entity();
        if (!slotContext.identifier().equalsIgnoreCase("uma_soul")) {
            return atts;
        }
        CuriosApi.addSlotModifier((Multimap)atts, (String)"uma_suit", (ResourceLocation)id, (double)1.0, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE);
        atts.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(id, this.getExactProperty(user, UmaStatusUtils.StatusType.SPEED, (Double)UmapyoiConfig.UMASOUL_MAX_SPEED.get()), (Boolean)UmapyoiConfig.UMASOUL_SPEED_PRECENT_ENABLE.get() != false ? AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL : AttributeModifier.Operation.ADD_VALUE));
        atts.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(id, this.getExactProperty(user, UmaStatusUtils.StatusType.STRENGTH, (Double)UmapyoiConfig.UMASOUL_MAX_STRENGTH_ATTACK.get()), (Boolean)UmapyoiConfig.UMASOUL_STRENGTH_PRECENT_ENABLE.get() != false ? AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL : AttributeModifier.Operation.ADD_VALUE));
        atts.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(id, this.getExactProperty(user, UmaStatusUtils.StatusType.STAMINA, (Double)UmapyoiConfig.UMASOUL_MAX_STAMINA_HEALTH.get()), (Boolean)UmapyoiConfig.UMASOUL_STAMINA_PRECENT_ENABLE.get() != false ? AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL : AttributeModifier.Operation.ADD_VALUE));
        atts.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(id, this.getExactProperty(user, UmaStatusUtils.StatusType.GUTS, (Double)UmapyoiConfig.UMASOUL_MAX_GUTS_ARMOR.get()), (Boolean)UmapyoiConfig.UMASOUL_GUTS_PRECENT_ENABLE.get() != false ? AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL : AttributeModifier.Operation.ADD_VALUE));
        atts.put((Object)Attributes.ARMOR_TOUGHNESS, (Object)new AttributeModifier(id, this.getExactProperty(user, UmaStatusUtils.StatusType.GUTS, (Double)UmapyoiConfig.UMASOUL_MAX_GUTS_ARMOR_TOUGHNESS.get()), (Boolean)UmapyoiConfig.UMASOUL_GUTS_PRECENT_ENABLE.get() != false ? AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL : AttributeModifier.Operation.ADD_VALUE));
        ApplyUmasoulAttributeEvent event = new ApplyUmasoulAttributeEvent(this.getStack(), slotContext, id, (Multimap<Holder<Attribute>, AttributeModifier>)atts);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getAttributes();
    }

    public double getExactProperty(LivingEntity user, UmaStatusUtils.StatusType type, double limit) {
        double retiredValue = !this.getStack().has(DataComponentsTypeRegistry.UMADATA_TRAINING) ? 1.0 : 0.25;
        int rate = 0;
        switch (type) {
            case SPEED: {
                rate = UmaSoulUtils.getPropertyRate(this.getStack()).speed();
                break;
            }
            case STAMINA: {
                rate = UmaSoulUtils.getPropertyRate(this.getStack()).stamina();
                break;
            }
            case STRENGTH: {
                rate = UmaSoulUtils.getPropertyRate(this.getStack()).strength();
                break;
            }
            case GUTS: {
                rate = UmaSoulUtils.getPropertyRate(this.getStack()).guts();
                break;
            }
            case WISDOM: {
                rate = UmaSoulUtils.getPropertyRate(this.getStack()).wisdom();
            }
        }
        double propertyRate = 1.0 + (double)rate / 100.0;
        double totalProperty = this.propertyPercentage(type);
        SettingPropertyEvent event = new SettingPropertyEvent(user, this.getStack(), retiredValue, propertyRate, totalProperty);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getResultProperty() * limit;
    }

    private double propertyPercentage(UmaStatusUtils.StatusType type) {
        int x = 0;
        switch (type) {
            case SPEED: {
                x = UmaSoulUtils.getProperty(this.getStack()).speed();
                break;
            }
            case STAMINA: {
                x = UmaSoulUtils.getProperty(this.getStack()).stamina();
                break;
            }
            case STRENGTH: {
                x = UmaSoulUtils.getProperty(this.getStack()).strength();
                break;
            }
            case GUTS: {
                x = UmaSoulUtils.getProperty(this.getStack()).guts();
                break;
            }
            case WISDOM: {
                x = UmaSoulUtils.getProperty(this.getStack()).wisdom();
            }
        }
        Integer statLimit = (Integer)UmapyoiConfig.STAT_LIMIT_VALUE.get();
        double denominator = 1.0 + Math.pow(Math.E, (x > statLimit ? -0.125 * (Double)UmapyoiConfig.STAT_LIMIT_REDUCTION_RATE.get() : -0.125) * (double)(x - statLimit));
        return 1.0 / denominator;
    }
}

