/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.events.handler;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.effect.MobEffectRegistry;
import net.tracen.umapyoi.events.ApplyFactorEvent;
import net.tracen.umapyoi.events.ApplyTrainingSupportEvent;
import net.tracen.umapyoi.events.SkillEvent;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.registry.umadata.Motivations;
import net.tracen.umapyoi.registry.umadata.UmaDataExtraStatus;
import net.tracen.umapyoi.utils.ResultRankingUtils;
import net.tracen.umapyoi.utils.UmaSkillUtils;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import net.tracen.umapyoi.utils.UmaStatusUtils;

@EventBusSubscriber
public class CommonEvents {
    @SubscribeEvent
    public static void onDamageDownMotivation(LivingDamageEvent.Post event) {
        LivingEntity entityLiving = event.getEntity();
        ItemStack soul = UmapyoiAPI.getUmaSoul(entityLiving);
        if (soul.isEmpty()) {
            return;
        }
        if ((double)event.getNewDamage() < (Double)UmapyoiConfig.DAMAGE_MOTIVATION_EFFECT.get()) {
            return;
        }
        if ((Double)UmapyoiConfig.CHANCE_MOTIVATION_EFFECT.get() > 0.0 && entityLiving.level().getRandom().nextDouble() <= (Double)UmapyoiConfig.CHANCE_MOTIVATION_EFFECT.get()) {
            UmaStatusUtils.downMotivation(soul);
        }
    }

    @SubscribeEvent
    public static void onDamagePanicking(LivingDamageEvent.Post event) {
        LivingEntity entityLiving = event.getEntity();
        ItemStack soul = UmapyoiAPI.getUmaSoul(entityLiving);
        if (soul.isEmpty() || UmaSoulUtils.getMotivation(soul) != Motivations.BAD) {
            return;
        }
        if ((double)event.getNewDamage() < (Double)UmapyoiConfig.DAMAGE_MOTIVATION_EFFECT.get()) {
            return;
        }
        if ((Double)UmapyoiConfig.CHANCE_MOTIVATION_EFFECT.get() > 0.0 && entityLiving.level().getRandom().nextDouble() <= (Double)UmapyoiConfig.CHANCE_MOTIVATION_EFFECT.get()) {
            entityLiving.addEffect(new MobEffectInstance(MobEffectRegistry.PANICKING, 3600));
        }
    }

    @SubscribeEvent
    public static void onTrainingFinished(ApplyTrainingSupportEvent.Post event) {
        ItemStack umaSoul = event.getUmaSoul();
        UmaSkillUtils.syncActionPoint(umaSoul);
        umaSoul.update(DataComponentsTypeRegistry.UMADATA_EXTRA_STATUS, (Object)UmaDataExtraStatus.DEFAULT, data -> new UmaDataExtraStatus(data.actionPoint(), data.extraActionPoint(), ResultRankingUtils.generateRanking(umaSoul), data.motivation()));
    }

    @SubscribeEvent
    public static void onFactorFinished(ApplyFactorEvent.Post event) {
        ItemStack umaSoul = event.getUmaSoul();
        UmaSkillUtils.syncActionPoint(umaSoul);
        umaSoul.update(DataComponentsTypeRegistry.UMADATA_EXTRA_STATUS, (Object)UmaDataExtraStatus.DEFAULT, data -> new UmaDataExtraStatus(data.actionPoint(), data.extraActionPoint(), ResultRankingUtils.generateRanking(umaSoul), data.motivation()));
    }

    @SubscribeEvent
    public static void onSkillLearned(SkillEvent.LearnSkillEvent event) {
        ItemStack umaSoul = event.getUmaSoul();
        UmaSkillUtils.syncActionPoint(umaSoul);
        umaSoul.update(DataComponentsTypeRegistry.UMADATA_EXTRA_STATUS, (Object)UmaDataExtraStatus.DEFAULT, data -> new UmaDataExtraStatus(data.actionPoint(), data.extraActionPoint(), ResultRankingUtils.generateRanking(umaSoul), data.motivation()));
    }
}

