/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.item.food;

import cn.mcmod_mmf.mmlib.item.ItemFoodBase;
import cn.mcmod_mmf.mmlib.item.info.FoodInfo;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.tracen.umapyoi.Umapyoi;
import net.tracen.umapyoi.api.UmapyoiAPI;

public class UmaFoodItem
extends ItemFoodBase {
    private final Consumer<ItemStack> consumer;

    public UmaFoodItem(Consumer<ItemStack> consumer, FoodInfo info) {
        super(Umapyoi.defaultItemProperties().food(new FoodProperties(info.getAmount(), info.getCalories(), info.isAlwaysEat(), (float)info.getEatTime(), Optional.empty(), List.of())), info);
        this.consumer = consumer;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        ItemStack itemstack = this.eatAsUma(stack, level, entity);
        if (stack.getCount() > 0) {
            if (entity instanceof Player) {
                Player entityplayer = (Player)entity;
                if (entityplayer.getAbilities().instabuild) {
                    return itemstack;
                }
                if (!entityplayer.addItem(this.getCraftingRemainingItem(stack))) {
                    entityplayer.drop(this.getCraftingRemainingItem(stack), true);
                }
            }
            return itemstack;
        }
        return entity instanceof Player && ((Player)entity).getAbilities().instabuild ? itemstack : this.getCraftingRemainingItem(stack);
    }

    private ItemStack eatAsUma(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (UmapyoiAPI.getUmaSoul((LivingEntity)player).isEmpty()) {
                player.getFoodData().eat(stack.getFoodProperties(entity));
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                return stack;
            }
            this.consumer.accept(UmapyoiAPI.getUmaSoul((LivingEntity)player));
        }
        return entity.eat(level, stack);
    }
}

