/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.mixin;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import net.tracen.umapyoi.utils.UmaStatusUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class}, priority=10)
public class PlayerFoodExhaustionMixin {
    @Inject(method={"causeFoodExhaustion"}, at={@At(value="HEAD")}, cancellable=true)
    private void foodExhaustion(float pExhaustion, CallbackInfo ci) {
        Player player = (Player)this;
        ItemStack umaSoul = UmapyoiAPI.getUmaSoul((LivingEntity)player);
        if (!umaSoul.isEmpty()) {
            if (!player.getAbilities().invulnerable && !player.level().isClientSide()) {
                double exhaustionMultipler = 1.2 - this.getExactProperty(umaSoul, UmaStatusUtils.StatusType.STAMINA, 0.85f);
                player.getFoodData().addExhaustion((float)((double)pExhaustion * exhaustionMultipler));
            }
            ci.cancel();
        }
    }

    public double getExactProperty(ItemStack stack, UmaStatusUtils.StatusType type, double limit) {
        double retiredValue = !stack.has(DataComponentsTypeRegistry.UMADATA_TRAINING) ? 1.0 : 0.25;
        int rate = 0;
        switch (type) {
            case SPEED: {
                rate = UmaSoulUtils.getPropertyRate(stack).speed();
                break;
            }
            case STAMINA: {
                rate = UmaSoulUtils.getPropertyRate(stack).stamina();
                break;
            }
            case STRENGTH: {
                rate = UmaSoulUtils.getPropertyRate(stack).strength();
                break;
            }
            case GUTS: {
                rate = UmaSoulUtils.getPropertyRate(stack).guts();
                break;
            }
            case WISDOM: {
                rate = UmaSoulUtils.getPropertyRate(stack).wisdom();
            }
        }
        double propertyRate = 1.0 + (double)rate / 100.0;
        double totalProperty = this.propertyPercentage(stack, type);
        return (double)UmaSoulUtils.getMotivation(stack).getMultiplier() * limit * propertyRate * retiredValue * totalProperty;
    }

    private double propertyPercentage(ItemStack stack, UmaStatusUtils.StatusType type) {
        int x = 0;
        switch (type) {
            case SPEED: {
                x = UmaSoulUtils.getProperty(stack).speed();
                break;
            }
            case STAMINA: {
                x = UmaSoulUtils.getProperty(stack).stamina();
                break;
            }
            case STRENGTH: {
                x = UmaSoulUtils.getProperty(stack).strength();
                break;
            }
            case GUTS: {
                x = UmaSoulUtils.getProperty(stack).guts();
                break;
            }
            case WISDOM: {
                x = UmaSoulUtils.getProperty(stack).wisdom();
            }
        }
        Integer statLimit = (Integer)UmapyoiConfig.STAT_LIMIT_VALUE.get();
        double denominator = 1.0 + Math.pow(Math.E, (x > statLimit ? -0.125 * (Double)UmapyoiConfig.STAT_LIMIT_REDUCTION_RATE.get() : -0.125) * (double)(x - statLimit));
        return 1.0 / denominator;
    }
}

